/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import java.util.EnumMap;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.BlockTemplates;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Doors;
import net.paradisemod.building.FenceGates;
import net.paradisemod.building.Fences;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.building.Slabs;
import net.paradisemod.building.Stairs;
import net.paradisemod.building.Trapdoors;
import net.paradisemod.building.Walls;
import net.paradisemod.misc.Misc;

public class Building {
    public static final EnumMap<GlowingObsidianColor, RegisteredBlock> GLOWING_OBSIDIAN = new EnumMap(GlowingObsidianColor.class);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN = Building.regGlowingObsidian(GlowingObsidianColor.COPPER);
    public static final RegisteredBlock CACTUS_BLOCK = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("cactus_block", () -> new Block(BlockType.WOOD.getProperties())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tag((TagKey<Block>)BlockTags.f_13090_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("cc").m_126130_("cc").m_126127_(Character.valueOf('c'), (ItemLike)Blocks.f_50128_))).localizedName("Cactus Block", "Bloque de cactus");
    public static final RegisteredBlock POLISHED_END_STONE = (RegisteredBlock)BlockTemplates.cutImprovedRock("polished_end_stone", (ItemLike)Blocks.f_50259_, new ItemLike[0]).localizedName("Polished End Stone", "Piedra pulida del Fin");
    public static final RegisteredBlock ASPHALT = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("asphalt").tag((TagKey<Block>)BlockTags.f_13058_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("aa").m_126130_("aa").m_126127_(Character.valueOf('a'), (ItemLike)Misc.ASPHALT_SHARD))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).localizedName("Asphalt", "Asfalto");
    public static final RegisteredBlock POLISHED_ASPHALT = (RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("polished_asphalt").recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 4).m_126130_("aS").m_126130_("Sa").m_126127_(Character.valueOf('a'), (ItemLike)ASPHALT).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50069_))).localizedName("Polished Asphalt", "Asfalto pulido");
    public static final RegisteredBlock POLISHED_ASPHALT_BRICKS = (RegisteredBlock)BlockTemplates.cutRock("polished_asphalt_bricks", POLISHED_ASPHALT, new ItemLike[0]).localizedName("Polished Asphalt Bricks", "Ladrillos de asfalto pulido");
    public static final RegisteredBlock POLISHED_DRIPSTONE = (RegisteredBlock)BlockTemplates.rock("polished_dripstone", Blocks.f_152537_).localizedName("Polished Dripstone", "Caliza pulida");
    public static final RegisteredBlock POLISHED_CALCITE = (RegisteredBlock)BlockTemplates.rock("polished_calcite", Blocks.f_152497_).localizedName("Polished Calcite", "Calcita pulida");
    public static final RegisteredBlock POLISHED_TUFF = (RegisteredBlock)BlockTemplates.rock("polished_tuff", Blocks.f_152496_).localizedName("Polished Tuff", "Toba pulida");
    public static final RegisteredBlock CHISELED_POLISHED_DRIPSTONE = (RegisteredBlock)BlockTemplates.cutRock("chiseled_polished_dripstone", POLISHED_DRIPSTONE, new ItemLike[]{Blocks.f_152537_}).localizedName("Chiseled Polished Dripstone", "Caliza pulida grabada");
    public static final RegisteredBlock CHISELED_POLISHED_CALCITE = (RegisteredBlock)BlockTemplates.cutRock("chiseled_polished_calcite", POLISHED_CALCITE, new ItemLike[]{Blocks.f_152497_}).localizedName("Chiseled Polished Calcite", "Calcita pulida grabada");
    public static final RegisteredBlock CHISELED_POLISHED_TUFF = (RegisteredBlock)BlockTemplates.cutRock("chiseled_polished_tuff", POLISHED_TUFF, new ItemLike[]{Blocks.f_152496_}).localizedName("Chiseled Polished Tuff", "Toba pulida grabada");
    public static final RegisteredBlock POLISHED_DRIPSTONE_BRICKS = (RegisteredBlock)BlockTemplates.cutRock("polished_dripstone_bricks", POLISHED_DRIPSTONE, new ItemLike[]{Blocks.f_152537_}).localizedName("Polished Dripstone Bricks", "Ladrillos de caliza pulida");
    public static final RegisteredBlock POLISHED_CALCITE_BRICKS = (RegisteredBlock)BlockTemplates.cutRock("polished_calcite_bricks", POLISHED_CALCITE, new ItemLike[]{Blocks.f_152497_}).localizedName("Polished Calcite Bricks", "Ladrillos de calcita pulida");
    public static final RegisteredBlock POLISHED_TUFF_BRICKS = (RegisteredBlock)BlockTemplates.cutRock("polished_tuff_bricks", POLISHED_TUFF, new ItemLike[]{Blocks.f_152496_}).localizedName("Polished Tuff Bricks", "Ladrillos de toba pulida");
    public static final RegisteredBlock PALO_VERDE_PLANKS = BlockTemplates.planks("palo_verde", false);
    public static final RegisteredBlock MESQUITE_PLANKS = BlockTemplates.planks("mesquite", false);

    public static void init() {
        Doors.init();
        Fences.init();
        FenceGates.init();
        Slabs.init();
        Stairs.init();
        Trapdoors.init();
        Walls.init();
        ParadiseMod.LOG.info("Loaded Building module");
    }

    private static RegisteredBlock regGlowingObsidian(GlowingObsidianColor color) {
        RegisteredBlock obsidian = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.getName() + "_glowing_obsidian", () -> new Block(BlockType.STRONG_STONE.getProperties().m_60953_(s -> 7))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tag(PMTags.Blocks.GLOWING_OBSIDIAN).blockStateGenerator((block, generator) -> generator.simpleBlock((RegisteredBlock)block, "glowing_obsidian/" + color.getName())).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "glowing_obsidian/" + color.getName())).localizedName(color.localizedName(false) + " Glowing Obsidian", "Obsidiana brillante " + color.localizedName(true));
        GLOWING_OBSIDIAN.put(color, obsidian);
        return obsidian;
    }
}

