/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import java.util.ArrayList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.building.blocks.RedstoneDoor;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;

public class Doors {
    public static final RegisteredBlock ANDESITE_DOOR = Doors.regDoor("andesite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50334_);
    public static final RegisteredBlock BEDROCK_DOOR = Doors.regDoor("bedrock", BlockType.INDESTRUCTIBLE, 0, true, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock COBBLESTONE_DOOR = Doors.regDoor("cobblestone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50652_);
    public static final RegisteredBlock DIORITE_DOOR = Doors.regDoor("diorite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50228_);
    public static final RegisteredBlock END_STONE_DOOR = Doors.regDoor("end_stone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50259_);
    public static final RegisteredBlock GRANITE_DOOR = Doors.regDoor("granite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50122_);
    public static final RegisteredBlock MOSSY_COBBLESTONE_DOOR = Doors.regDoor("mossy_cobblestone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50079_);
    public static final RegisteredBlock OBSIDIAN_DOOR = Doors.regDoor("obsidian", BlockType.STRONG_STONE, 0, true, (ItemLike)Blocks.f_50080_);
    public static final RegisteredBlock STONE_DOOR = Doors.regDoor("stone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50069_);
    public static final RegisteredBlock DIAMOND_DOOR = Doors.regDoor("diamond", BlockType.METAL, 0, true, (ItemLike)Items.f_42415_);
    public static final RegisteredBlock GOLD_DOOR = Doors.regDoor("gold", BlockType.METAL, 0, true, (ItemLike)Items.f_42417_);
    public static final RegisteredBlock EMERALD_DOOR = Doors.regDoor("emerald", BlockType.WEAK_METAL, 0, true, (ItemLike)Items.f_42616_);
    public static final RegisteredBlock RUBY_DOOR = Doors.regDoor("ruby", BlockType.WEAK_METAL, 0, true, Misc.RUBY);
    public static final RegisteredBlock RUSTED_IRON_DOOR = Doors.regDoor("rusted_iron", BlockType.METAL, 0, true, Misc.RUSTED_IRON_INGOT);
    public static final RegisteredBlock SILVER_DOOR = Doors.regDoor("silver", BlockType.METAL, 0, true, Misc.SILVER_INGOT);
    public static final RegisteredBlock REDSTONE_DOOR = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("redstone_door", RedstoneDoor::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(BlockTags.f_144282_, BlockTags.f_144285_).lootTable((block, generator) -> generator.doorDrop((Block)block)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("##").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42451_))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 9).m_126130_("##").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50330_))).localizedName("Redstone Door", "Puerta de piedra roja");
    public static final RegisteredBlock CACTUS_DOOR = Doors.regDoor("cactus", BlockType.WOOD, 0, true, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_DOOR = Doors.regDoor("palo_verde", BlockType.WOOD, 0, false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_DOOR = Doors.regDoor("mesquite", BlockType.WOOD, 0, false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock GLASS_DOOR = Doors.regDoor("glass", BlockType.GLASS, 0, false, (ItemLike)Blocks.f_50058_);
    public static final RegisteredBlock BLACKENED_OAK_DOOR = (RegisteredBlock)Doors.regDoor("blackened_oak", BlockType.WOOD, 0, false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_DOOR = (RegisteredBlock)Doors.regDoor("blackened_spruce", BlockType.WOOD, 0, false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_DOOR = (RegisteredBlock)Doors.regDoor("glowing_oak", BlockType.WOOD, 7, true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_DOOR = (RegisteredBlock)Doors.regDoor("glowing_cactus", BlockType.WOOD, 7, true, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_DOOR = Doors.regGlowingObsidianDoor(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regGlowingObsidianDoor(GlowingObsidianColor color) {
        RegisteredBlock glowingObsidian = Building.GLOWING_OBSIDIAN.get((Object)color);
        return (RegisteredBlock)Doors.regDoor(color.getName() + "_glowing_obsidian", BlockType.STRONG_STONE, 7, true, glowingObsidian).localizedName(color.localizedName(false) + " Glowing Obsidian Door", "Puerta de obsidiana brillante " + color.localizedName(true));
    }

    private static RegisteredBlock regDoor(String name, BlockType type, int lightLevel, boolean fancy, ItemLike craftItem) {
        BlockSetType blockSetType = switch (type) {
            case BlockType.WEAK_METAL -> PMBlockSetTypes.WEAK_METAL;
            case BlockType.METAL -> PMBlockSetTypes.METAL;
            case BlockType.GLASS -> PMBlockSetTypes.GLASS;
            case BlockType.WOOD -> PMBlockSetTypes.VARIANT_WOOD;
            default -> PMBlockSetTypes.VARIANT_STONE;
        };
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        if (type == BlockType.WOOD) {
            tags.add(BlockTags.f_13095_);
        } else {
            tags.add(BlockTags.f_13103_);
            tags.addAll(type.tags());
        }
        RegisteredBlock doorBlock = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_door", () -> new DoorBlock(type.getProperties().m_60953_(s -> lightLevel).m_60955_(), blockSetType)).recipe((item, generator) -> {
            ShapedRecipeBuilder recipe = generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 3).m_126130_("##").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), craftItem);
            if (type.isMetal()) {
                recipe = recipe.m_126145_("metal_doors");
            }
            return recipe;
        })).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(tags).itemModel((door, generator) -> generator.basicItem(door.m_5456_(), "door/" + name, type == BlockType.GLASS ? "translucent" : "cutout")).blockStateGenerator((door, generator) -> Doors.genDoorBlockState(name, type, fancy, door, generator)).lootTable((block, generator) -> generator.doorDrop((Block)block)).localizedName(Utils.localizedMaterialName(name, false) + " Door", "Puerta de " + Utils.localizedMaterialName(name, true));
        if (type.isStone()) {
            doorBlock = (RegisteredBlock)doorBlock.recipe((item, generator) -> generator.stonecutterRecipe(craftItem, (ItemLike)item));
        }
        return doorBlock;
    }

    private static void genDoorBlockState(String name, BlockType type, boolean fancy, RegisteredBlock door, BlockStateGenerator generator) {
        String renderType = type == BlockType.GLASS ? "cutout" : "solid";
        Object topTexture = "paradisemod:block/door/" + name + "_top";
        Object bottomTexture = "paradisemod:block/door/" + name + "_bottom";
        if (name.endsWith("_glowing_obsidian")) {
            String color = name.substring(0, name.length() - 17);
            bottomTexture = topTexture = "paradisemod:block/glowing_obsidian/" + color;
        } else if (type.isStone()) {
            bottomTexture = topTexture = "minecraft:block/" + name;
        } else if (name == "emerald") {
            bottomTexture = topTexture = "minecraft:block/emerald_block";
        } else if (name == "ruby") {
            bottomTexture = topTexture = "paradisemod:block/ruby_block";
        }
        BlockModelProvider modelBuilder = generator.models();
        ModelFile bottom = Doors.genDoorModel(name, (String)topTexture, (String)bottomTexture, "bottom", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorBottomLeft(arg_0, arg_1, arg_2));
        ModelFile bottomHinge = Doors.genDoorModel(name, (String)topTexture, (String)bottomTexture, "bottom_hinge", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorBottomRight(arg_0, arg_1, arg_2));
        if (name == "glass") {
            bottomHinge = Doors.genDoorModel(name, (String)topTexture, (String)bottomTexture, "bottom_hinge", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorBottomLeft(arg_0, arg_1, arg_2));
        }
        ModelFile top = Doors.genDoorModel(name, (String)topTexture, (String)bottomTexture, "top", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorTopLeft(arg_0, arg_1, arg_2));
        ModelFile topHinge = Doors.genDoorModel(name, (String)topTexture, (String)bottomTexture, "top_hinge", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorTopRight(arg_0, arg_1, arg_2));
        if (name == "glass") {
            topHinge = Doors.genDoorModel(name, (String)topTexture + "_left", (String)bottomTexture, "top_hinge", renderType, fancy, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorTopLeft(arg_0, arg_1, arg_2));
        }
        generator.doorBlock((DoorBlock)door.get(), bottom, bottomHinge, bottomHinge, bottom, top, topHinge, topHinge, top);
    }

    public static ModelFile genDoorModel(String name, String topTexture, String bottomTexture, String suffix, String renderType, boolean fancy, BlockStateGenerator generator, DoorModelGenerator modelGenerator) {
        BlockModelProvider modelBuilder = generator.models();
        String modelName = "door/" + name + "_" + suffix;
        if (fancy) {
            try {
                return generator.existingModel(modelName);
            }
            catch (Exception e) {
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/" + modelName, generator.modLoc("block/template/custom_door_" + suffix))).texture("top", new ResourceLocation(topTexture))).texture("bottom", new ResourceLocation(bottomTexture))).renderType(new ResourceLocation(renderType));
                if (renderType != "solid") {
                    model = (BlockModelBuilder)model.renderType(renderType);
                }
                return model;
            }
        }
        BlockModelBuilder model = modelGenerator.generate("block/" + modelName, new ResourceLocation(bottomTexture), new ResourceLocation(topTexture));
        if (renderType != "solid") {
            model = (BlockModelBuilder)model.renderType(renderType);
        }
        return model;
    }

    @FunctionalInterface
    public static interface DoorModelGenerator {
        public BlockModelBuilder generate(String var1, ResourceLocation var2, ResourceLocation var3);
    }
}

