/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import java.util.ArrayList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.Fences;
import net.paradisemod.building.blocks.RedstoneFenceGate;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;

public class FenceGates {
    private static WoodType METAL_GATE = FenceGates.fenceGateType("metal_gate", PMBlockSetTypes.WEAK_METAL);
    private static WoodType BRICK_GATE = FenceGates.fenceGateType("brick_gate", PMBlockSetTypes.VARIANT_STONE);
    public static final RegisteredBlock BRICK_FENCE_GATE = FenceGates.regFenceGate(BlockType.STONE, "brick", false, (ItemLike)Items.f_42460_, (ItemLike)Blocks.f_50076_);
    public static final RegisteredBlock CACTUS_FENCE_GATE = FenceGates.regFenceGate(BlockType.WOOD, "cactus", false, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_FENCE_GATE = FenceGates.regFenceGate(BlockType.WOOD, "palo_verde", false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_FENCE_GATE = FenceGates.regFenceGate(BlockType.WOOD, "mesquite", false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock DIAMOND_FENCE_GATE = FenceGates.regFenceGate(BlockType.METAL, "diamond", false, (ItemLike)Items.f_42415_, (ItemLike)Blocks.f_50090_);
    public static final RegisteredBlock EMERALD_FENCE_GATE = FenceGates.regFenceGate(BlockType.METAL, "emerald", false, (ItemLike)Items.f_42616_, (ItemLike)Blocks.f_50268_);
    public static final RegisteredBlock GOLD_FENCE_GATE = FenceGates.regFenceGate(BlockType.METAL, "gold", false, (ItemLike)Items.f_42417_, (ItemLike)Blocks.f_50074_);
    public static final RegisteredBlock IRON_FENCE_GATE = FenceGates.regFenceGate(BlockType.WEAK_METAL, "iron", false, (ItemLike)Items.f_42416_, (ItemLike)Blocks.f_50075_);
    public static final RegisteredBlock REDSTONE_FENCE_GATE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("redstone_fence_gate", RedstoneFenceGate::new).tags(Tags.Blocks.FENCE_GATES, BlockTags.f_144282_, BlockTags.f_144285_).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("SPS").m_126130_("SPS").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50330_))).localizedName("Redstone Fence Gate", "Puerta de valla de piedra roja");
    public static final RegisteredBlock RUBY_FENCE_GATE = FenceGates.regFenceGate(BlockType.METAL, "ruby", false, Misc.RUBY, Ores.RUBY_BLOCK);
    public static final RegisteredBlock RUSTED_IRON_FENCE_GATE = FenceGates.regFenceGate(BlockType.WEAK_METAL, "rusted_iron", false, Misc.RUSTED_IRON_INGOT, Ores.RUSTED_IRON_BLOCK);
    public static final RegisteredBlock SILVER_FENCE_GATE = FenceGates.regFenceGate(BlockType.METAL, "silver", false, Misc.SILVER_INGOT, Ores.SILVER_BLOCK);
    public static final RegisteredBlock BLACKENED_OAK_FENCE_GATE = (RegisteredBlock)FenceGates.regFenceGate(BlockType.WOOD, "blackened_oak", false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_FENCE_GATE = (RegisteredBlock)FenceGates.regFenceGate(BlockType.WOOD, "blackened_spruce", false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_FENCE_GATE = (RegisteredBlock)FenceGates.regFenceGate(BlockType.WOOD, "glowing_oak", true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_FENCE_GATE = (RegisteredBlock)FenceGates.regFenceGate(BlockType.WOOD, "glowing_cactus", true, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);

    public static void init() {
    }

    private static RegisteredBlock regFenceGate(BlockType type, String name, boolean glows, ItemLike planks) {
        return FenceGates.regFenceGate(type, name, glows, (ItemLike)Items.f_42398_, planks);
    }

    private static RegisteredBlock regFenceGate(BlockType type, String name, boolean glows, ItemLike craftItem, ItemLike craftBlock) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        WoodType gateType = type == BlockType.WEAK_METAL || type == BlockType.METAL ? METAL_GATE : (type == BlockType.STONE ? BRICK_GATE : WoodType.f_61830_);
        if (type == BlockType.WOOD) {
            tags.add(Tags.Blocks.FENCE_GATES_WOODEN);
            tags.add(BlockTags.f_13055_);
        } else {
            tags.add(Tags.Blocks.FENCE_GATES);
            tags.addAll(type.tags());
        }
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_fence_gate", () -> new FenceGateBlock(type.getProperties().m_60953_(s -> glows ? 7 : 0), gateType)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(tags).blockStateGenerator((gate, generator) -> FenceGates.genGateBlockState(name, gate, generator)).itemModelAlreadyExists().recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("SPS").m_126130_("SPS").m_126127_(Character.valueOf('S'), craftItem).m_126127_(Character.valueOf('P'), craftBlock))).localizedName(Utils.localizedMaterialName(name, false) + " Fence Gate", "Puerta de valla de " + Utils.localizedMaterialName(name, true));
    }

    private static void genGateBlockState(String name, RegisteredBlock gateBlock, BlockStateGenerator generator) {
        String modelName = "block/fence_gate/" + name;
        BlockModelProvider modelBuilder = generator.models();
        ResourceLocation texture = Fences.fenceTexture(name);
        BlockModelBuilder gate = (BlockModelBuilder)modelBuilder.fenceGate(modelName, texture);
        BlockModelBuilder gateOpen = (BlockModelBuilder)modelBuilder.fenceGateOpen(modelName + "_open", texture);
        BlockModelBuilder gateWall = (BlockModelBuilder)modelBuilder.fenceGateWall(modelName + "_wall", texture);
        BlockModelBuilder gateWallOpen = (BlockModelBuilder)modelBuilder.fenceGateWallOpen(modelName + "_wall_open", texture);
        generator.itemModels().parentBlockItem(gateBlock.get(), "fence_gate/" + name);
        generator.fenceGateBlock((FenceGateBlock)gateBlock.get(), (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    private static WoodType fenceGateType(String name, BlockSetType blockSetType) {
        return new WoodType(name, blockSetType, blockSetType.f_271136_(), SoundType.f_244174_, SoundEvents.f_11872_, SoundEvents.f_11873_);
    }
}

