/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;

public class Fences {
    public static final RegisteredBlock BRICK_FENCE = Fences.regFence(BlockType.STONE, "brick", false, (ItemLike)Items.f_42460_, (ItemLike)Blocks.f_50076_);
    public static final RegisteredBlock CACTUS_FENCE = Fences.regFence(BlockType.WOOD, "cactus", false, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_FENCE = Fences.regFence(BlockType.WOOD, "palo_verde", false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_FENCE = Fences.regFence(BlockType.WOOD, "mesquite", false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock DIAMOND_FENCE = Fences.regFence(BlockType.METAL, "diamond", false, (ItemLike)Items.f_42415_, (ItemLike)Blocks.f_50090_);
    public static final RegisteredBlock EMERALD_FENCE = Fences.regFence(BlockType.METAL, "emerald", false, (ItemLike)Items.f_42616_, (ItemLike)Blocks.f_50268_);
    public static final RegisteredBlock GOLD_FENCE = Fences.regFence(BlockType.METAL, "gold", false, (ItemLike)Items.f_42417_, (ItemLike)Blocks.f_50074_);
    public static final RegisteredBlock IRON_FENCE = Fences.regFence(BlockType.WEAK_METAL, "iron", false, (ItemLike)Items.f_42416_, (ItemLike)Blocks.f_50075_);
    public static final RegisteredBlock BLACKENED_OAK_FENCE = (RegisteredBlock)Fences.regFence(BlockType.WOOD, "blackened_oak", false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_FENCE = (RegisteredBlock)Fences.regFence(BlockType.WOOD, "blackened_spruce", false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_FENCE = (RegisteredBlock)Fences.regFence(BlockType.WOOD, "glowing_oak", true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_FENCE = (RegisteredBlock)Fences.regFence(BlockType.WOOD, "glowing_cactus", false, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock REDSTONE_FENCE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("redstone_fence", () -> new FenceBlock(BlockType.METAL.getProperties().m_60955_()){

        public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 15;
        }
    }).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(Tags.Blocks.FENCES, PMTags.Blocks.METAL_FENCES, BlockTags.f_13039_, BlockTags.f_144282_, BlockTags.f_144285_).itemModel((block, generator) -> generator.fenceInventory("redstone_fence", Fences.fenceTexture("redstone"))).blockStateGenerator((block, generator) -> Fences.genFenceBlockState("redstone", block, generator)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 3).m_126130_("PSP").m_126130_("PSP").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50330_))).localizedName("Redstone Fence", "Valla de piedra roja");
    public static final RegisteredBlock RUBY_FENCE = Fences.regFence(BlockType.METAL, "ruby", false, Misc.RUBY, Ores.RUBY_BLOCK);
    public static final RegisteredBlock RUSTED_IRON_FENCE = Fences.regFence(BlockType.WEAK_METAL, "rusted_iron", false, Misc.RUSTED_IRON_INGOT, Ores.RUSTED_IRON_BLOCK);
    public static final RegisteredBlock SILVER_FENCE = Fences.regFence(BlockType.METAL, "silver", false, Misc.SILVER_INGOT, Ores.SILVER_BLOCK);

    public static void init() {
    }

    private static RegisteredBlock regFence(BlockType type, String name, boolean glows, ItemLike planks) {
        return Fences.regFence(type, name, glows, (ItemLike)Items.f_42398_, planks);
    }

    private static RegisteredBlock regFence(BlockType type, String name, boolean glows, ItemLike craftItem, ItemLike craftBlock) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        ResourceLocation texture = Fences.fenceTexture(name);
        if (type == BlockType.METAL || type == BlockType.WEAK_METAL) {
            tags.add(PMTags.Blocks.METAL_FENCES);
        }
        if (type == BlockType.WOOD) {
            tags.add(Tags.Blocks.FENCES_WOODEN);
            tags.add(BlockTags.f_13098_);
        } else {
            tags.add(Tags.Blocks.FENCES);
            tags.addAll(type.tags());
        }
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_fence", () -> new FenceBlock(type.getProperties().m_60953_(s -> glows ? 7 : 0))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(tags).tags(BlockTags.f_13039_).itemModel((block, generator) -> generator.fenceInventory(name + "_fence", texture)).blockStateGenerator((block, generator) -> Fences.genFenceBlockState(name, block, generator)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 3).m_126130_("PSP").m_126130_("PSP").m_126127_(Character.valueOf('S'), craftItem).m_126127_(Character.valueOf('P'), craftBlock))).localizedName(Utils.localizedMaterialName(name, false) + " Fence", "Valla de " + Utils.localizedMaterialName(name, true));
    }

    public static ResourceLocation fenceTexture(String name) {
        return new ResourceLocation((String)(switch (name) {
            case "brick" -> "minecraft:block/bricks";
            case "cactus" -> "paradisemod:block/cactus_block";
            case "palo_verde", "mesquite", "blackened_oak", "blackened_spruce", "glowing_oak" -> "paradisemod:block/" + name + "_planks";
            case "diamond", "emerald", "gold", "iron", "redstone" -> "minecraft:block/" + name + "_block";
            default -> "paradisemod:block/" + name + "_block";
        }));
    }

    private static void genFenceBlockState(String name, RegisteredBlock fence, BlockStateGenerator generator) {
        ResourceLocation texture = Fences.fenceTexture(name);
        BlockModelProvider modelBuilder = generator.models();
        String modelName = "block/fence/" + name;
        BlockModelBuilder post = (BlockModelBuilder)modelBuilder.fencePost(modelName + "_post", texture);
        BlockModelBuilder side = (BlockModelBuilder)modelBuilder.fenceSide(modelName + "_side", texture);
        generator.fourWayBlock((CrossCollisionBlock)((FenceBlock)fence.get()), (ModelFile)post, (ModelFile)side);
    }
}

