/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.world.DeepDarkBlocks;

public class Slabs {
    public static final RegisteredBlock CACTUS_SLAB = Slabs.regWoodSlab("cactus", false, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_SLAB = Slabs.regWoodSlab("palo_verde", false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_SLAB = Slabs.regWoodSlab("mesquite", false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock BLACKENED_OAK_SLAB = (RegisteredBlock)Slabs.regWoodSlab("blackened_oak", false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_SLAB = (RegisteredBlock)Slabs.regWoodSlab("blackened_spruce", false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_SLAB = (RegisteredBlock)Slabs.regWoodSlab("glowing_oak", true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_SLAB = (RegisteredBlock)Slabs.regWoodSlab("glowing_cactus", true, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BEDROCK_SLAB = Slabs.regSlab("bedrock", BlockType.INDESTRUCTIBLE, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock END_STONE_SLAB = Slabs.regStoneSlab("end_stone", SoundType.f_56742_, (ItemLike)Blocks.f_50259_, new ItemLike[0]);
    public static final RegisteredBlock DRIPSTONE_SLAB = Slabs.regStoneSlab("dripstone", SoundType.f_154661_, (ItemLike)Blocks.f_152537_, new ItemLike[0]);
    public static final RegisteredBlock CALCITE_SLAB = Slabs.regStoneSlab("calcite", SoundType.f_154660_, (ItemLike)Blocks.f_152497_, new ItemLike[0]);
    public static final RegisteredBlock TUFF_SLAB = Slabs.regStoneSlab("tuff", SoundType.f_154659_, (ItemLike)Blocks.f_152496_, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_END_STONE_SLAB = Slabs.regStoneSlab("polished_end_stone", SoundType.f_56742_, Building.POLISHED_END_STONE, new ItemLike[]{Blocks.f_50259_});
    public static final RegisteredBlock POLISHED_DRIPSTONE_SLAB = Slabs.regStoneSlab("polished_dripstone", SoundType.f_154661_, Building.POLISHED_DRIPSTONE, new ItemLike[]{Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_SLAB = Slabs.regStoneSlab("polished_calcite", SoundType.f_154660_, Building.POLISHED_CALCITE, new ItemLike[]{Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_SLAB = Slabs.regStoneSlab("polished_tuff", SoundType.f_154659_, Building.POLISHED_TUFF, new ItemLike[]{Blocks.f_152496_});
    public static final RegisteredBlock DARKSTONE_SLAB = (RegisteredBlock)Slabs.regStoneSlab("darkstone", SoundType.f_56742_, DeepDarkBlocks.DARKSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DARKSTONE_SLAB = (RegisteredBlock)Slabs.regStoneSlab("polished_darkstone", SoundType.f_56742_, DeepDarkBlocks.POLISHED_DARKSTONE, DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DARKSTONE_BRICKS_SLAB = (RegisteredBlock)Slabs.regStoneSlab("polished_darkstone_bricks", SoundType.f_56742_, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS, DeepDarkBlocks.POLISHED_DARKSTONE, DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DRIPSTONE_BRICKS_SLAB = Slabs.regStoneSlab("polished_dripstone_bricks", SoundType.f_154661_, Building.POLISHED_DRIPSTONE_BRICKS, new ItemLike[]{Building.POLISHED_DRIPSTONE, Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_BRICKS_SLAB = Slabs.regStoneSlab("polished_calcite_bricks", SoundType.f_154660_, Building.POLISHED_CALCITE_BRICKS, new ItemLike[]{Building.POLISHED_CALCITE, Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_BRICKS_SLAB = Slabs.regStoneSlab("polished_tuff_bricks", SoundType.f_154659_, Building.POLISHED_TUFF_BRICKS, new ItemLike[]{Building.POLISHED_TUFF, Blocks.f_152496_});
    public static final RegisteredBlock OBSIDIAN_SLAB = Slabs.regSlab("obsidian", BlockType.STRONG_STONE, (ItemLike)Blocks.f_50080_);
    public static final RegisteredBlock POLISHED_ASPHALT_SLAB = Slabs.regStoneSlab("polished_asphalt", SoundType.f_56742_, Building.POLISHED_ASPHALT, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_ASPHALT_BRICKS_SLAB = Slabs.regStoneSlab("polished_asphalt_bricks", SoundType.f_56742_, Building.POLISHED_ASPHALT_BRICKS, Building.POLISHED_ASPHALT);
    public static final RegisteredBlock BLACKENED_SANDSTONE_SLAB = (RegisteredBlock)Slabs.regSandstoneSlab("blackened", SandstoneType.NORMAL, DeepDarkBlocks.BLACKENED_SANDSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock CUT_BLACKENED_SANDSTONE_SLAB = (RegisteredBlock)Slabs.regSandstoneSlab("blackened", SandstoneType.CUT, DeepDarkBlocks.CUT_BLACKENED_SANDSTONE, DeepDarkBlocks.BLACKENED_SANDSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock SMOOTH_BLACKENED_SANDSTONE_SLAB = (RegisteredBlock)Slabs.regSandstoneSlab("blackened", SandstoneType.SMOOTH, DeepDarkBlocks.CUT_BLACKENED_SANDSTONE, DeepDarkBlocks.BLACKENED_SANDSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_SLAB = Slabs.regGlowingObsidianSlab(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regSlab(String name, BlockType type, ItemLike craftItem) {
        return Slabs.regSlabInternal(name, type.getProperties(), craftItem).tags(type.tags()).tag((TagKey<Block>)BlockTags.f_13031_);
    }

    private static RegisteredBlock regWoodSlab(String name, boolean glows, ItemLike planks) {
        return Slabs.regSlabInternal(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_).m_60953_(s -> glows ? 7 : 0), planks).tag((TagKey<Block>)BlockTags.f_13097_);
    }

    private static RegisteredBlock regStoneSlab(String name, SoundType stoneSound, ItemLike stone, ItemLike ... stoneCuttingBlocks) {
        return (RegisteredBlock)((RegisteredBlock)Slabs.regSlabInternal(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50404_).m_60918_(stoneSound), stone).recipe((item, generator) -> generator.stonecutterRecipe(stone, (ItemLike)item, 2))).tags(BlockTags.f_13031_, BlockTags.f_144282_).stonecutterRecipes(2, stoneCuttingBlocks);
    }

    private static RegisteredBlock regSandstoneSlab(String name, SandstoneType type, ItemLike stone, ItemLike ... stoneCuttingBlocks) {
        return ((RegisteredBlock)((RegisteredBlock)Slabs.regSlabInternal(type.getName() + name + "_sandstone", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50406_), stone).recipe((item, generator) -> generator.stonecutterRecipe(stone, (ItemLike)item, 2))).tags(BlockTags.f_13031_, BlockTags.f_144282_).stonecutterRecipes(2, stoneCuttingBlocks)).blockStateGenerator((block, generator) -> Slabs.genSandstoneSlabBlockState(name, type, block, generator));
    }

    private static RegisteredBlock regGlowingObsidianSlab(GlowingObsidianColor color) {
        RegisteredBlock glowingObsidian = Building.GLOWING_OBSIDIAN.get((Object)color);
        return (RegisteredBlock)((RegisteredBlock)Slabs.regSlabInternal(color.getName() + "_glowing_obsidian", BlockType.STRONG_STONE.getProperties().m_60953_(s -> 7), glowingObsidian).recipe((item, generator) -> generator.stonecutterRecipe(glowingObsidian, (ItemLike)item, 2))).tag(PMTags.Blocks.GLOWING_OBSIDIAN_SLABS).blockStateGenerator((block, generator) -> Slabs.genGlowingObsidianSlabBlockState(color, block, generator)).localizedName(color.localizedName(false) + " Glowing Obsidian Slab", "Losa de obsidiana brillante " + color.localizedName(true));
    }

    private static RegisteredBlock regSlabInternal(String name, BlockBehaviour.Properties props, ItemLike craftItem) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_slab", () -> new SlabBlock(props)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).blockStateGenerator((block, generator) -> Slabs.genSlabBlockState(name, block, generator)).itemModelAlreadyExists().lootTable((block, generator) -> generator.slabDrop((Block)block)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 6).m_126130_("III").m_126127_(Character.valueOf('I'), craftItem))).localizedName(Utils.localizedMaterialName(name, false) + " Slab", "Losa de " + Utils.localizedMaterialName(name, true));
    }

    private static void genGlowingObsidianSlabBlockState(GlowingObsidianColor color, RegisteredBlock slabBlock, BlockStateGenerator generator) {
        String colorName = color.getName();
        ResourceLocation topTexture = new ResourceLocation("paradisemod:block/glowing_obsidian/" + colorName);
        ResourceLocation sideTexture = new ResourceLocation("paradisemod:block/glowing_obsidian/" + colorName + "_slab");
        Slabs.genSlabBlockState(colorName + "_glowing_obsidian", slabBlock, topTexture, topTexture, sideTexture, generator);
    }

    private static void genSandstoneSlabBlockState(String name, SandstoneType type, RegisteredBlock slabBlock, BlockStateGenerator generator) {
        String sandstoneName = type.getName() + name + "_sandstone";
        ResourceLocation topTexture = new ResourceLocation("paradisemod:block/" + name + "_sandstone_top");
        ResourceLocation bottomTexture = new ResourceLocation("paradisemod:block/" + name + "_sandstone" + (type == SandstoneType.NORMAL ? "_bottom" : "_top"));
        ResourceLocation sideTexture = new ResourceLocation("paradisemod:block/" + sandstoneName);
        if (type == SandstoneType.SMOOTH) {
            sideTexture = new ResourceLocation("paradisemod:block/" + name + "_sandstone_top");
        }
        Slabs.genSlabBlockState(sandstoneName, slabBlock, topTexture, bottomTexture, sideTexture, generator);
    }

    private static void genSlabBlockState(String name, RegisteredBlock slabBlock, BlockStateGenerator generator) {
        ResourceLocation topTexture = Slabs.slabTexture(name, false);
        ResourceLocation sideTexture = Slabs.slabTexture(name, true);
        Slabs.genSlabBlockState(name, slabBlock, topTexture, topTexture, sideTexture, generator);
    }

    private static void genSlabBlockState(String name, RegisteredBlock slabBlock, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation sideTexture, BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder slab = (BlockModelBuilder)modelBuilder.slab("block/slab/" + name, sideTexture, bottomTexture, topTexture);
        BlockModelBuilder slabTop = (BlockModelBuilder)modelBuilder.slabTop("block/slab/" + name + "_top", sideTexture, bottomTexture, topTexture);
        ModelFile.UncheckedModelFile doubleSlab = generator.uncheckedExistingModel(topTexture);
        if (name.contains("sandstone")) {
            doubleSlab = generator.uncheckedExistingModel(Slabs.slabTexture(name, false));
        }
        generator.slabBlock((SlabBlock)slabBlock.get(), (ModelFile)slab, (ModelFile)slabTop, (ModelFile)doubleSlab);
        generator.itemModels().parentBlockItem(slabBlock.get(), "slab/" + name);
    }

    protected static ResourceLocation slabTexture(String name, boolean side) {
        if (side && name.contains("polished") && !name.contains("bricks")) {
            return new ResourceLocation((String)(switch (name) {
                case "polished_end_stone", "polished_dripstone", "polished_calcite", "polished_tuff", "polished_darkstone", "polished_asphalt" -> "paradisemod:block/" + name + "_slab";
                default -> "";
            }));
        }
        return new ResourceLocation((String)(switch (name) {
            case "cactus" -> "paradisemod:block/cactus_block";
            case "glowing_cactus" -> "paradisemod:block/glowing_cactus_block";
            case "palo_verde", "mesquite", "blackened_oak", "blackened_spruce", "glowing_oak" -> "paradisemod:block/" + name + "_planks";
            case "dripstone" -> "minecraft:block/dripstone_block";
            case "obsidian", "bedrock", "end_stone", "calcite", "tuff" -> "minecraft:block/" + name;
            default -> "paradisemod:block/" + name;
        }));
    }

    private static enum SandstoneType {
        SMOOTH,
        CUT,
        NORMAL;


        private String getName() {
            return this == NORMAL ? "" : this.name().toLowerCase() + "_";
        }
    }
}

