/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.building.Slabs;
import net.paradisemod.world.DeepDarkBlocks;

public class Stairs {
    public static final RegisteredBlock CACTUS_STAIRS = Stairs.regWoodStairs("cactus", false, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_STAIRS = Stairs.regWoodStairs("palo_verde", false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_STAIRS = Stairs.regWoodStairs("mesquite", false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock BLACKENED_OAK_STAIRS = (RegisteredBlock)Stairs.regWoodStairs("blackened_oak", false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_STAIRS = (RegisteredBlock)Stairs.regWoodStairs("blackened_spruce", false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_STAIRS = (RegisteredBlock)Stairs.regWoodStairs("glowing_oak", true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_STAIRS = (RegisteredBlock)Stairs.regWoodStairs("glowing_cactus", true, Building.CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BEDROCK_STAIRS = Stairs.regStairs("bedrock", BlockType.INDESTRUCTIBLE, false, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock END_STONE_STAIRS = Stairs.regStoneStairs("end_stone", SoundType.f_56742_, (ItemLike)Blocks.f_50259_, new ItemLike[0]);
    public static final RegisteredBlock DRIPSTONE_STAIRS = Stairs.regStoneStairs("dripstone", SoundType.f_154661_, (ItemLike)Blocks.f_152537_, new ItemLike[0]);
    public static final RegisteredBlock CALCITE_STAIRS = Stairs.regStoneStairs("calcite", SoundType.f_154660_, (ItemLike)Blocks.f_152497_, new ItemLike[0]);
    public static final RegisteredBlock TUFF_STAIRS = Stairs.regStoneStairs("tuff", SoundType.f_154659_, (ItemLike)Blocks.f_152496_, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_END_STONE_STAIRS = Stairs.regStoneStairs("polished_end_stone", SoundType.f_56742_, Building.POLISHED_END_STONE, new ItemLike[]{Blocks.f_50259_});
    public static final RegisteredBlock POLISHED_DRIPSTONE_STAIRS = Stairs.regStoneStairs("polished_dripstone", SoundType.f_154661_, Building.POLISHED_DRIPSTONE, new ItemLike[]{Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_STAIRS = Stairs.regStoneStairs("polished_calcite", SoundType.f_154660_, Building.POLISHED_CALCITE, new ItemLike[]{Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_STAIRS = Stairs.regStoneStairs("polished_tuff", SoundType.f_154659_, Building.POLISHED_TUFF, new ItemLike[]{Blocks.f_152496_});
    public static final RegisteredBlock DARKSTONE_STAIRS = (RegisteredBlock)Stairs.regStoneStairs("darkstone", SoundType.f_56742_, DeepDarkBlocks.DARKSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DARKSTONE_STAIRS = (RegisteredBlock)Stairs.regStoneStairs("polished_darkstone", SoundType.f_56742_, DeepDarkBlocks.POLISHED_DARKSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DARKSTONE_BRICKS_STAIRS = (RegisteredBlock)Stairs.regStoneStairs("polished_darkstone_bricks", SoundType.f_56742_, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DRIPSTONE_BRICKS_STAIRS = Stairs.regStoneStairs("polished_dripstone_bricks", SoundType.f_56742_, Building.POLISHED_DRIPSTONE_BRICKS, new ItemLike[]{Building.POLISHED_DRIPSTONE, Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_BRICKS_STAIRS = Stairs.regStoneStairs("polished_calcite_bricks", SoundType.f_56742_, Building.POLISHED_CALCITE_BRICKS, new ItemLike[]{Building.POLISHED_CALCITE, Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_BRICKS_STAIRS = Stairs.regStoneStairs("polished_tuff_bricks", SoundType.f_56742_, Building.POLISHED_TUFF_BRICKS, new ItemLike[]{Building.POLISHED_TUFF, Blocks.f_152496_});
    public static final RegisteredBlock OBSIDIAN_STAIRS = Stairs.regStairs("obsidian", BlockType.STRONG_STONE, false, (ItemLike)Blocks.f_50080_);
    public static final RegisteredBlock POLISHED_ASPHALT_STAIRS = Stairs.regStoneStairs("polished_asphalt", SoundType.f_56742_, Building.POLISHED_ASPHALT, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_ASPHALT_BRICKS_STAIRS = Stairs.regStoneStairs("polished_asphalt_bricks", SoundType.f_56742_, Building.POLISHED_ASPHALT_BRICKS, Building.POLISHED_ASPHALT);
    public static final RegisteredBlock BLACKENED_SANDSTONE_STAIRS = (RegisteredBlock)Stairs.regSandstonetoneStairs("blackened", false, DeepDarkBlocks.BLACKENED_SANDSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock SMOOTH_BLACKENED_SANDSTONE_STAIRS = (RegisteredBlock)Stairs.regSandstonetoneStairs("blackened", true, DeepDarkBlocks.SMOOTH_BLACKENED_SANDSTONE, DeepDarkBlocks.BLACKENED_SANDSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_STAIRS = Stairs.regGlowingObsidianStairs(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regStairs(String name, BlockType type, boolean glows, ItemLike craftItem) {
        return Stairs.regStairsInternal(name, type, glows, craftItem).tag((TagKey<Block>)BlockTags.f_13030_);
    }

    private static RegisteredBlock regWoodStairs(String name, boolean glows, ItemLike planks) {
        return Stairs.regStairs(name, BlockType.WOOD, glows, planks).tag((TagKey<Block>)BlockTags.f_13096_);
    }

    private static RegisteredBlock regStairsInternal(String name, BlockType type, boolean glows, ItemLike craftItem) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_stairs", () -> new StairBlock(() -> ((Block)type.getBlock()).m_49966_(), type.getProperties())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).blockStateGenerator((block, generator) -> Stairs.genStairsBlockState(name, block, Slabs.slabTexture(name, false), generator)).itemModelAlreadyExists().recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 4).m_126130_("I  ").m_126130_("II ").m_126130_("III").m_126127_(Character.valueOf('I'), craftItem))).localizedName(Utils.localizedMaterialName(name, false) + " Stairs", "Escaleras de " + Utils.localizedMaterialName(name, true));
    }

    private static RegisteredBlock regSandstonetoneStairs(String name, boolean isSmooth, ItemLike stone, ItemLike ... stonecuttingBlocks) {
        return ((RegisteredBlock)((RegisteredBlock)Stairs.regStairsInternal((isSmooth ? "smooth_" : "") + name + "_sandstone", BlockType.STONE, false, stone).recipe((item, generator) -> generator.stonecutterRecipe(stone, (ItemLike)item))).stonecutterRecipes(stonecuttingBlocks)).blockStateGenerator((block, generator) -> Stairs.genSandstoneStairsBlockState(name, block, isSmooth, generator));
    }

    private static RegisteredBlock regStoneStairs(String name, SoundType stoneSound, ItemLike stone, ItemLike ... stonecuttingBlocks) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50635_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60918_(stoneSound))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(BlockTags.f_13030_, BlockTags.f_144282_).blockStateGenerator((block, generator) -> Stairs.genStairsBlockState(name, block, Slabs.slabTexture(name, false), generator)).itemModelAlreadyExists().recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 4).m_126130_("I  ").m_126130_("II ").m_126130_("III").m_126127_(Character.valueOf('I'), stone))).recipe((item, generator) -> generator.stonecutterRecipe(stone, (ItemLike)item))).stonecutterRecipes(stonecuttingBlocks)).localizedName(Utils.localizedMaterialName(name, false) + " Stairs", "Escaleras de " + Utils.localizedMaterialName(name, true));
    }

    private static RegisteredBlock regGlowingObsidianStairs(GlowingObsidianColor color) {
        RegisteredBlock glowingObsidian = Building.GLOWING_OBSIDIAN.get((Object)color);
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.getName() + "_glowing_obsidian_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50080_).m_49966_(), BlockType.STRONG_STONE.getProperties().m_60953_(s -> 7))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 4).m_126130_("I  ").m_126130_("II ").m_126130_("III").m_126127_(Character.valueOf('I'), (ItemLike)glowingObsidian))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tag(PMTags.Blocks.GLOWING_OBSIDIAN_STAIRS).blockStateGenerator((block, generator) -> Stairs.genGlowingObsidianStairsBlockState(color.getName(), block, generator)).itemModelAlreadyExists().localizedName(color.localizedName(false) + " Glowing Obsidian Stairs", "Escaleras de obsidiana brillante " + color.localizedName(true));
    }

    private static void genGlowingObsidianStairsBlockState(String color, RegisteredBlock stairsBlock, BlockStateGenerator generator) {
        ResourceLocation texture = new ResourceLocation("paradisemod:block/glowing_obsidian/" + color);
        Stairs.genStairsBlockState(color + "_glowing_obsidian", stairsBlock, texture, generator);
    }

    private static void genStairsBlockState(String name, RegisteredBlock stairsBlock, ResourceLocation texture, BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder stairs = (BlockModelBuilder)modelBuilder.stairs("block/stairs/" + name, texture, texture, texture);
        BlockModelBuilder stairsInner = (BlockModelBuilder)modelBuilder.stairsInner("block/stairs/" + name + "_inner", texture, texture, texture);
        BlockModelBuilder stairsOuter = (BlockModelBuilder)modelBuilder.stairsOuter("block/stairs/" + name + "_outer", texture, texture, texture);
        generator.stairsBlock((StairBlock)stairsBlock.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        generator.itemModels().parentBlockItem(stairsBlock.get(), "stairs/" + name);
    }

    private static void genSandstoneStairsBlockState(String name, RegisteredBlock stairsBlock, boolean isSmooth, BlockStateGenerator generator) {
        ResourceLocation bottomTexture = new ResourceLocation("paradisemod", "block/" + name + "_sandstone" + (isSmooth ? "_top" : "_bottom"));
        ResourceLocation sideTexture = new ResourceLocation("paradisemod", "block/" + name + "_sandstone" + (isSmooth ? "_top" : ""));
        ResourceLocation topTexture = new ResourceLocation("paradisemod", "block/" + name + "_sandstone_top");
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder stairs = (BlockModelBuilder)modelBuilder.stairs("block/stairs/" + (isSmooth ? "smooth_" : "") + name + "_sandstone", sideTexture, bottomTexture, topTexture);
        BlockModelBuilder stairsInner = (BlockModelBuilder)modelBuilder.stairsInner("block/stairs/" + (isSmooth ? "smooth_" : "") + name + "_sandstone_inner", sideTexture, bottomTexture, topTexture);
        BlockModelBuilder stairsOuter = (BlockModelBuilder)modelBuilder.stairsOuter("block/stairs/" + (isSmooth ? "smooth_" : "") + name + "_sandstone_outer", sideTexture, bottomTexture, topTexture);
        generator.stairsBlock((StairBlock)stairsBlock.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        generator.itemModels().parentBlockItem(stairsBlock.get(), "stairs/" + (isSmooth ? "smooth_" : "") + name + "_sandstone");
    }
}

