/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import java.util.ArrayList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.building.blocks.RedstoneTrapdoor;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;

public class Trapdoors {
    public static final RegisteredBlock ANDESITE_TRAPDOOR = Trapdoors.regTrapdoor("andesite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50334_);
    public static final RegisteredBlock BEDROCK_TRAPDOOR = Trapdoors.regTrapdoor("bedrock", BlockType.INDESTRUCTIBLE, 0, true, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock COBBLESTONE_TRAPDOOR = Trapdoors.regTrapdoor("cobblestone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50652_);
    public static final RegisteredBlock DIORITE_TRAPDOOR = Trapdoors.regTrapdoor("diorite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50228_);
    public static final RegisteredBlock END_STONE_TRAPDOOR = Trapdoors.regTrapdoor("end_stone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50259_);
    public static final RegisteredBlock GRANITE_TRAPDOOR = Trapdoors.regTrapdoor("granite", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50122_);
    public static final RegisteredBlock MOSSY_COBBLESTONE_TRAPDOOR = Trapdoors.regTrapdoor("mossy_cobblestone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50079_);
    public static final RegisteredBlock OBSIDIAN_TRAPDOOR = Trapdoors.regTrapdoor("obsidian", BlockType.STRONG_STONE, 0, true, (ItemLike)Blocks.f_50080_);
    public static final RegisteredBlock STONE_TRAPDOOR = Trapdoors.regTrapdoor("stone", BlockType.STONE, 0, true, (ItemLike)Blocks.f_50069_);
    public static final RegisteredBlock DIAMOND_TRAPDOOR = Trapdoors.regTrapdoor("diamond", BlockType.METAL, 0, true, (ItemLike)Items.f_42415_);
    public static final RegisteredBlock GOLD_TRAPDOOR = Trapdoors.regTrapdoor("gold", BlockType.METAL, 0, true, (ItemLike)Items.f_42417_);
    public static final RegisteredBlock EMERALD_TRAPDOOR = Trapdoors.regTrapdoor("emerald", BlockType.WEAK_METAL, 0, true, (ItemLike)Items.f_42616_);
    public static final RegisteredBlock RUBY_TRAPDOOR = Trapdoors.regTrapdoor("ruby", BlockType.WEAK_METAL, 0, true, Misc.RUBY);
    public static final RegisteredBlock RUSTED_IRON_TRAPDOOR = Trapdoors.regTrapdoor("rusted_iron", BlockType.METAL, 0, true, Misc.RUSTED_IRON_INGOT);
    public static final RegisteredBlock SILVER_TRAPDOOR = Trapdoors.regTrapdoor("silver", BlockType.METAL, 0, true, Misc.SILVER_INGOT);
    public static final RegisteredBlock REDSTONE_TRAPDOOR = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("redstone_trapdoor", RedstoneTrapdoor::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tag((TagKey<Block>)BlockTags.f_13036_).localizedName("Redstone Trapdoor", "Trampilla de piedra roja");
    public static final RegisteredBlock CACTUS_TRAPDOOR = Trapdoors.regTrapdoor("cactus", BlockType.WOOD, 0, true, Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_TRAPDOOR = Trapdoors.regTrapdoor("palo_verde", BlockType.WOOD, 0, false, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_TRAPDOOR = Trapdoors.regTrapdoor("mesquite", BlockType.WOOD, 0, false, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock GLASS_TRAPDOOR = Trapdoors.regTrapdoor("glass", BlockType.GLASS, 0, false, (ItemLike)Blocks.f_50058_);
    public static final RegisteredBlock BLACKENED_OAK_TRAPDOOR = (RegisteredBlock)Trapdoors.regTrapdoor("blackened_oak", BlockType.WOOD, 0, false, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_TRAPDOOR = (RegisteredBlock)Trapdoors.regTrapdoor("blackened_spruce", BlockType.WOOD, 0, false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_TRAPDOOR = (RegisteredBlock)Trapdoors.regTrapdoor("glowing_oak", BlockType.WOOD, 7, true, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_TRAPDOOR = (RegisteredBlock)Trapdoors.regTrapdoor("glowing_cactus", BlockType.WOOD, 7, true, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_TRAPDOOR = Trapdoors.regGlowingObsidianTrapdoor(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regGlowingObsidianTrapdoor(GlowingObsidianColor color) {
        RegisteredBlock glowingObsidian = Building.GLOWING_OBSIDIAN.get((Object)color);
        return (RegisteredBlock)Trapdoors.regTrapdoor(color.getName() + "_glowing_obsidian", BlockType.STRONG_STONE, 7, true, glowingObsidian).localizedName(color.localizedName(false) + " Glowing Obsidian Trapdoor", "Trampilla de obsidiana brillante " + color.localizedName(true));
    }

    private static RegisteredBlock regTrapdoor(String name, BlockType type, int lightLevel, boolean fancy, ItemLike craftItem) {
        BlockSetType blockSetType = switch (type) {
            case BlockType.WEAK_METAL -> PMBlockSetTypes.WEAK_METAL;
            case BlockType.METAL -> PMBlockSetTypes.METAL;
            case BlockType.GLASS -> PMBlockSetTypes.GLASS;
            case BlockType.WOOD -> PMBlockSetTypes.VARIANT_WOOD;
            default -> PMBlockSetTypes.VARIANT_STONE;
        };
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        if (type == BlockType.WOOD) {
            tags.add(BlockTags.f_13102_);
        } else {
            tags.addAll(type.tags());
            tags.add(BlockTags.f_13036_);
        }
        RegisteredBlock trapdoor = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_trapdoor", () -> new TrapDoorBlock(type.getProperties().m_60955_().m_60953_(s -> lightLevel), blockSetType)).recipe((item, generator) -> {
            ShapedRecipeBuilder recipe = generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 2).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), craftItem);
            if (type.isMetal()) {
                recipe = generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), craftItem).m_126145_("metal_trapdoors");
            }
            return recipe;
        })).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(tags).itemModel((block, generator) -> generator.parentBlockItem((RegisteredBlock)block, "trapdoor/" + name + "_bottom")).blockStateGenerator((block, generator) -> Trapdoors.genTrapdoorBlockState(name, type, fancy, block, generator)).localizedName(Utils.localizedMaterialName(name, false) + " Trapdoor", "Trampilla de " + Utils.localizedMaterialName(name, true));
        if (type.isStone()) {
            trapdoor = (RegisteredBlock)trapdoor.recipe((item, generator) -> generator.stonecutterRecipe(craftItem, (ItemLike)item));
        }
        return trapdoor;
    }

    private static void genTrapdoorBlockState(String name, BlockType type, boolean fancy, RegisteredBlock trapdoor, BlockStateGenerator generator) {
        String renderType = type == BlockType.GLASS ? "cutout" : "solid";
        Object texture = "paradisemod:block/trapdoor/" + name;
        if (name.endsWith("_glowing_obsidian")) {
            String color = name.substring(0, name.length() - 17);
            texture = "paradisemod:block/glowing_obsidian/" + color;
        } else if (type == BlockType.STONE || type == BlockType.ENHANCED_STONE || type == BlockType.STRONG_STONE || type == BlockType.INDESTRUCTIBLE) {
            texture = "minecraft:block/" + name;
        } else if (name == "glass") {
            texture = "minecraft:block/glass";
        } else if (name == "redstone" || name == "emerald" || name == "diamond" || name == "gold") {
            texture = "minecraft:block/" + name + "_block";
        } else if (name == "ruby" || name == "rusted_iron" || name == "silver") {
            texture = "paradisemod:block/" + name + "_block";
        }
        BlockModelProvider modelBuilder = generator.models();
        ModelFile bottom = Trapdoors.genTrapdoorModel(name, (String)texture, "bottom", renderType, fancy, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableBottom(arg_0, arg_1));
        ModelFile top = Trapdoors.genTrapdoorModel(name, (String)texture, "top", renderType, fancy, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableTop(arg_0, arg_1));
        ModelFile open = Trapdoors.genTrapdoorModel(name, (String)texture, "open", renderType, fancy, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableOpen(arg_0, arg_1));
        generator.trapdoorBlock((TrapDoorBlock)trapdoor.get(), bottom, top, open, true);
    }

    public static ModelFile genTrapdoorModel(String name, String texture, String suffix, String renderType, boolean fancy, BlockStateGenerator generator, TrapdoorModelGenerator modelGenerator) {
        BlockModelProvider modelBuilder = generator.models();
        String modelName = "trapdoor/" + name + "_" + suffix;
        if (fancy) {
            try {
                return generator.existingModel(modelName);
            }
            catch (Exception e) {
                return ((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/" + modelName, generator.modLoc("block/template/custom_trapdoor_" + suffix))).texture("texture", new ResourceLocation(texture))).renderType(renderType);
            }
        }
        return modelGenerator.generate("block/" + modelName, new ResourceLocation(texture)).renderType(renderType);
    }

    @FunctionalInterface
    public static interface TrapdoorModelGenerator {
        public BlockModelBuilder generate(String var1, ResourceLocation var2);
    }
}

