/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.world.DeepDarkBlocks;

public class Walls {
    public static final RegisteredBlock BEDROCK_WALL = Walls.regWall("bedrock", BlockType.INDESTRUCTIBLE, (ItemLike)Blocks.f_50752_, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_END_STONE_WALL = Walls.regWall("polished_end_stone", BlockType.ENHANCED_STONE, (ItemLike)Building.POLISHED_END_STONE, new ItemLike[]{Blocks.f_50259_});
    public static final RegisteredBlock END_STONE_WALL = Walls.regWall("end_stone", BlockType.ENHANCED_STONE, (ItemLike)Blocks.f_50259_, new ItemLike[0]);
    public static final RegisteredBlock DRIPSTONE_WALL = Walls.regWall("dripstone", SoundType.f_154661_, (ItemLike)Blocks.f_152537_, new ItemLike[0]);
    public static final RegisteredBlock CALCITE_WALL = Walls.regWall("calcite", SoundType.f_154660_, (ItemLike)Blocks.f_152497_, new ItemLike[0]);
    public static final RegisteredBlock TUFF_WALL = Walls.regWall("tuff", SoundType.f_154659_, (ItemLike)Blocks.f_152496_, new ItemLike[0]);
    public static final RegisteredBlock OBSIDIAN_WALL = Walls.regWall("obsidian", BlockType.STRONG_STONE, (ItemLike)Blocks.f_50080_, new ItemLike[0]);
    public static final RegisteredBlock DARKSTONE_WALL = (RegisteredBlock)Walls.regWall("darkstone", BlockType.ENHANCED_STONE, (ItemLike)DeepDarkBlocks.DARKSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DARKSTONE_WALL = (RegisteredBlock)Walls.regWall("polished_darkstone", BlockType.ENHANCED_STONE, (ItemLike)DeepDarkBlocks.POLISHED_DARKSTONE, DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DRIPSTONE_WALL = Walls.regWall("polished_dripstone", SoundType.f_154661_, (ItemLike)Building.POLISHED_DRIPSTONE, new ItemLike[]{Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_WALL = Walls.regWall("polished_calcite", SoundType.f_154660_, (ItemLike)Building.POLISHED_CALCITE, new ItemLike[]{Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_WALL = Walls.regWall("polished_tuff", SoundType.f_154659_, (ItemLike)Building.POLISHED_TUFF, new ItemLike[]{Blocks.f_152496_});
    public static final RegisteredBlock POLISHED_DARKSTONE_BRICKS_WALL = (RegisteredBlock)Walls.regWall("polished_darkstone_bricks", BlockType.ENHANCED_STONE, (ItemLike)DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS, DeepDarkBlocks.POLISHED_DARKSTONE, DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock POLISHED_DRIPSTONE_BRICKS_WALL = Walls.regWall("polished_dripstone_bricks", SoundType.f_154661_, (ItemLike)Building.POLISHED_DRIPSTONE_BRICKS, new ItemLike[]{Building.POLISHED_DRIPSTONE, Blocks.f_152537_});
    public static final RegisteredBlock POLISHED_CALCITE_BRICKS_WALL = Walls.regWall("polished_calcite_bricks", SoundType.f_154660_, (ItemLike)Building.POLISHED_CALCITE_BRICKS, new ItemLike[]{Building.POLISHED_CALCITE, Blocks.f_152497_});
    public static final RegisteredBlock POLISHED_TUFF_BRICKS_WALL = Walls.regWall("polished_tuff_bricks", SoundType.f_154659_, (ItemLike)Building.POLISHED_TUFF_BRICKS, new ItemLike[]{Building.POLISHED_TUFF, Blocks.f_152496_});
    public static final RegisteredBlock POLISHED_ASPHALT_WALL = Walls.regWall("polished_asphalt", BlockType.STONE, (ItemLike)Building.POLISHED_ASPHALT, new ItemLike[0]);
    public static final RegisteredBlock POLISHED_ASPHALT_BRICKS_WALL = Walls.regWall("polished_asphalt_bricks", BlockType.STONE, (ItemLike)Building.POLISHED_ASPHALT_BRICKS, Building.POLISHED_ASPHALT);
    public static final RegisteredBlock BLACKENED_SANDSTONE_WALL = (RegisteredBlock)Walls.regWall("blackened_sandstone", BlockType.STONE, (ItemLike)DeepDarkBlocks.BLACKENED_SANDSTONE, new ItemLike[0]).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_WALL = Walls.regGlowingObsidianWall(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regGlowingObsidianWall(GlowingObsidianColor color) {
        RegisteredBlock glowingObsidian = Building.GLOWING_OBSIDIAN.get((Object)color);
        String texture = "paradisemod:block/glowing_obsidian/" + color.getName();
        String name = color.getName() + "_glowing_obsidian";
        RegisteredBlock wall = (RegisteredBlock)Walls.regWall(name, texture, BlockType.STRONG_STONE.getProperties().m_60955_().m_60953_(s -> 7), (ItemLike)glowingObsidian, new ItemLike[0]).tag(PMTags.Blocks.GLOWING_OBSIDIAN_WALLS).localizedName(color.localizedName(false) + " Glowing Obsidian Wall", "Pared de obsidiana brillante " + color.localizedName(true));
        return wall;
    }

    private static RegisteredBlock regWall(String name, SoundType sound, ItemLike craftItem, ItemLike ... stonecuttingBlocks) {
        String texture = Walls.texture(name);
        return (RegisteredBlock)((RegisteredBlock)Walls.regWall(name, texture, BlockType.STONE.getProperties().m_60955_().m_60918_(sound), craftItem, stonecuttingBlocks).tags(BlockType.STONE.tags()).tag((TagKey<Block>)BlockTags.f_13032_).stonecutterRecipes(stonecuttingBlocks)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 6).m_126130_("BBB").m_126130_("BBB").m_126127_(Character.valueOf('B'), craftItem));
    }

    private static RegisteredBlock regWall(String name, BlockType type, ItemLike craftItem, ItemLike ... stonecuttingBlocks) {
        String texture = Walls.texture(name);
        return (RegisteredBlock)((RegisteredBlock)Walls.regWall(name, texture, type.getProperties().m_60955_(), craftItem, stonecuttingBlocks).tags(type.tags()).tag((TagKey<Block>)BlockTags.f_13032_).stonecutterRecipes(stonecuttingBlocks)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 6).m_126130_("BBB").m_126130_("BBB").m_126127_(Character.valueOf('B'), craftItem));
    }

    private static RegisteredBlock regWall(String name, String texture, BlockBehaviour.Properties properties, ItemLike craftItem, ItemLike ... stonecuttingBlocks) {
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_wall", () -> new WallBlock(properties)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).itemModel((block, generator) -> generator.wallInventory(name + "_wall", new ResourceLocation(texture))).blockStateGenerator((block, generator) -> Walls.genWallBlockState(name, texture, block, generator)).localizedName(Utils.localizedMaterialName(name, false) + " Wall", "Pared de " + Utils.localizedMaterialName(name, true));
    }

    private static void genWallBlockState(String name, String texture, RegisteredBlock wallBlock, BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        ResourceLocation textureLoc = new ResourceLocation(texture);
        generator.wallBlock((WallBlock)wallBlock.get(), (ModelFile)modelBuilder.wallPost("block/wall/" + name + "_post", textureLoc), (ModelFile)modelBuilder.wallSide("block/wall/" + name + "_side", textureLoc), (ModelFile)modelBuilder.wallSideTall("block/wall/" + name + "_side_tall", textureLoc));
    }

    private static String texture(String name) {
        return switch (name) {
            case "bedrock", "end_stone", "calcite", "tuff", "obsidian" -> "minecraft:block/" + name;
            case "dripstone" -> "minecraft:block/dripstone_block";
            default -> "paradisemod:block/" + name;
        };
    }
}

