/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.building.Doors;

public class RedstoneDoor
extends Block
implements ModeledBlock {
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public RedstoneDoor() {
        super(BlockType.WEAK_METAL.getProperties().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DoorBlock.f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Direction direction = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
        boolean flag = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) == false;
        boolean flag1 = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
        return switch (direction) {
            default -> {
                if (flag) {
                    yield EAST_AABB;
                }
                if (flag1) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (flag) {
                    yield SOUTH_AABB;
                }
                if (flag1) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (flag) {
                    yield WEST_AABB;
                }
                if (flag1) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
        };
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doorHalf = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
        if (facing.m_122434_() == Direction.Axis.Y && doorHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_((Property)DoorBlock.f_52730_) != doorHalf ? (BlockState)((BlockState)((BlockState)state.m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)facingState.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)facingState.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)facingState.m_61143_((Property)DoorBlock.f_52728_))) : Blocks.f_50016_.m_49966_();
        }
        return doorHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType pathType) {
        return switch (pathType) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            default -> false;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        if (blockpos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)context.m_8125_())).m_61124_((Property)DoorBlock.f_52728_, (Comparable)this.getHingeSide(context))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext context) {
        boolean flag1;
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        BlockPos pos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos pos2 = blockpos.m_121945_(direction1);
        BlockState state = world.m_8055_(pos2);
        BlockPos pos3 = pos1.m_121945_(direction1);
        BlockState state1 = world.m_8055_(pos3);
        Direction direction2 = direction.m_122427_();
        BlockPos pos4 = blockpos.m_121945_(direction2);
        BlockState state2 = world.m_8055_(pos4);
        BlockPos pos5 = pos1.m_121945_(direction2);
        BlockState state3 = world.m_8055_(pos5);
        int i = (state.m_60838_((BlockGetter)world, pos2) ? -1 : 0) + (state1.m_60838_((BlockGetter)world, pos3) ? -1 : 0) + (state2.m_60838_((BlockGetter)world, pos4) ? 1 : 0) + (state3.m_60838_((BlockGetter)world, pos5) ? 1 : 0);
        boolean flag = state.m_60713_((Block)this) && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = state2.m_60713_((Block)this) && state2.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i == 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3d = context.m_43720_();
                double d0 = vec3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        state = (BlockState)state.m_61122_((Property)DoorBlock.f_52727_);
        world.m_7731_(pos, state, 10);
        world.m_5594_(player, pos, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? PMBlockSetTypes.WEAK_METAL.f_271141_() : PMBlockSetTypes.WEAK_METAL.f_271502_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        world.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockBelow = world.m_8055_(blockpos);
        return state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? blockBelow.m_60783_((BlockGetter)world, blockpos, Direction.UP) : blockBelow.m_60713_((Block)this);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DoorBlock.f_52730_, DoorBlock.f_52726_, DoorBlock.f_52727_, DoorBlock.f_52728_});
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        return 15;
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        ModelFile bottom = Doors.genDoorModel("redstone", "minecraft:block/redstone_block", "minecraft:block/redstone_block", "bottom", "solid", true, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorBottomLeft(arg_0, arg_1, arg_2));
        ModelFile bottomHinge = Doors.genDoorModel("redstone", "minecraft:block/redstone_block", "minecraft:block/redstone_block", "bottom_hinge", "solid", true, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorBottomRight(arg_0, arg_1, arg_2));
        ModelFile top = Doors.genDoorModel("redstone", "minecraft:block/redstone_block", "minecraft:block/redstone_block", "top", "solid", true, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorTopLeft(arg_0, arg_1, arg_2));
        ModelFile topHinge = Doors.genDoorModel("redstone", "minecraft:block/redstone_block", "minecraft:block/redstone_block", "top_hinge", "solid", true, generator, (arg_0, arg_1, arg_2) -> ((BlockModelProvider)modelBuilder).doorTopRight(arg_0, arg_1, arg_2));
        generator.getVariantBuilder(this).forAllStates(state -> {
            boolean lower;
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean right = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean bl = lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = bottomHinge;
            } else if (lower && !right && open) {
                model = bottom;
            }
            if (lower && right && !open) {
                model = bottomHinge;
            } else if (lower && !right && !open) {
                model = bottom;
            }
            if (!lower && right && open) {
                model = topHinge;
            } else if (!lower && !right && open) {
                model = top;
            }
            if (!lower && right && !open) {
                model = topHinge;
            } else if (!(lower || right || open)) {
                model = top;
            }
            return generator.buildVariantModel(model, 0, yRot);
        });
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.basicItem(this.m_5456_(), "door/redstone", "cutout");
    }
}

