/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.building.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.building.Trapdoors;

public class RedstoneTrapdoor
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
ModeledBlock {
    protected static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public RedstoneTrapdoor() {
        super(BlockType.WEAK_METAL.getProperties().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.BOTTOM)).m_61124_((Property)TrapDoorBlock.f_57517_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
            return state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default -> NORTH_OPEN_AABB;
            case Direction.SOUTH -> SOUTH_OPEN_AABB;
            case Direction.WEST -> WEST_OPEN_AABB;
            case Direction.EAST -> EAST_OPEN_AABB;
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            case PathComputationType.WATER -> (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57517_);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        state = (BlockState)state.m_61122_((Property)TrapDoorBlock.f_57514_);
        world.m_7731_(pos, state, 2);
        if (((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57517_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        world.m_5594_(player, pos, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? PMBlockSetTypes.WEAK_METAL.f_271258_() : PMBlockSetTypes.WEAK_METAL.f_271425_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        world.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_43719_();
        blockstate = !context.m_7058_() && direction.m_122434_().m_122479_() ? (BlockState)((BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)(context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        return (BlockState)blockstate.m_61124_((Property)TrapDoorBlock.f_57517_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, TrapDoorBlock.f_57514_, TrapDoorBlock.f_57515_, TrapDoorBlock.f_57517_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57517_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)TrapDoorBlock.f_57517_)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        if (((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
            BlockPos downPos = pos.m_7495_();
            BlockState down = world.m_8055_(downPos);
            return down.m_60734_().makesOpenTrapdoorAboveClimbable(down, world, downPos, state);
        }
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 15;
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        ModelFile bottom = Trapdoors.genTrapdoorModel("redstone", "minecraft:block/redstone_block", "bottom", "solid", true, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableBottom(arg_0, arg_1));
        ModelFile top = Trapdoors.genTrapdoorModel("redstone", "minecraft:block/redstone_block", "top", "solid", true, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableTop(arg_0, arg_1));
        ModelFile open = Trapdoors.genTrapdoorModel("redstone", "minecraft:block/redstone_block", "open", "solid", true, generator, (arg_0, arg_1) -> ((BlockModelProvider)modelBuilder).trapdoorOrientableOpen(arg_0, arg_1));
        generator.getVariantBuilder((Block)this).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((Direction)state.m_61143_((Property)f_54117_)).m_122435_() + 180;
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (isOpen && state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            return generator.buildVariantModel(isOpen ? open : (state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? top : bottom), xRot, yRot %= 360);
        }, new Property[]{TrapDoorBlock.f_57517_});
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.parentBlockItem((Block)this, "trapdoor/redstone_bottom");
    }
}

