/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.decoration;

import java.util.EnumMap;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.BlockTemplates;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Events;
import net.paradisemod.base.Utils;
import net.paradisemod.base.blocks.CustomPlant;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.data.loot.BlockLootGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.decoration.ColoredLanterns;
import net.paradisemod.decoration.FlowerPots;
import net.paradisemod.decoration.Tables;
import net.paradisemod.decoration.blocks.PricklyPear;
import net.paradisemod.decoration.blocks.SoulPumpkin;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.trees.AutumnTree;
import net.paradisemod.world.trees.MesquiteTree;
import net.paradisemod.world.trees.PaloVerdeTree;

public class Decoration {
    public static final RegisteredBlock NETHERITE_BARS = Decoration.regMetalBars("netherite", SoundType.f_56725_);
    public static final RegisteredBlock SILVER_BARS = Decoration.regMetalBars("silver", SoundType.f_56743_);
    public static final RegisteredBlock RUSTED_IRON_BARS = Decoration.regMetalBars("rusted_iron", SoundType.f_56743_);
    public static final RegisteredBlock BLASTPROOF_GLASS = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("blastproof_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60955_().m_60913_(0.3f, 1200.0f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 8).m_126130_("ooo").m_126130_("ogo").m_126130_("ooo").m_126127_(Character.valueOf('g'), (ItemLike)Blocks.f_50058_).m_126127_(Character.valueOf('o'), (ItemLike)Blocks.f_50080_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).renderType("translucent").localizedName("Blastproof Glass", "Vidrio resistente a explosiones");
    public static final RegisteredBlock SOUL_GLASS = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("soul_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_60955_().m_60978_(0.3f).m_60911_(1.2f))).oreRecipes((ItemLike)Blocks.f_50135_)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).tag((TagKey<Block>)BlockTags.f_13085_).renderType("translucent").dropsWithSilkTouch().localizedName("Soul Glass", "Vidrio de almas");
    public static final EnumMap<DyeColor, RegisteredBlock> TINTED_BLASTPROOF_GLASS = new EnumMap(DyeColor.class);
    public static final RegisteredBlock BLACK_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.BLACK);
    public static final RegisteredBlock BLUE_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.BLUE);
    public static final RegisteredBlock BROWN_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.BROWN);
    public static final RegisteredBlock CYAN_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.CYAN);
    public static final RegisteredBlock GRAY_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.GRAY);
    public static final RegisteredBlock GREEN_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.GREEN);
    public static final RegisteredBlock LIGHT_BLUE_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.LIGHT_BLUE);
    public static final RegisteredBlock LIGHT_GRAY_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.LIGHT_GRAY);
    public static final RegisteredBlock LIME_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.LIME);
    public static final RegisteredBlock MAGENTA_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.MAGENTA);
    public static final RegisteredBlock ORANGE_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.ORANGE);
    public static final RegisteredBlock PINK_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.PINK);
    public static final RegisteredBlock PURPLE_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.PURPLE);
    public static final RegisteredBlock RED_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.RED);
    public static final RegisteredBlock WHITE_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.WHITE);
    public static final RegisteredBlock YELLOW_TINTED_BLASTPROOF_GLASS = Decoration.regTintedBlastproofGlass(DyeColor.YELLOW);
    public static final RegisteredBlock BLASTPROOF_GLASS_PANE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("blastproof_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60955_().m_60913_(0.3f, 1200.0f))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).blockStateGenerator((block, generator) -> Decoration.genPaneBlockState("blastproof_glass", "blastproof_glass", block, generator)).itemModel((block, generator) -> generator.glassPaneItem("blastproof_glass_pane", "blastproof_glass")).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 16).m_126130_("ooo").m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)BLASTPROOF_GLASS))).localizedName("Blastproof Glass Pane", "Panel de vidrio resistente a explosiones");
    public static final RegisteredBlock SOUL_GLASS_PANE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("soul_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_60955_().m_60978_(0.3f).m_60911_(1.2f))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).blockStateGenerator((block, generator) -> Decoration.genPaneBlockState("soul_glass", "soul_glass", block, generator)).itemModel((block, generator) -> generator.glassPaneItem("soul_glass_pane", "soul_glass")).dropsWithSilkTouch().recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 16).m_126130_("ooo").m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)SOUL_GLASS))).localizedName("Soul Glass Pane", "Panel de vidrio de almas");
    public static final RegisteredBlock BLACK_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.BLACK);
    public static final RegisteredBlock BLUE_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.BLUE);
    public static final RegisteredBlock BROWN_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.BROWN);
    public static final RegisteredBlock CYAN_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.CYAN);
    public static final RegisteredBlock GRAY_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.GRAY);
    public static final RegisteredBlock GREEN_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.GREEN);
    public static final RegisteredBlock LIGHT_BLUE_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.LIGHT_BLUE);
    public static final RegisteredBlock LIGHT_GRAY_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.LIGHT_GRAY);
    public static final RegisteredBlock LIME_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.LIME);
    public static final RegisteredBlock MAGENTA_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.MAGENTA);
    public static final RegisteredBlock ORANGE_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.ORANGE);
    public static final RegisteredBlock PINK_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.PINK);
    public static final RegisteredBlock PURPLE_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.PURPLE);
    public static final RegisteredBlock RED_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.RED);
    public static final RegisteredBlock WHITE_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.WHITE);
    public static final RegisteredBlock YELLOW_TINTED_BLASTPROOF_GLASS_PANE = Decoration.regTintedBlastproofGlassPane(DyeColor.YELLOW);
    public static final RegisteredBlock PRICKLY_PEAR = ((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("prickly_pear", PricklyPear::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).localizedName("Prickly Pear Cactus", "Cactus de nopal")).lootTable((block, generator) -> generator.m_246481_((Block)block, blockIn -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)blockIn).m_79080_(BlockLootGenerator.hasSilkTouch())).m_7170_((LootPoolEntryContainer.Builder)generator.m_246108_((ItemLike)blockIn, LootItem.m_79579_((ItemLike)Misc.NOPAL).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Misc.PRICKLY_PEAR_FRUIT)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)blockIn).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PricklyPear.HAS_FRUIT, true))))));
    public static final EnumMap<DyeColor, RegisteredBlock> ROSES = new EnumMap(DyeColor.class);
    public static final RegisteredBlock BLACK_ROSE = Decoration.regRose(DyeColor.BLACK);
    public static final RegisteredBlock BLUE_ROSE = Decoration.regRose(DyeColor.BLUE);
    public static final RegisteredBlock BROWN_ROSE = Decoration.regRose(DyeColor.BROWN);
    public static final RegisteredBlock CYAN_ROSE = Decoration.regRose(DyeColor.CYAN);
    public static final RegisteredBlock GRAY_ROSE = Decoration.regRose(DyeColor.GRAY);
    public static final RegisteredBlock GREEN_ROSE = Decoration.regRose(DyeColor.GREEN);
    public static final RegisteredBlock LIGHT_BLUE_ROSE = Decoration.regRose(DyeColor.LIGHT_BLUE);
    public static final RegisteredBlock LIGHT_GRAY_ROSE = Decoration.regRose(DyeColor.LIGHT_GRAY);
    public static final RegisteredBlock LIME_ROSE = Decoration.regRose(DyeColor.LIME);
    public static final RegisteredBlock MAGENTA_ROSE = Decoration.regRose(DyeColor.MAGENTA);
    public static final RegisteredBlock ORANGE_ROSE = Decoration.regRose(DyeColor.ORANGE);
    public static final RegisteredBlock PINK_ROSE = Decoration.regRose(DyeColor.PINK);
    public static final RegisteredBlock PURPLE_ROSE = Decoration.regRose(DyeColor.PURPLE);
    public static final RegisteredBlock RED_ROSE = Decoration.regRose(DyeColor.RED);
    public static final RegisteredBlock WHITE_ROSE = Decoration.regRose(DyeColor.WHITE);
    public static final RegisteredBlock YELLOW_ROSE = Decoration.regRose(DyeColor.YELLOW);
    public static final RegisteredBlock ENDER_ROSE = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("ender_rose", () -> new CustomPlant(false, false, CustomPlant.Type.END)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> generator.genSimplePlant(block.get(), "rose/ender")).tag(PMTags.Blocks.END_FOLIAGE).localizedName("Ender Rose", "Rosa del Fin");
    public static final RegisteredBlock SOUL_PUMPKIN = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("soul_pumpkin", SoulPumpkin::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tag((TagKey<Block>)BlockTags.f_144280_).blockStateGenerator((block, generator) -> {
        ResourceLocation top = generator.modLoc("block/soul_pumpkin_top");
        ResourceLocation side = generator.modLoc("block/soul_pumpkin_side");
        BlockModelBuilder model = (BlockModelBuilder)generator.models().cubeBottomTop("soul_pumpkin", side, top, top);
        generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
    }).localizedName("Soul Pumpkin", "Calabaza de almas");
    public static final RegisteredBlock CARVED_SOUL_PUMPKIN = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("carved_soul_pumpkin", () -> new CarvedPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50143_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> {
        ResourceLocation top = generator.modLoc("block/soul_pumpkin_top");
        ResourceLocation front = generator.modLoc("block/carved_soul_pumpkin");
        ResourceLocation side = generator.modLoc("block/soul_pumpkin_side");
        BlockModelBuilder model = (BlockModelBuilder)generator.models().orientable("carved_soul_pumpkin", side, front, top);
        generator.getVariantBuilder(block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return generator.buildVariantModel((ModelFile)model, facing, true);
        });
    }).tag((TagKey<Block>)BlockTags.f_144280_).localizedName("Carved Soul Pumpkin", "Calabaza tallada de almas");
    public static final RegisteredBlock SOUL_JACK_O_LANTERN = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("soul_jack_o_lantern", () -> new CarvedPumpkinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50144_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> {
        ResourceLocation top = generator.modLoc("block/soul_pumpkin_top");
        ResourceLocation front = generator.modLoc("block/soul_jack_o_lantern");
        ResourceLocation side = generator.modLoc("block/soul_pumpkin_side");
        BlockModelBuilder model = (BlockModelBuilder)generator.models().orientable("soul_jack_o_lantern", side, front, top);
        generator.getVariantBuilder(block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return generator.buildVariantModel((ModelFile)model, facing, true);
        });
    }).tags(BlockTags.f_144280_, BlockTags.f_13042_).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, new ItemLike[]{CARVED_SOUL_PUMPKIN, Blocks.f_50081_}))).localizedName("Soul Jack o'Lantern ", "Calabaza de almas de Halloween");
    public static final RegisteredItem SOUL_PUMPKIN_SEEDS = (RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)PMRegistries.regItem("soul_pumpkin_seeds", () -> new ItemNameBlockItem(SOUL_PUMPKIN_STEM.get(), new Item.Properties())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, SOUL_PUMPKIN))).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, CARVED_SOUL_PUMPKIN))).localizedName("Soul Pumpkin Seeds", "Semillas de calabaza de almas");
    public static final RegisteredBlock SOUL_PUMPKIN_STEM = PMRegistries.regBlock("soul_pumpkin_stem", () -> new StemBlock((StemGrownBlock)SOUL_PUMPKIN.get(), SOUL_PUMPKIN_SEEDS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50189_)){

        public boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
            return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_);
        }
    }).blockStateGenerator((block, generator) -> generator.getVariantBuilder(block.get()).forAllStates(state -> {
        int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("soul_pumpkin_stem" + age, "block/stem_growth" + age)).texture("stem", "paradisemod:block/soul_pumpkin_stem");
        return generator.buildVariantModel((ModelFile)model);
    })).dropsItem(SOUL_PUMPKIN_SEEDS);
    public static final RegisteredBlock ATTACHED_SOUL_PUMPKIN_STEM = PMRegistries.regBlock("attached_soul_pumpkin_stem", () -> new AttachedStemBlock((StemGrownBlock)SOUL_PUMPKIN.get(), SOUL_PUMPKIN_SEEDS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50189_)){

        public boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
            return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_);
        }
    }).blockStateGenerator((block, generator) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("attached_soul_pumpkin_stem", "block/stem_fruit")).texture("stem", "paradisemod:block/soul_pumpkin_stem")).texture("upperstem", "paradisemod:block/attached_soul_pumpkin_stem");
        generator.getVariantBuilder(block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)AttachedStemBlock.f_48830_);
            return generator.buildVariantModel((ModelFile)model, facing, true);
        });
    }).dropsItem(SOUL_PUMPKIN_SEEDS);
    public static final RegisteredBlock BLUE_AUTUMN_SAPLING = Decoration.regAutumnSapling(AutumnTree.Color.BLUE);
    public static final RegisteredBlock ORANGE_AUTUMN_SAPLING = Decoration.regAutumnSapling(AutumnTree.Color.ORANGE);
    public static final RegisteredBlock RED_AUTUMN_SAPLING = Decoration.regAutumnSapling(AutumnTree.Color.RED);
    public static final RegisteredBlock YELLOW_AUTUMN_SAPLING = Decoration.regAutumnSapling(AutumnTree.Color.YELLOW);
    public static final RegisteredBlock PALO_VERDE_SAPLING = Decoration.regSapling("palo_verde", new PaloVerdeTree(), false, false);
    public static final RegisteredBlock MESQUITE_SAPLING = Decoration.regSapling("mesquite", new MesquiteTree(), false, false);
    public static RegisteredBlock BLUE_AUTUMN_LEAVES = Decoration.autumnLeaves(AutumnTree.Color.BLUE, BLUE_AUTUMN_SAPLING);
    public static RegisteredBlock ORANGE_AUTUMN_LEAVES = Decoration.autumnLeaves(AutumnTree.Color.ORANGE, ORANGE_AUTUMN_SAPLING);
    public static RegisteredBlock RED_AUTUMN_LEAVES = Decoration.autumnLeaves(AutumnTree.Color.RED, RED_AUTUMN_SAPLING);
    public static RegisteredBlock YELLOW_AUTUMN_LEAVES = Decoration.autumnLeaves(AutumnTree.Color.YELLOW, YELLOW_AUTUMN_SAPLING);
    public static RegisteredBlock PALO_VERDE_LEAVES = BlockTemplates.leaves("palo_verde", "acacia", PALO_VERDE_SAPLING, false);
    public static RegisteredBlock MESQUITE_LEAVES = BlockTemplates.leaves("mesquite", "oak", MESQUITE_SAPLING, false);
    public static final RegisteredBlock STRIPPED_PALO_VERDE_LOG = BlockTemplates.strippedLog("palo_verde", false, false);
    public static final RegisteredBlock PALO_VERDE_LOG = BlockTemplates.log("palo_verde", false, STRIPPED_PALO_VERDE_LOG, false);
    public static final RegisteredBlock STRIPPED_PALO_VERDE_WOOD = BlockTemplates.strippedLog("palo_verde", true, false);
    public static final RegisteredBlock PALO_VERDE_WOOD = BlockTemplates.log("palo_verde", true, STRIPPED_PALO_VERDE_WOOD, false);
    public static final RegisteredBlock STRIPPED_MESQUITE_LOG = BlockTemplates.strippedLog("mesquite", false, false);
    public static final RegisteredBlock MESQUITE_LOG = BlockTemplates.log("mesquite", false, STRIPPED_MESQUITE_LOG, false);
    public static final RegisteredBlock STRIPPED_MESQUITE_WOOD = BlockTemplates.strippedLog("mesquite", true, false);
    public static final RegisteredBlock MESQUITE_WOOD = BlockTemplates.log("mesquite", true, STRIPPED_MESQUITE_WOOD, false);
    public static final RegisteredBlock CACTUS_BOOKSHELF = Decoration.regBookshelf("cactus", false);
    public static final RegisteredBlock BAMBOO_BOOKSHELF = Decoration.regBookshelf("bamboo", false);
    public static final RegisteredBlock PALO_VERDE_BOOKSHELF = Decoration.regBookshelf("palo_verde", false);
    public static final RegisteredBlock MESQUITE_BOOKSHELF = Decoration.regBookshelf("mesquite", false);
    public static final RegisteredBlock BLACKENED_OAK_BOOKSHELF = (RegisteredBlock)Decoration.regBookshelf("blackened_oak", false).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_BOOKSHELF = (RegisteredBlock)Decoration.regBookshelf("blackened_spruce", false).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_BOOKSHELF = (RegisteredBlock)Decoration.regBookshelf("glowing_oak", true).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_BOOKSHELF = (RegisteredBlock)Decoration.regBookshelf("glowing_cactus", true).tab(DeepDarkBlocks.DEEP_DARK_TAB);

    public static void init() {
        Tables.init();
        ColoredLanterns.init();
        FlowerPots.init();
        ParadiseMod.LOG.info("Loaded Decoration module");
        Events.registerBasicColoredBlocks(12770107, PALO_VERDE_LEAVES);
        Events.registerBasicColoredBlocks(5472286, MESQUITE_LEAVES);
    }

    public static RegisteredBlock regSapling(String name, AbstractTreeGrower tree, boolean deepDarkOverride, boolean glows) {
        return Decoration.regSapling(name, name + "_sapling", tree, deepDarkOverride, glows);
    }

    private static RegisteredBlock regAutumnSapling(AutumnTree.Color color) {
        String modelName = "autumn_sapling/" + color.name().toLowerCase();
        return (RegisteredBlock)Decoration.regSapling(color.name().toLowerCase() + "_autumn", modelName, new AutumnTree(color), false, false).localizedName(color.localizedSaplingColor(false) + " Autumn Sapling", "Reto\u00f1o " + color.localizedSaplingColor(true) + " de oto\u00f1o");
    }

    public static RegisteredBlock regSapling(String name, String modelName, AbstractTreeGrower tree, final boolean deepDarkOverride, boolean glows) {
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_sapling", () -> new SaplingBlock(tree, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_).m_60953_(s -> glows ? 7 : 0)){

            protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
                if (state.m_60713_(DeepDarkBlocks.DARKSTONE.get()) || state.m_60713_(DeepDarkBlocks.GLOWING_NYLIUM.get()) || state.m_60713_(DeepDarkBlocks.OVERGROWN_DARKSTONE.get()) && deepDarkOverride) {
                    return true;
                }
                return super.m_6266_(state, world, pos);
            }
        }).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> generator.genSimplePlant(block.get(), modelName)).itemModelAlreadyExists().localizedName(Utils.localizedMaterialName(name, false) + " Sapling", "Reto\u00f1o de" + Utils.localizedMaterialName(name, true));
    }

    private static RegisteredBlock regRose(DyeColor color) {
        RegisteredBlock rose = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.name().toLowerCase() + "_rose", () -> new CustomPlant(false, false, CustomPlant.Type.NORMAL)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> generator.genSimplePlant(block.get(), "rose/" + color.m_41065_())).itemModelAlreadyExists().tag(PMTags.Blocks.ROSES).localizedName(PMTranslations.englishColor(color) + " Rose", "Rosa " + PMTranslations.spanishColor(color, true));
        ROSES.put(color, rose);
        return rose;
    }

    private static RegisteredBlock regTintedBlastproofGlass(DyeColor color) {
        RegisteredBlock glass = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.m_41065_() + "_tinted_blastproof_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60955_().m_60913_(0.3f, 1200.0f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item, 8).m_126130_("ggg").m_126130_("gdg").m_126130_("ggg").m_126127_(Character.valueOf('g'), (ItemLike)BLASTPROOF_GLASS).m_126127_(Character.valueOf('d'), (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color)))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).itemModel((block, generator) -> generator.parentBlockItem((RegisteredBlock)block, "tinted_blastproof_glass/" + color.m_41065_())).blockStateGenerator((block, generator) -> generator.simpleBlockWithRenderType(block.get(), "tinted_blastproof_glass/" + color.m_41065_(), "translucent")).localizedName(PMTranslations.englishColor(color) + " Blastproof Glass", "Vidrio " + PMTranslations.spanishColor(color, false) + " resistente a explosiones");
        TINTED_BLASTPROOF_GLASS.put(color, glass);
        return glass;
    }

    private static RegisteredBlock regTintedBlastproofGlassPane(DyeColor color) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.m_41065_() + "_tinted_blastproof_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60955_().m_60913_(0.3f, 1200.0f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item, 16).m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), (ItemLike)TINTED_BLASTPROOF_GLASS.get(color)))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item, 8).m_126130_("ggg").m_126130_("gdg").m_126130_("ggg").m_126127_(Character.valueOf('g'), (ItemLike)BLASTPROOF_GLASS_PANE).m_126127_(Character.valueOf('d'), (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color)))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256725_)).itemModel((block, generator) -> generator.glassPaneItem(color.m_41065_() + "_tinted_blastproof_glass_pane", "tinted_blastproof_glass/" + color.m_41065_())).blockStateGenerator((block, generator) -> Decoration.genPaneBlockState("tinted_blastproof_glass_pane/" + color.m_41065_(), "tinted_blastproof_glass/" + color.m_41065_(), block, generator)).localizedName(PMTranslations.englishColor(color) + " Blastproof Glass Pane", "Panel de vidrio " + PMTranslations.spanishColor(color, false) + " resistente a explosiones");
    }

    private static RegisteredBlock regBookshelf(String name, boolean glows) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_bookshelf", () -> new Block(BlockType.WOOD.getProperties().m_60953_(s -> glows ? 7 : 0))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).tag((TagKey<Block>)BlockTags.f_144280_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("ppp").m_126130_("bbb").m_126130_("ppp").m_126127_(Character.valueOf('p'), Utils.getPlanks(name)).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42517_))).blockStateGenerator((block, generator) -> {
            ResourceLocation topTexture = generator.modLoc("block/" + name + "_planks");
            if (name.contains("cactus")) {
                topTexture = generator.modLoc("block/" + name + "_block");
            } else if (name == "bamboo") {
                topTexture = generator.mcLoc("block/bamboo_planks");
            }
            ResourceLocation sideTexture = generator.modLoc("block/bookshelf/" + name);
            BlockModelBuilder model = (BlockModelBuilder)generator.models().cubeColumn("block/bookshelf/" + name, sideTexture, topTexture);
            generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
        }).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "bookshelf/" + name)).localizedName(Utils.localizedMaterialName(name, false) + " Bookshelf", "Estante de " + Utils.localizedMaterialName(name, true));
    }

    private static RegisteredBlock regMetalBars(String name, SoundType sound) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_bars", () -> new IronBarsBlock(BlockType.METAL.getProperties().m_60918_(sound))).recipe((item, generator) -> {
            RegisteredItem ingot = switch (name) {
                case "rusted_iron" -> Misc.RUSTED_IRON_INGOT;
                case "netherite" -> Items.f_42418_;
                case "silver" -> Misc.SILVER_INGOT;
                default -> (ItemLike)Utils.modErrorTyped("The metal bars type " + name + " has no ingot specified!");
            };
            return generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 16).m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), (ItemLike)ingot);
        })).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).itemModel((block, generator) -> generator.flatBlockItem(name + "_bars", "bars/" + name)).blockStateGenerator((block, generator) -> {
            String barName = "block/bars/" + name;
            ResourceLocation texture = generator.modLoc(barName);
            BlockModelProvider modelBuilder = generator.models();
            BlockModelBuilder post = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent(barName + "_post", generator.modLoc("block/template/custom_bars_post"))).texture("texture", texture);
            BlockModelBuilder side = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent(barName + "_side", generator.modLoc("block/template/custom_bars_side"))).texture("texture", texture);
            BlockModelBuilder sideAlt = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent(barName + "_side_alt", generator.modLoc("block/template/custom_bars_side_alt"))).texture("texture", texture);
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generator.getMultipartBuilder(block.get()).part().modelFile((ModelFile)post).addModel()).condition((Property)CrossCollisionBlock.f_52309_, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.f_52311_, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.f_52310_, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.f_52312_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)side).addModel()).condition((Property)CrossCollisionBlock.f_52309_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.f_52310_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideAlt).addModel()).condition((Property)CrossCollisionBlock.f_52311_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideAlt).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.f_52312_, (Comparable[])new Boolean[]{true}).end();
        }).localizedName(Utils.localizedMaterialName(name, false) + " Bars", "Barras de " + Utils.localizedMaterialName(name, true));
    }

    private static RegisteredBlock autumnLeaves(AutumnTree.Color color, RegisteredBlock sapling) {
        RegisteredBlock regBlock = (RegisteredBlock)BlockTemplates.leaves(color.name().toLowerCase() + "_autumn", "oak", sapling, false).localizedName(color.localizedLeavesColor(false) + " Autumn Leaves", "Hojas " + color.localizedLeavesColor(true) + " de oto\u00f1o");
        Events.registerBasicColoredBlocks(color.leafColor(), regBlock);
        return regBlock;
    }

    private static void genPaneBlockState(String name, String texturePath, RegisteredBlock block, BlockStateGenerator generator) {
        ResourceLocation texture = generator.modLoc("block/" + texturePath);
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder post = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.panePost("block/" + name + "_post", texture, texture)).renderType("translucent");
        BlockModelBuilder side = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.paneSide("block/" + name + "_side", texture, texture)).renderType("translucent");
        BlockModelBuilder sideAlt = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.paneSideAlt("block/" + name + "_side_alt", texture, texture)).renderType("translucent");
        BlockModelBuilder noSide = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.paneNoSide("block/" + name + "_noside", texture)).renderType("translucent");
        BlockModelBuilder noSideAlt = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.paneNoSideAlt("block/" + name + "_noside_alt", texture)).renderType("translucent");
        generator.paneBlock((IronBarsBlock)block.get(), (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
    }
}

