/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.decoration;

import java.util.List;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.decoration.blocks.CustomTable;
import net.paradisemod.world.DeepDarkBlocks;

public class Tables {
    private static List<String> VANILLA_NAMES = List.of("acacia", "birch", "cherry", "mangrove", "bamboo", "crimson", "warped", "dark_oak", "jungle", "spruce");
    public static final RegisteredBlock ACACIA_CRAFTING_TABLE = Tables.regTable("acacia", false);
    public static final RegisteredBlock BIRCH_CRAFTING_TABLE = Tables.regTable("birch", false);
    public static final RegisteredBlock CACTUS_CRAFTING_TABLE = Tables.regTable("cactus", false);
    public static final RegisteredBlock BAMBOO_CRAFTING_TABLE = Tables.regTable("bamboo", false);
    public static final RegisteredBlock CRIMSON_CRAFTING_TABLE = Tables.regTable("crimson", false);
    public static final RegisteredBlock DARK_OAK_CRAFTING_TABLE = Tables.regTable("dark_oak", false);
    public static final RegisteredBlock JUNGLE_CRAFTING_TABLE = Tables.regTable("jungle", false);
    public static final RegisteredBlock PALO_VERDE_CRAFTING_TABLE = Tables.regTable("palo_verde", false);
    public static final RegisteredBlock MESQUITE_CRAFTING_TABLE = Tables.regTable("mesquite", false);
    public static final RegisteredBlock SPRUCE_CRAFTING_TABLE = Tables.regTable("spruce", false);
    public static final RegisteredBlock WARPED_CRAFTING_TABLE = Tables.regTable("warped", false);
    public static final RegisteredBlock CHERRY_CRAFTING_TABLE = Tables.regTable("cherry", false);
    public static final RegisteredBlock MANGROVE_CRAFTING_TABLE = Tables.regTable("mangrove", false);
    public static final RegisteredBlock BLACKENED_OAK_CRAFTING_TABLE = (RegisteredBlock)Tables.regTable("blackened_oak", false).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_CRAFTING_TABLE = (RegisteredBlock)Tables.regTable("blackened_spruce", false).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_CRAFTING_TABLE = (RegisteredBlock)Tables.regTable("glowing_oak", true).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_CRAFTING_TABLE = (RegisteredBlock)Tables.regTable("glowing_cactus", true).tab(DeepDarkBlocks.DEEP_DARK_TAB);

    public static void init() {
    }

    private static RegisteredBlock regTable(String name, boolean glows) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_crafting_table", () -> new CustomTable(glows)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item).m_126130_("pp").m_126130_("pp").m_126127_(Character.valueOf('p'), Utils.getPlanks(name)))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "crafting_table/" + name)).blockStateGenerator((block, generator) -> {
            String planksTexture = "paradisemod:block/" + name + "_planks";
            if (name.contains("cactus")) {
                planksTexture = "paradisemod:block/" + name + "_block";
            }
            if (VANILLA_NAMES.contains(name)) {
                planksTexture = "minecraft:block/" + name + "_planks";
            }
            String frontTexture = "paradisemod:block/crafting_table/" + name + "_front";
            String sideTexture = "paradisemod:block/crafting_table/" + name + "_side";
            String topTexture = "paradisemod:block/crafting_table/" + name + "_top";
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().cube("block/crafting_table/" + name, new ResourceLocation(planksTexture), new ResourceLocation(topTexture), new ResourceLocation(frontTexture), new ResourceLocation(frontTexture), new ResourceLocation(sideTexture), new ResourceLocation(sideTexture))).texture("particle", planksTexture);
            generator.simpleBlock(block.get(), (ModelFile)model);
        }).tag((TagKey<Block>)BlockTags.f_144280_).localizedName(Utils.localizedMaterialName(name, false) + " Crafting Table", "Mesa de trabajo " + (name != "crimson" && name != "warped" ? "de " : "") + Utils.localizedMaterialName(name, true));
    }
}

