/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.decoration.blocks;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.world.PMWorld;

public class PricklyPear
extends Block
implements ModeledBlock {
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)4.0, (double)0.0, (double)6.5, (double)12.0, (double)16.0, (double)9.5);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)6.5, (double)0.0, (double)4.0, (double)9.5, (double)16.0, (double)12.0);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<TiltDir> TILT_DIR = EnumProperty.m_61587_((String)"tilt_dir", TiltDir.class);
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.m_61465_((String)"has_fruit");

    public PricklyPear() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50128_).m_60918_(SoundType.f_56740_).m_60918_(SoundType.f_56745_).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.NONE))).m_61124_((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int blockY = pos.m_123342_();
        OptionalInt groundY = PMWorld.getGroundLevel((LevelAccessor)world, world.m_141937_(), blockY + 3, pos);
        if (groundY.isPresent() && blockY - groundY.getAsInt() < 10) {
            BlockPos newpos;
            BlockPos[] spreadTo = new BlockPos[]{pos.m_7494_().m_122029_(), pos.m_7494_().m_122024_(), pos.m_7494_()};
            if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                spreadTo[0] = pos.m_7494_().m_122012_();
                spreadTo[1] = pos.m_7494_().m_122019_();
            }
            if (!world.m_8055_(newpos = spreadTo[rand.m_188503_(3)]).m_60795_()) {
                return;
            }
            if (world.m_8055_(newpos).m_60713_((Block)this)) {
                return;
            }
            world.m_46597_(newpos, (BlockState)state.m_61124_((Property)HAS_FRUIT, (Comparable)Boolean.valueOf(rand.m_188499_())));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, TILT_DIR, HAS_FRUIT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(AXIS) == Direction.Axis.Z) {
            return SHAPE_Z;
        }
        return SHAPE_X;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (level instanceof Level) {
            Level world = (Level)level;
            if (world.m_8055_(pos.m_122029_()).m_60734_() == this && world.m_8055_(pos.m_122024_()).m_60734_() == this || world.m_8055_(pos.m_122012_()).m_60734_() == this && world.m_8055_(pos.m_122019_()).m_60734_() == this) {
                return (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.NONE));
            }
            if (world.m_8055_(pos.m_7495_().m_122029_()).m_60734_() == this) {
                return (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.WEST));
            }
            if (world.m_8055_(pos.m_7495_().m_122024_()).m_60734_() == this) {
                return (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.EAST));
            }
            if (world.m_8055_(pos.m_7495_().m_122012_()).m_60734_() == this) {
                return (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.SOUTH));
            }
            if (world.m_8055_(pos.m_7495_().m_122019_()).m_60734_() == this) {
                return (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.NORTH));
            }
        }
        return state;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction facing = context.m_7820_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        switch (facing.m_122434_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                BlockState blockState = (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                break;
            }
            case Y: 
            case Z: {
                BlockState blockState = state = (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            }
        }
        if (world.m_8055_(pos.m_122029_()).m_60734_() == this && world.m_8055_(pos.m_122024_()).m_60734_() == this || world.m_8055_(pos.m_122012_()).m_60734_() == this && world.m_8055_(pos.m_122019_()).m_60734_() == this) {
            state = (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.NONE));
        } else if (world.m_8055_(pos.m_7495_().m_122029_()).m_60734_() == this) {
            state = (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.WEST));
        } else if (world.m_8055_(pos.m_7495_().m_122024_()).m_60734_() == this) {
            state = (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.EAST));
        } else if (world.m_8055_(pos.m_7495_().m_122012_()).m_60734_() == this) {
            state = (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.SOUTH));
        } else if (world.m_8055_(pos.m_7495_().m_122019_()).m_60734_() == this) {
            state = (BlockState)state.m_61124_(TILT_DIR, (Comparable)((Object)TiltDir.NORTH));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return;
        }
        PricklyPear.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        List<BlockState> sideBlocks = List.of(world.m_8055_(pos.m_7495_().m_122029_()), world.m_8055_(pos.m_7495_().m_122024_()), world.m_8055_(pos.m_7495_().m_122012_()), world.m_8055_(pos.m_7495_().m_122019_()));
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        for (BlockState sideBlock : sideBlocks) {
            if (!sideBlock.m_60713_((Block)this)) continue;
            return true;
        }
        return blockBelow.m_204336_(PMTags.Blocks.GROUND_BLOCKS) || blockBelow.m_60713_((Block)this);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity creature = (LivingEntity)entity;
            DamageSources damageSources = new DamageSources(world.m_9598_());
            creature.m_6469_(damageSources.m_269325_(), 2.0f);
        }
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.parentBlockItem(this, "prickly_pear_up");
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        ModelFile.ExistingModelFile empty = generator.existingMCModel("air");
        ModelFile.ExistingModelFile up = generator.existingModel("prickly_pear_up");
        ModelFile.ExistingModelFile tilted = generator.existingModel("prickly_pear_tilted");
        ModelFile.ExistingModelFile fruitUp = generator.existingModel("prickly_pear_up_fruit");
        ModelFile.ExistingModelFile fruitTilted = generator.existingModel("prickly_pear_tilted_fruit");
        generator.getVariantBuilder(this).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            TiltDir dir = (TiltDir)((Object)((Object)state.m_61143_(TILT_DIR)));
            boolean hasFruit = (Boolean)state.m_61143_((Property)HAS_FRUIT);
            if (dir == TiltDir.NONE) {
                return generator.buildVariantModel((ModelFile)(hasFruit ? fruitUp : up), 0, axis == Direction.Axis.Z ? 90 : 0);
            }
            if (dir.isAxis(axis)) {
                return generator.buildVariantModel((ModelFile)(hasFruit ? fruitTilted : tilted), dir.toDirection(), true);
            }
            return generator.buildVariantModel((ModelFile)empty);
        });
    }

    public static enum TiltDir implements StringRepresentable
    {
        EAST,
        WEST,
        NORTH,
        SOUTH,
        NONE;


        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public Direction toDirection() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE, WEST -> Direction.WEST;
                case EAST -> Direction.EAST;
                case NORTH -> Direction.NORTH;
                case SOUTH -> Direction.SOUTH;
            };
        }

        public boolean isAxis(Direction.Axis axis) {
            return switch (axis) {
                case Direction.Axis.X -> {
                    if (this == EAST || this == WEST) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> {
                    if (this == NORTH || this == SOUTH) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

