/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.misc.PMArmorMaterial;
import net.paradisemod.misc.Tools;

public class Armor {
    public static final RegisteredItem EMERALD_HELMET = Armor.regArmorItem(PMArmorMaterial.EMERALD, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem EMERALD_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.EMERALD, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem EMERALD_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.EMERALD, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem EMERALD_BOOTS = Armor.regArmorItem(PMArmorMaterial.EMERALD, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem RUBY_HELMET = Armor.regArmorItem(PMArmorMaterial.RUBY, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem RUBY_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.RUBY, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem RUBY_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.RUBY, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem RUBY_BOOTS = Armor.regArmorItem(PMArmorMaterial.RUBY, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem OBSIDIAN_HELMET = Armor.regArmorItem(PMArmorMaterial.OBSIDIAN, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem OBSIDIAN_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.OBSIDIAN, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem OBSIDIAN_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.OBSIDIAN, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem OBSIDIAN_BOOTS = Armor.regArmorItem(PMArmorMaterial.OBSIDIAN, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem REDSTONE_HELMET = Armor.regArmorItem(PMArmorMaterial.REDSTONE, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem REDSTONE_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.REDSTONE, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem REDSTONE_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.REDSTONE, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem REDSTONE_BOOTS = Armor.regArmorItem(PMArmorMaterial.REDSTONE, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem RUSTED_IRON_HELMET = Armor.regArmorItem(PMArmorMaterial.RUSTED_IRON, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem RUSTED_IRON_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.RUSTED_IRON, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem RUSTED_IRON_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.RUSTED_IRON, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem RUSTED_IRON_BOOTS = Armor.regArmorItem(PMArmorMaterial.RUSTED_IRON, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem SILVER_HELMET = Armor.regArmorItem(PMArmorMaterial.SILVER, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem SILVER_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.SILVER, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem SILVER_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.SILVER, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem SILVER_BOOTS = Armor.regArmorItem(PMArmorMaterial.SILVER, ArmorItem.Type.BOOTS, new ItemLike[0]);
    public static final RegisteredItem ENDERITE_HELMET = Armor.regArmorItem(PMArmorMaterial.ENDERITE, ArmorItem.Type.HELMET, new ItemLike[0]);
    public static final RegisteredItem ENDERITE_CHESTPLATE = Armor.regArmorItem(PMArmorMaterial.ENDERITE, ArmorItem.Type.CHESTPLATE, new ItemLike[0]);
    public static final RegisteredItem ENDERITE_LEGGINGS = Armor.regArmorItem(PMArmorMaterial.ENDERITE, ArmorItem.Type.LEGGINGS, new ItemLike[0]);
    public static final RegisteredItem ENDERITE_BOOTS = Armor.regArmorItem(PMArmorMaterial.ENDERITE, ArmorItem.Type.BOOTS, new ItemLike[0]);

    public static void init() {
        MinecraftForge.EVENT_BUS.register(Events.class);
    }

    private static RegisteredItem regArmorItem(PMArmorMaterial material, ArmorItem.Type type, ItemLike ... upgradeFromItems) {
        Item upgradeItem;
        Item.Properties props = new Item.Properties();
        if (material == PMArmorMaterial.OBSIDIAN) {
            props.m_41486_();
        }
        String slotName = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> "boots";
            case ArmorItem.Type.LEGGINGS -> "leggings";
            case ArmorItem.Type.CHESTPLATE -> "chestplate";
            case ArmorItem.Type.HELMET -> "helmet";
        };
        String englishName = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> "Boots";
            case ArmorItem.Type.LEGGINGS -> "Leggings";
            case ArmorItem.Type.CHESTPLATE -> "Chestplate";
            case ArmorItem.Type.HELMET -> "Helmet";
        };
        String spanishName = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> "Botas";
            case ArmorItem.Type.LEGGINGS -> "Grebas";
            case ArmorItem.Type.CHESTPLATE -> "Pechera";
            case ArmorItem.Type.HELMET -> "Yelmo";
        };
        String itemTexture = "armor/" + material.getShortName() + "_" + slotName;
        RegisteredItem armor = (RegisteredItem)((RegisteredItem)((RegisteredItem)PMRegistries.regItem(material.getShortName() + "_" + slotName, () -> new ArmorItem((ArmorMaterial)material, type, new Item.Properties())).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.COMBAT, (ItemLike)item, Armor.armorRecipePattern(type)).m_126127_(Character.valueOf('x'), material.craftingItem()))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_)).tag(PMTags.Items.PRESENTS).model((item, generator) -> generator.basicItem(item.get(), itemTexture)).localizedName(Utils.localizedMaterialName(material.getShortName(), false) + " " + englishName, spanishName + " de " + Utils.localizedMaterialName(material.getShortName(), true));
        if (material == PMArmorMaterial.SILVER) {
            armor = armor.tag(PMTags.Items.SILVER_RECYCLABLES);
        }
        if ((upgradeItem = material.upgradableFrom(type)) != null) {
            armor = (RegisteredItem)armor.smithingRecipe((item, generator) -> generator.smithingRecipe((ItemLike)upgradeItem, (ItemLike)material.getRepairItem(), Tools.SMITHING_UPGRADE, (ItemLike)item, RecipeCategory.COMBAT));
        }
        return armor;
    }

    private static String armorRecipePattern(ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> "xxx\nx x";
            case ArmorItem.Type.CHESTPLATE -> "x x\nxxx\nxxx";
            case ArmorItem.Type.LEGGINGS -> "xxx\nx x\nx x";
            case ArmorItem.Type.BOOTS -> "x x\nx x";
        };
    }

    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void giveXPAndLuckforEmeraldArmor(PlayerEvent event) {
            int numEmeraldArmorPieces = 0;
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            for (ItemStack stack : player.m_6168_()) {
                ArmorItem armor;
                Item item = stack.m_41720_();
                if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != PMArmorMaterial.EMERALD) continue;
                ++numEmeraldArmorPieces;
            }
            if (numEmeraldArmorPieces == 4) {
                Level playerWorld = player.m_9236_();
                if (playerWorld.f_46441_.m_188503_(500) == 0) {
                    player.m_6756_(2);
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 100));
            }
        }

        @SubscribeEvent
        public static void obsidianArmorFireResistance(PlayerEvent event) {
            int numObsidianArmorPieces = 0;
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            for (ItemStack stack : player.m_6168_()) {
                ArmorItem armor;
                Item item = stack.m_41720_();
                if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != PMArmorMaterial.OBSIDIAN) continue;
                ++numObsidianArmorPieces;
            }
            if (numObsidianArmorPieces == 4) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100));
            }
        }
    }
}

