/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.misc.blocks.CustomChest;
import net.paradisemod.misc.tile.CustomChestEntity;
import net.paradisemod.misc.tile.CustomChestRenderer;
import net.paradisemod.world.DeepDarkBlocks;

public class Chests {
    @ObjectHolder(registryName="block", value="paradisemod:cactus_chest")
    public static Block CACTUS_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_cactus_chest")
    public static Block TRAPPED_CACTUS_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:palo_verde_chest")
    public static Block PALO_VERDE_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_palo_verde_chest")
    public static Block TRAPPED_PALO_VERDE_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:mesquite_chest")
    public static Block MESQUITE_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_mesquite_chest")
    public static Block TRAPPED_MESQUITE_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:bamboo_chest")
    public static Block BAMBOO_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_bamboo_chest")
    public static Block TRAPPED_BAMBOO_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:blackened_oak_chest")
    public static Block BLACKENED_OAK_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_blackened_oak_chest")
    public static Block TRAPPED_BLACKENED_OAK_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:blackened_spruce_chest")
    public static Block BLACKENED_SPRUCE_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_blackened_spruce_chest")
    public static Block TRAPPED_BLACKENED_SPRUCE_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:glowing_oak_chest")
    public static Block GLOWING_OAK_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_glowing_oak_chest")
    public static Block TRAPPED_GLOWING_OAK_CHEST = Blocks.f_50325_;
    @ObjectHolder(registryName="block", value="paradisemod:glowing_cactus_chest")
    public static Block GLOWING_CACTUS_CHEST = Blocks.f_50087_;
    @ObjectHolder(registryName="block", value="paradisemod:trapped_glowing_cactus_chest")
    public static Block TRAPPED_GLOWING_CACTUS_CHEST = Blocks.f_50325_;
    public static RegistryObject<BlockEntityType<CustomChestEntity>> CHEST_TILE;

    public static void init(IEventBus eventbus) {
        ArrayList<RegisteredBlock> chests = new ArrayList<RegisteredBlock>();
        for (CustomChest.Type type : CustomChest.Type.values()) {
            chests.add(Chests.createChest(type, false));
            chests.add(Chests.createChest(type, true));
        }
        CHEST_TILE = PMRegistries.createTile("custom_chest", CustomChestEntity::new, chests);
        if (FMLEnvironment.dist.isClient()) {
            eventbus.addListener(event -> BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CHEST_TILE.get()), CustomChestRenderer::new));
        }
    }

    private static RegisteredBlock createChest(final CustomChest.Type chestType, final boolean trapped) {
        String name = chestType.name().toLowerCase() + "_chest";
        if (trapped) {
            name = "trapped_" + name;
        }
        RegisteredBlock chestBlock = PMRegistries.regBlock(name, () -> new CustomChest(chestType, trapped)).tags(Tags.Blocks.CHESTS, BlockTags.f_144280_, BlockTags.f_13088_);
        Supplier<Item> chestItem = () -> new BlockItem(chestBlock.get(), new Item.Properties()){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        final Minecraft mc = Minecraft.m_91087_();
                        return new BlockEntityWithoutLevelRenderer(mc.m_167982_(), mc.m_167973_()){
                            private final BlockEntity tile;
                            {
                                super(pBlockEntityRenderDispatcher, pEntityModelSet);
                                this.tile = new CustomChestEntity(BlockPos.f_121853_, this.m_40614_().m_49966_(), chestType, trapped);
                            }

                            public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                                mc.m_167982_().m_112272_(this.tile, poseStack, buffer, packedLight, packedOverlay);
                            }
                        };
                    }
                });
            }
        };
        RegisteredItem regItem = (RegisteredItem)((RegisteredItem)PMRegistries.regItem(name, chestItem).model((item, generator) -> generator.withExistingParent((trapped ? "trapped_" : "") + chestType.getName() + "_chest", "item/chest")).tab((ResourceKey<CreativeModeTab>)(trapped ? CreativeModeTabs.f_257028_ : CreativeModeTabs.f_256791_))).localizedName(chestType.localizedName(false, trapped), chestType.localizedName(true, trapped));
        if (!chestType.getName().startsWith("dummy")) {
            regItem = (RegisteredItem)regItem.recipe((item, generator) -> {
                ItemLike craftItem = chestType.getCraftItem(trapped);
                if (trapped) {
                    return generator.shapelessRecipe(trapped ? RecipeCategory.REDSTONE : RecipeCategory.DECORATIONS, (ItemLike)item, new ItemLike[]{Blocks.f_50266_, craftItem});
                }
                return generator.getShapedBuilder(trapped ? RecipeCategory.REDSTONE : RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("xxx").m_126130_("x x").m_126130_("xxx").m_126127_(Character.valueOf('x'), craftItem);
            });
        }
        if (chestType.isDeepDarkChest()) {
            regItem = (RegisteredItem)regItem.tab(DeepDarkBlocks.DEEP_DARK_TAB);
        }
        return chestBlock;
    }
}

