/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.BlockTemplates;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.building.Building;
import net.paradisemod.building.Slabs;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.misc.Armor;
import net.paradisemod.misc.Chests;
import net.paradisemod.misc.Tools;
import net.paradisemod.misc.tile.CustomBarrelEntity;
import net.paradisemod.misc.tile.CustomHangingSignEntity;
import net.paradisemod.misc.tile.CustomSignEntity;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;
import net.paradisemod.world.fluid.PMFluids;

public class Misc {
    private static final ArrayList<WoodType> SIGN_WOOD_TYPES = new ArrayList();
    public static final RegisteredItem ENDERITE_INGOT = (RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regBasicItem("enderite_ingot").tags(PMTags.Items.ENDERITE_INGOTS, PMTags.Items.PRESENTS).oreRecipes(Ores.ENDERITE_ORE)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, Ores.ENDERITE_BLOCK))).localizedName("Enderite Ingot", "Lingote de metal del Fin");
    public static final RegisteredItem RUBY = (RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regBasicItem("ruby").tags(PMTags.Items.RUBY_GEMS, PMTags.Items.PRESENTS).oreRecipes(Ores.RUBY_ORE)).oreRecipes(Ores.END_RUBY_ORE)).oreRecipes(Ores.DEEPSLATE_RUBY_ORE)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, Ores.RUBY_BLOCK))).localizedName("Ruby", "Rub\u00ed");
    public static final RegisteredItem RUSTED_IRON_NUGGET = (RegisteredItem)((RegisteredItem)Misc.regBasicItem("rusted_iron_nugget").tag(PMTags.Items.RUSTED_IRON_NUGGETS).localizedName("Rusted Iron Nugget", "Pepita de hierro oxidado")).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, RUSTED_IRON_INGOT));
    public static final RegisteredItem RUSTED_IRON_INGOT = (RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regBasicItem("rusted_iron_ingot").tags(PMTags.Items.RUSTED_IRON_INGOTS, PMTags.Items.PRESENTS).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, Ores.RUSTED_IRON_BLOCK))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), (ItemLike)RUSTED_IRON_NUGGET))).localizedName("Rusted Iron Ingot", "Lingote de hierro oxidado");
    public static final RegisteredItem SILVER_NUGGET = (RegisteredItem)((RegisteredItem)Misc.regBasicItem("silver_nugget").recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, SILVER_INGOT))).tag(PMTags.Items.SILVER_NUGGETS).localizedName("Silver Nugget", "Pepita de plata");
    public static RegisteredItem SILVER_INGOT = (RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regBasicItem("silver_ingot").tags(PMTags.Items.SILVER_INGOTS, PMTags.Items.PRESENTS).oreRecipes(Ores.SILVER_ORE)).oreRecipes(Ores.DEEPSLATE_SILVER_ORE)).oreRecipes(Ores.DARKSTONE_SILVER_ORE)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, Ores.SILVER_BLOCK))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), (ItemLike)SILVER_NUGGET))).localizedName("Silver Ingot", "Lingote de plata");
    public static final RegisteredItem ASPHALT_SHARD = (RegisteredItem)((RegisteredItem)Misc.regBasicItem("asphalt_shard").tag((TagKey<Item>)ItemTags.f_13160_).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 4, Building.ASPHALT))).localizedName("Asphalt Shard", "Fragmento de asfalto");
    public static final RegisteredItem SALT_ITEM = (RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regBasicItem("salt").tag(PMTags.Items.SALT_DUSTS).oreRecipes(Ores.SALT_ORE)).oreRecipes(Ores.DEEPSLATE_SALT_ORE)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 9, Ores.COMPACT_SALT_BLOCK))).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, 4, Ores.SALT_BLOCK))).localizedName("Salt", "Sal");
    public static final RegisteredItem COOKED_EGG = (RegisteredItem)((RegisteredItem)Misc.regFood("cooked_egg", 8, 4.0f, true).cookedFoodRecipes((ItemLike)Items.f_42521_)).localizedName("Cooked Egg", "Huevo cocinado");
    public static final RegisteredItem BEEF_JERKY = (RegisteredItem)((RegisteredItem)Misc.regFood("beef_jerky", 5, 2.5f, true).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Items.f_42579_, SALT_ITEM}))).localizedName("Beef Jerky", "Carne seca");
    public static final RegisteredItem CHICKEN_JERKY = (RegisteredItem)((RegisteredItem)Misc.regFood("chicken_jerky", 4, 2.0f, true).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Items.f_42581_, SALT_ITEM}))).localizedName("Chicken Jerky", "Pollo seco");
    public static final RegisteredItem MUTTON_JERKY = (RegisteredItem)((RegisteredItem)Misc.regFood("mutton_jerky", 4, 2.0f, true).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Items.f_42658_, SALT_ITEM}))).localizedName("Mutton Jerky", "Carne ovina seca");
    public static final RegisteredItem PORK_JERKY = (RegisteredItem)((RegisteredItem)Misc.regFood("pork_jerky", 5, 2.5f, true).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Items.f_42485_, SALT_ITEM}))).localizedName("Pork Jerky", "Puerco seco");
    public static final RegisteredItem SQUID = (RegisteredItem)Misc.regFood("squid", 2, 1.0f, true).localizedName("Squid", "Calamar");
    public static final RegisteredItem COOKED_SQUID = (RegisteredItem)((RegisteredItem)Misc.regFood("cooked_squid", 6, 3.0f, true).cookedFoodRecipes(SQUID)).localizedName("Cooked Squid", "Calamar cocinado");
    public static final RegisteredItem NOPAL = (RegisteredItem)Misc.regFood("nopal", 1, 0.5f, false).localizedName("Nopal", "Nopal");
    public static final RegisteredItem PRICKLY_PEAR_FRUIT = (RegisteredItem)Misc.regFood("prickly_pear_fruit", 4, 2.0f, false).localizedName("Prickly Pear Fruit", "Fruta de nopal");
    public static final RegisteredItem SOUL_PUMPKIN_PIE = (RegisteredItem)((RegisteredItem)((RegisteredItem)Misc.regFood("soul_pumpkin_pie", 8, 3.0f, false).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Decoration.SOUL_PUMPKIN, Items.f_42501_, Items.f_42521_}))).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.FOOD, (ItemLike)item, new ItemLike[]{Decoration.CARVED_SOUL_PUMPKIN, Items.f_42501_, Items.f_42521_}))).localizedName("Soul Pumpkin Pie", "Pastel de calabaza de almas");
    public static final RegisteredItem CHERRY = (RegisteredItem)Misc.regFood("cherry", 2, 1.0f, false).localizedName("Cherry", "Cereza");
    public static final RegisteredItem ACORN = (RegisteredItem)Misc.regFood("acorn", 1, 0.5f, false).localizedName("Acorn", "Bellota");
    public static final RegisteredItem COOKED_ACORN = (RegisteredItem)((RegisteredItem)Misc.regFood("cooked_acorn", 4, 2.0f, false).cookedFoodRecipes(ACORN)).localizedName("Cooked Acorn", "Bellota cocinada");
    public static final RegisteredItem HONEY_CRYSTAL = (RegisteredItem)Misc.regFood("honey_crystal", 2, 0.1f, false).localizedName("Honey Crystal", "Cristal de miel");
    public static final RegisteredBlock ACACIA_BARREL = BlockTemplates.barrel("acacia", false, (ItemLike)Blocks.f_50744_, (ItemLike)Blocks.f_50402_);
    public static final RegisteredBlock BIRCH_BARREL = BlockTemplates.barrel("birch", false, (ItemLike)Blocks.f_50742_, (ItemLike)Blocks.f_50400_);
    public static final RegisteredBlock CHERRY_BARREL = BlockTemplates.barrel("cherry", false, (ItemLike)Blocks.f_271304_, (ItemLike)Blocks.f_271301_);
    public static final RegisteredBlock CRIMSON_BARREL = BlockTemplates.barrel("crimson", false, (ItemLike)Blocks.f_50655_, (ItemLike)Blocks.f_50657_);
    public static final RegisteredBlock DARK_OAK_BARREL = BlockTemplates.barrel("dark_oak", false, (ItemLike)Blocks.f_50745_, (ItemLike)Blocks.f_50403_);
    public static final RegisteredBlock JUNGLE_BARREL = BlockTemplates.barrel("jungle", false, (ItemLike)Blocks.f_50743_, (ItemLike)Blocks.f_50401_);
    public static final RegisteredBlock MANGROVE_BARREL = BlockTemplates.barrel("mangrove", false, (ItemLike)Blocks.f_220865_, (ItemLike)Blocks.f_220851_);
    public static final RegisteredBlock SPRUCE_BARREL = BlockTemplates.barrel("spruce", false, (ItemLike)Blocks.f_50741_, (ItemLike)Blocks.f_50399_);
    public static final RegisteredBlock WARPED_BARREL = BlockTemplates.barrel("warped", false, (ItemLike)Blocks.f_50656_, (ItemLike)Blocks.f_50658_);
    public static final RegisteredBlock BAMBOO_BARREL = BlockTemplates.barrel("bamboo", false, (ItemLike)Blocks.f_244477_, (ItemLike)Blocks.f_244004_);
    public static final RegisteredBlock CACTUS_BARREL = BlockTemplates.barrel("cactus", false, Building.CACTUS_BLOCK, Slabs.CACTUS_SLAB);
    public static final RegisteredBlock PALO_VERDE_BARREL = BlockTemplates.barrel("palo_verde", false, Building.PALO_VERDE_PLANKS, Slabs.PALO_VERDE_SLAB);
    public static final RegisteredBlock MESQUITE_BARREL = BlockTemplates.barrel("mesquite", false, Building.MESQUITE_PLANKS, Slabs.MESQUITE_SLAB);
    public static final RegisteredBlock GLOWING_CACTUS_BARREL = (RegisteredBlock)BlockTemplates.barrel("glowing_cactus", false, DeepDarkBlocks.GLOWING_CACTUS_BLOCK, Slabs.GLOWING_CACTUS_SLAB).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_BARREL = (RegisteredBlock)BlockTemplates.barrel("blackened_oak", false, DeepDarkBlocks.BLACKENED_OAK_PLANKS, Slabs.BLACKENED_OAK_SLAB).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_BARREL = (RegisteredBlock)BlockTemplates.barrel("blackened_spruce", false, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS, Slabs.BLACKENED_SPRUCE_SLAB).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_BARREL = (RegisteredBlock)BlockTemplates.barrel("glowing_oak", true, DeepDarkBlocks.GLOWING_OAK_PLANKS, Slabs.GLOWING_OAK_SLAB).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final WoodType CACTUS_TYPE = Misc.createWoodType("cactus");
    public static final WoodType GLOWING_CACTUS_TYPE = Misc.createWoodType("glowing_cactus");
    public static final WoodType PALO_VERDE_TYPE = Misc.createWoodType("palo_verde");
    public static final WoodType MESQUITE_TYPE = Misc.createWoodType("mesquite");
    public static final WoodType BLACKENED_OAK_TYPE = Misc.createWoodType("blackened_oak");
    public static final WoodType BLACKENED_SPRUCE_TYPE = Misc.createWoodType("blackened_spruce");
    public static final WoodType GLOWING_OAK_TYPE = Misc.createWoodType("glowing_oak");
    public static final RegisteredBlock CACTUS_SIGN = BlockTemplates.sign("cactus", CACTUS_TYPE, false, false);
    public static final RegisteredBlock CACTUS_WALL_SIGN = BlockTemplates.sign("cactus", CACTUS_TYPE, true, false);
    public static final RegisteredItem CACTUS_SIGN_ITEM = BlockTemplates.signItem("cactus", CACTUS_SIGN, CACTUS_WALL_SIGN, Building.CACTUS_BLOCK);
    public static final RegisteredBlock CACTUS_HANGING_SIGN = BlockTemplates.hangingSign("cactus", CACTUS_TYPE, false, false);
    public static final RegisteredBlock CACTUS_WALL_HANGING_SIGN = BlockTemplates.hangingSign("cactus", CACTUS_TYPE, true, false);
    public static final RegisteredItem CACTUS_HANGING_SIGN_ITEM = BlockTemplates.hangingSignItem("cactus", CACTUS_HANGING_SIGN, CACTUS_WALL_HANGING_SIGN, Building.CACTUS_BLOCK);
    public static final RegisteredBlock GLOWING_CACTUS_SIGN = BlockTemplates.sign("glowing_cactus", GLOWING_CACTUS_TYPE, false, false);
    public static final RegisteredBlock GLOWING_CACTUS_WALL_SIGN = BlockTemplates.sign("glowing_cactus", GLOWING_CACTUS_TYPE, true, false);
    public static final RegisteredItem GLOWING_CACTUS_SIGN_ITEM = (RegisteredItem)BlockTemplates.signItem("glowing_cactus", GLOWING_CACTUS_SIGN, GLOWING_CACTUS_WALL_SIGN, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS_HANGING_SIGN = BlockTemplates.hangingSign("glowing_cactus", GLOWING_CACTUS_TYPE, false, false);
    public static final RegisteredBlock GLOWING_CACTUS_WALL_HANGING_SIGN = BlockTemplates.hangingSign("glowing_cactus", GLOWING_CACTUS_TYPE, true, false);
    public static final RegisteredItem GLOWING_CACTUS_HANGING_SIGN_ITEM = (RegisteredItem)BlockTemplates.hangingSignItem("glowing_cactus", GLOWING_CACTUS_HANGING_SIGN, GLOWING_CACTUS_WALL_HANGING_SIGN, DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock PALO_VERDE_SIGN = BlockTemplates.sign("palo_verde", PALO_VERDE_TYPE, false, false);
    public static final RegisteredBlock PALO_VERDE_WALL_SIGN = BlockTemplates.sign("palo_verde", PALO_VERDE_TYPE, true, false);
    public static final RegisteredItem PALO_VERDE_SIGN_ITEM = BlockTemplates.signItem("palo_verde", PALO_VERDE_SIGN, PALO_VERDE_WALL_SIGN, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock PALO_VERDE_HANGING_SIGN = BlockTemplates.hangingSign("palo_verde", PALO_VERDE_TYPE, false, false);
    public static final RegisteredBlock PALO_VERDE_WALL_HANGING_SIGN = BlockTemplates.hangingSign("palo_verde", PALO_VERDE_TYPE, true, false);
    public static final RegisteredItem PALO_VERDE_HANGING_SIGN_ITEM = BlockTemplates.hangingSignItem("palo_verde", PALO_VERDE_HANGING_SIGN, PALO_VERDE_WALL_HANGING_SIGN, Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_SIGN = BlockTemplates.sign("mesquite", MESQUITE_TYPE, false, false);
    public static final RegisteredBlock MESQUITE_WALL_SIGN = BlockTemplates.sign("mesquite", MESQUITE_TYPE, true, false);
    public static final RegisteredItem MESQUITE_SIGN_ITEM = BlockTemplates.signItem("mesquite", MESQUITE_SIGN, MESQUITE_WALL_SIGN, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock MESQUITE_HANGING_SIGN = BlockTemplates.hangingSign("mesquite", MESQUITE_TYPE, false, false);
    public static final RegisteredBlock MESQUITE_WALL_HANGING_SIGN = BlockTemplates.hangingSign("mesquite", MESQUITE_TYPE, true, false);
    public static final RegisteredItem MESQUITE_HANGING_SIGN_ITEM = BlockTemplates.hangingSignItem("mesquite", MESQUITE_HANGING_SIGN, MESQUITE_WALL_HANGING_SIGN, Building.MESQUITE_PLANKS);
    public static final RegisteredBlock BLACKENED_OAK_SIGN = BlockTemplates.sign("blackened_oak", BLACKENED_OAK_TYPE, false, true);
    public static final RegisteredBlock BLACKENED_OAK_WALL_SIGN = BlockTemplates.sign("blackened_oak", BLACKENED_OAK_TYPE, true, true);
    public static final RegisteredItem BLACKENED_OAK_SIGN_ITEM = (RegisteredItem)BlockTemplates.signItem("blackened_oak", BLACKENED_OAK_SIGN, BLACKENED_OAK_WALL_SIGN, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_HANGING_SIGN = BlockTemplates.hangingSign("blackened_oak", BLACKENED_OAK_TYPE, false, true);
    public static final RegisteredBlock BLACKENED_OAK_WALL_HANGING_SIGN = BlockTemplates.hangingSign("blackened_oak", BLACKENED_OAK_TYPE, true, true);
    public static final RegisteredItem BLACKENED_OAK_HANGING_SIGN_ITEM = (RegisteredItem)BlockTemplates.hangingSignItem("blackened_oak", BLACKENED_OAK_HANGING_SIGN, BLACKENED_OAK_WALL_HANGING_SIGN, DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_SIGN = BlockTemplates.sign("blackened_spruce", BLACKENED_SPRUCE_TYPE, false, false);
    public static final RegisteredBlock BLACKENED_SPRUCE_WALL_SIGN = BlockTemplates.sign("blackened_spruce", BLACKENED_SPRUCE_TYPE, true, false);
    public static final RegisteredItem BLACKENED_SPRUCE_SIGN_ITEM = (RegisteredItem)BlockTemplates.signItem("blackened_spruce", BLACKENED_SPRUCE_SIGN, BLACKENED_SPRUCE_WALL_SIGN, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_HANGING_SIGN = BlockTemplates.hangingSign("blackened_spruce", BLACKENED_SPRUCE_TYPE, false, false);
    public static final RegisteredBlock BLACKENED_SPRUCE_WALL_HANGING_SIGN = BlockTemplates.hangingSign("blackened_spruce", BLACKENED_SPRUCE_TYPE, true, false);
    public static final RegisteredItem BLACKENED_SPRUCE_HANGING_SIGN_ITEM = (RegisteredItem)BlockTemplates.hangingSignItem("blackened_spruce", BLACKENED_SPRUCE_HANGING_SIGN, BLACKENED_SPRUCE_WALL_HANGING_SIGN, DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_SIGN = BlockTemplates.sign("glowing_oak", GLOWING_OAK_TYPE, false, true);
    public static final RegisteredBlock GLOWING_OAK_WALL_SIGN = BlockTemplates.sign("glowing_oak", GLOWING_OAK_TYPE, true, true);
    public static final RegisteredItem GLOWING_OAK_SIGN_ITEM = (RegisteredItem)BlockTemplates.signItem("glowing_oak", GLOWING_OAK_SIGN, GLOWING_OAK_WALL_SIGN, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_HANGING_SIGN = BlockTemplates.hangingSign("glowing_oak", GLOWING_OAK_TYPE, false, true);
    public static final RegisteredBlock GLOWING_OAK_WALL_HANGING_SIGN = BlockTemplates.hangingSign("glowing_oak", GLOWING_OAK_TYPE, true, true);
    public static final RegisteredItem GLOWING_OAK_HANGING_SIGN_ITEM = (RegisteredItem)BlockTemplates.hangingSignItem("glowing_oak", GLOWING_OAK_HANGING_SIGN, GLOWING_OAK_WALL_HANGING_SIGN, DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegistryObject<BlockEntityType<CustomBarrelEntity>> CUSTOM_BARREL_TILE = PMRegistries.createTile("custom_barrel", CustomBarrelEntity::new, CACTUS_BARREL, GLOWING_CACTUS_BARREL, BAMBOO_BARREL, PALO_VERDE_BARREL, MESQUITE_BARREL, BLACKENED_OAK_BARREL, BLACKENED_SPRUCE_BARREL, GLOWING_OAK_BARREL, ACACIA_BARREL, BIRCH_BARREL, CHERRY_BARREL, CRIMSON_BARREL, DARK_OAK_BARREL, JUNGLE_BARREL, MANGROVE_BARREL, SPRUCE_BARREL, WARPED_BARREL);
    public static final RegistryObject<BlockEntityType<CustomSignEntity>> CUSTOM_SIGN_TILE = PMRegistries.createTile("custom_sign", CustomSignEntity::new, CACTUS_SIGN, CACTUS_WALL_SIGN, GLOWING_CACTUS_SIGN, GLOWING_CACTUS_WALL_SIGN, PALO_VERDE_SIGN, PALO_VERDE_WALL_SIGN, MESQUITE_SIGN, MESQUITE_WALL_SIGN, BLACKENED_OAK_SIGN, BLACKENED_OAK_WALL_SIGN, BLACKENED_SPRUCE_SIGN, BLACKENED_SPRUCE_WALL_SIGN, GLOWING_OAK_SIGN, GLOWING_OAK_WALL_SIGN);
    public static final RegistryObject<BlockEntityType<CustomHangingSignEntity>> CUSTOM_HANGING_SIGN_TILE = PMRegistries.createTile("custom_hanging_sign", CustomHangingSignEntity::new, CACTUS_HANGING_SIGN, CACTUS_WALL_HANGING_SIGN, GLOWING_CACTUS_HANGING_SIGN, GLOWING_CACTUS_WALL_HANGING_SIGN, PALO_VERDE_HANGING_SIGN, PALO_VERDE_WALL_HANGING_SIGN, MESQUITE_HANGING_SIGN, MESQUITE_WALL_HANGING_SIGN, BLACKENED_OAK_HANGING_SIGN, BLACKENED_OAK_WALL_HANGING_SIGN, BLACKENED_SPRUCE_HANGING_SIGN, BLACKENED_SPRUCE_WALL_HANGING_SIGN, GLOWING_OAK_HANGING_SIGN, GLOWING_OAK_WALL_HANGING_SIGN);
    public static final RegisteredBlock PRISMARINE_CRYSTAL_BLOCK = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("prismarine_crystal_block", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_60955_().m_60978_(0.3f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("cc").m_126130_("cc").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42696_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).renderType("translucent").lootTable((block, generator) -> generator.multipleItemDrop((Block)block, (ItemLike)Items.f_42696_, 4)).localizedName("Prismarine Crystal Block", "Bloque de cristales de prismarina");
    public static final RegisteredBlock HONEY_CRYSTAL_BLOCK = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("honey_crystal_block", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_60955_().m_60978_(0.3f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("hh").m_126130_("hh").m_126127_(Character.valueOf('h'), (ItemLike)HONEY_CRYSTAL))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).renderType("translucent").tag(PMTags.Blocks.CARVABLES).lootTable((block, generator) -> generator.multipleItemDrop((Block)block, HONEY_CRYSTAL, 4)).localizedName("Honey Crystal Block", "Bloque de cristales de miel");
    public static RegisteredBlock GLOWING_ICE = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowing_ice", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_60918_(SoundType.f_56744_).m_60953_(state -> 7).m_60911_(1.0f).m_60955_().m_60978_(0.3f)){

        public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
            Set enchantments = stack.getAllEnchantments().keySet();
            if (!enchantments.contains(Enchantments.f_44985_)) {
                world.m_46597_(pos, PMFluids.GLOWING_WATER_BLOCK.get().m_49966_());
            }
        }
    }).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).renderType("translucent").tag(PMTags.Blocks.CARVABLES).localizedName("Glowing Ice", "Hielo brillante");
    public static final RegisteredBlock SALT_LAMP = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("salt_lamp", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56744_).m_60953_(s -> 15).m_60955_().m_60978_(0.3f))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("sss").m_126130_("sbs").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)SALT_ITEM).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42593_))).tabs(CreativeModeTabs.f_256788_, CreativeModeTabs.f_256791_)).tag(PMTags.Blocks.CARVABLES).localizedName("Salt Lamp", "Luz de sal");

    public static void init(IEventBus eventbus) {
        Misc.createSignLootTable(CACTUS_SIGN, CACTUS_WALL_SIGN, CACTUS_SIGN_ITEM);
        Misc.createSignLootTable(GLOWING_CACTUS_SIGN, GLOWING_CACTUS_WALL_SIGN, GLOWING_CACTUS_SIGN_ITEM);
        Misc.createSignLootTable(PALO_VERDE_SIGN, PALO_VERDE_WALL_SIGN, PALO_VERDE_SIGN_ITEM);
        Misc.createSignLootTable(MESQUITE_SIGN, MESQUITE_WALL_SIGN, MESQUITE_SIGN_ITEM);
        Misc.createSignLootTable(BLACKENED_OAK_SIGN, BLACKENED_OAK_WALL_SIGN, BLACKENED_OAK_SIGN_ITEM);
        Misc.createSignLootTable(BLACKENED_SPRUCE_SIGN, BLACKENED_SPRUCE_WALL_SIGN, BLACKENED_SPRUCE_SIGN_ITEM);
        Misc.createSignLootTable(GLOWING_OAK_SIGN, GLOWING_OAK_WALL_SIGN, GLOWING_OAK_SIGN_ITEM);
        Misc.createSignLootTable(CACTUS_HANGING_SIGN, CACTUS_WALL_HANGING_SIGN, CACTUS_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(GLOWING_CACTUS_HANGING_SIGN, GLOWING_CACTUS_WALL_HANGING_SIGN, GLOWING_CACTUS_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(PALO_VERDE_HANGING_SIGN, PALO_VERDE_WALL_HANGING_SIGN, PALO_VERDE_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(MESQUITE_HANGING_SIGN, MESQUITE_WALL_HANGING_SIGN, MESQUITE_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(BLACKENED_OAK_HANGING_SIGN, BLACKENED_OAK_WALL_HANGING_SIGN, BLACKENED_OAK_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(BLACKENED_SPRUCE_HANGING_SIGN, BLACKENED_SPRUCE_WALL_HANGING_SIGN, BLACKENED_SPRUCE_HANGING_SIGN_ITEM);
        Misc.createSignLootTable(GLOWING_OAK_HANGING_SIGN, GLOWING_OAK_WALL_HANGING_SIGN, GLOWING_OAK_HANGING_SIGN_ITEM);
        Chests.init(eventbus);
        Armor.init();
        Tools.init();
        eventbus.addListener(Misc::regSignTypes);
        SILVER_INGOT = (RegisteredItem)SILVER_INGOT.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), (ItemLike)SILVER_NUGGET));
        ParadiseMod.LOG.info("Loaded Miscellaneous module");
    }

    private static WoodType createWoodType(String name) {
        WoodType woodType = new WoodType("paradisemod:" + name, PMBlockSetTypes.VARIANT_WOOD);
        SIGN_WOOD_TYPES.add(woodType);
        return woodType;
    }

    private static void createSignLootTable(RegisteredBlock sign, RegisteredBlock wallSign, RegisteredItem signItem) {
        sign = sign.dropsItem(signItem);
        wallSign = wallSign.dropsItem(signItem);
    }

    private static void regSignTypes(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (WoodType woodType : SIGN_WOOD_TYPES) {
                WoodType.m_61844_((WoodType)woodType);
            }
        });
    }

    public static void initClient(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CUSTOM_SIGN_TILE.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)CUSTOM_HANGING_SIGN_TILE.get()), HangingSignRenderer::new);
        event.enqueueWork(() -> {
            for (WoodType woodType : SIGN_WOOD_TYPES) {
                Sheets.addWoodType((WoodType)woodType);
            }
        });
    }

    private static RegisteredItem regFood(String name, int hungerPoints, float saturation, boolean wolfFood) {
        FoodProperties.Builder foodProps = new FoodProperties.Builder().m_38760_(hungerPoints).m_38758_(saturation);
        if (wolfFood) {
            foodProps = foodProps.m_38757_();
        }
        Item.Properties properties = new Item.Properties().m_41489_(foodProps.m_38767_()).m_41487_(64);
        return (RegisteredItem)PMRegistries.regItem(name, () -> new Item(properties)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256839_);
    }

    protected static RegisteredItem regBasicItem(String name) {
        return (RegisteredItem)PMRegistries.regItem(name, () -> new Item(new Item.Properties())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
    }
}

