/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.paradisemod.misc.Misc;

public enum PMArmorMaterial implements ArmorMaterial
{
    EMERALD(35, new int[]{4, 6, 8, 4}, 40, SoundEvents.f_11673_, 3.0f, 0.0f, () -> Items.f_42616_),
    RUBY(35, new int[]{4, 6, 8, 4}, 40, SoundEvents.f_11673_, 3.0f, 0.0f, () -> Items.f_42616_),
    OBSIDIAN(40, new int[]{4, 7, 9, 4}, 15, SoundEvents.f_11679_, 3.0f, 0.5f, () -> ((Block)Blocks.f_50080_).m_5456_()),
    REDSTONE(3, new int[]{8, 10, 12, 7}, 40, SoundEvents.f_11679_, 0.0f, 1.0f, () -> Items.f_42451_),
    RUSTED_IRON(15, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11677_, 0.0f, 0.0f, Misc.RUSTED_IRON_INGOT),
    SILVER(15, new int[]{1, 3, 5, 2}, 25, SoundEvents.f_11676_, 0.0f, 0.0f, Misc.SILVER_INGOT),
    ENDERITE(74, new int[]{6, 12, 16, 6}, 30, SoundEvents.f_11679_, 6.0f, 0.2f, Misc.ENDERITE_INGOT);

    private static final int[] MAX_DAMAGE;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Item> repairItem;

    private PMArmorMaterial(int maxDamage, int[] damageReduction, int enchantLevel, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Item> repairItem) {
        this.maxDamageFactor = maxDamage;
        this.damageReductionAmountArray = damageReduction;
        this.enchantability = enchantLevel;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairItem = repairItem;
        this.soundEvent = sound;
    }

    public int m_266425_(ArmorItem.Type type) {
        return MAX_DAMAGE[type.ordinal()] * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmountArray[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.repairItem.get()});
    }

    public String m_6082_() {
        return "paradisemod:" + this.getShortName();
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String getShortName() {
        return this.name().toLowerCase();
    }

    public ItemLike craftingItem() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case EMERALD -> Items.f_42616_;
            case RUBY -> Misc.RUBY;
            case OBSIDIAN -> Blocks.f_50080_;
            case REDSTONE -> Items.f_42451_;
            case RUSTED_IRON -> Misc.RUSTED_IRON_INGOT;
            case SILVER -> Misc.SILVER_INGOT;
            case ENDERITE -> Misc.ENDERITE_INGOT;
        };
    }

    @Nullable
    public Item upgradableFrom(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.BOOTS -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42475_;
                    }
                    case ENDERITE: {
                        yield Items.f_42483_;
                    }
                }
                yield null;
            }
            case ArmorItem.Type.LEGGINGS -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42474_;
                    }
                    case ENDERITE: {
                        yield Items.f_42482_;
                    }
                }
                yield null;
            }
            case ArmorItem.Type.CHESTPLATE -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42473_;
                    }
                    case ENDERITE: {
                        yield Items.f_42481_;
                    }
                }
                yield null;
            }
            case ArmorItem.Type.HELMET -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42472_;
                    }
                    case ENDERITE: {
                        yield Items.f_42480_;
                    }
                }
                yield null;
            }
        };
    }

    public Item getRepairItem() {
        return this.repairItem.get();
    }

    static {
        MAX_DAMAGE = new int[]{13, 15, 16, 11};
    }
}

