/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.paradisemod.misc.Misc;
import net.paradisemod.misc.Tools;

public enum PMToolTier implements Tier
{
    RUSTED_IRON(2, 125, 12.0f, 2.0f, 22, Misc.RUSTED_IRON_INGOT, (TagKey<Block>)BlockTags.f_144285_),
    SILVER(2, 64, 12.0f, 2.0f, 22, Misc.SILVER_INGOT, (TagKey<Block>)BlockTags.f_144285_),
    EMERALD(4, 1700, 9.0f, 4.0f, 30, () -> Items.f_42616_, (TagKey<Block>)BlockTags.f_144284_),
    RUBY(4, 1700, 9.0f, 4.0f, 30, Misc.RUBY, (TagKey<Block>)BlockTags.f_144284_),
    OBSIDIAN(4, 3122, 10.0f, 5.0f, 30, () -> ((Block)Blocks.f_50080_).m_5456_(), (TagKey<Block>)BlockTags.f_144284_),
    REDSTONE(6, 16, 100.0f, 10.0f, 45, () -> Items.f_42451_, (TagKey<Block>)BlockTags.f_144284_),
    ENDERITE(8, 4062, 18.0f, 8.0f, 30, Misc.ENDERITE_INGOT, (TagKey<Block>)BlockTags.f_144284_);

    private final int harvestLevel;
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Item> repairItem;
    private final TagKey<Block> harvestTag;

    private PMToolTier(int harvestLevel, int maxUses, float efficiency, float attackDamage, int enchantLevel, Supplier<Item> repairItem, TagKey<Block> harvestTag) {
        this.harvestLevel = harvestLevel;
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.enchantability = enchantLevel;
        this.repairItem = repairItem;
        this.harvestTag = harvestTag;
    }

    public int m_6609_() {
        return this.maxUses;
    }

    public float m_6624_() {
        return this.efficiency;
    }

    public float m_6631_() {
        return this.attackDamage;
    }

    public int m_6604_() {
        return this.harvestLevel;
    }

    public int m_6601_() {
        return this.enchantability;
    }

    public Item getRepairItem() {
        return this.repairItem.get();
    }

    public Item getStickItem() {
        return switch (this) {
            case EMERALD, RUBY -> Items.f_42416_;
            case REDSTONE -> Blocks.f_50174_.m_5456_();
            case OBSIDIAN, ENDERITE -> Items.f_42415_;
            default -> Items.f_42398_;
        };
    }

    @Nullable
    public Item upgradableFrom(Tools.ToolType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Tools.ToolType.AXE -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42391_;
                    }
                    case ENDERITE: {
                        yield Items.f_42396_;
                    }
                }
                yield null;
            }
            case Tools.ToolType.HOE -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42392_;
                    }
                    case ENDERITE: {
                        yield Items.f_42397_;
                    }
                }
                yield null;
            }
            case Tools.ToolType.PICKAXE -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42390_;
                    }
                    case ENDERITE: {
                        yield Items.f_42395_;
                    }
                }
                yield null;
            }
            case Tools.ToolType.SHOVEL -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42389_;
                    }
                    case ENDERITE: {
                        yield Items.f_42394_;
                    }
                }
                yield null;
            }
            case Tools.ToolType.SWORD -> {
                switch (this) {
                    case EMERALD: 
                    case RUBY: 
                    case OBSIDIAN: {
                        yield Items.f_42388_;
                    }
                    case ENDERITE: {
                        yield Items.f_42393_;
                    }
                }
                yield null;
            }
        };
    }

    public Ingredient m_6282_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getRepairItem()});
    }

    public TagKey<Block> getTag() {
        return this.harvestTag;
    }

    public String getShortName() {
        return this.name().toLowerCase();
    }
}

