/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc;

import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.misc.Misc;
import net.paradisemod.misc.PMToolTier;

public class Tools {
    public static final RegisteredItem SMITHING_UPGRADE = (RegisteredItem)((RegisteredItem)Misc.regBasicItem("smithing_upgrade").recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.COMBAT, (ItemLike)item, 2).m_126130_("gug").m_126130_("gsg").m_126130_("ggg").m_126127_(Character.valueOf('u'), (ItemLike)item).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('s'), (ItemLike)Blocks.f_50069_))).localizedName("Smithing Upgrade", "Mejora de herrer\u00eda");
    public static final RegisteredItem EMERALD_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.EMERALD);
    public static final RegisteredItem EMERALD_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.EMERALD);
    public static final RegisteredItem EMERALD_AXE = Tools.regTool(ToolType.AXE, PMToolTier.EMERALD);
    public static final RegisteredItem EMERALD_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.EMERALD);
    public static final RegisteredItem EMERALD_HOE = Tools.regTool(ToolType.HOE, PMToolTier.EMERALD);
    public static final RegisteredItem RUBY_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.RUBY);
    public static final RegisteredItem RUBY_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.RUBY);
    public static final RegisteredItem RUBY_AXE = Tools.regTool(ToolType.AXE, PMToolTier.RUBY);
    public static final RegisteredItem RUBY_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.RUBY);
    public static final RegisteredItem RUBY_HOE = Tools.regTool(ToolType.HOE, PMToolTier.RUBY);
    public static final RegisteredItem OBSIDIAN_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.OBSIDIAN);
    public static final RegisteredItem OBSIDIAN_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.OBSIDIAN);
    public static final RegisteredItem OBSIDIAN_AXE = Tools.regTool(ToolType.AXE, PMToolTier.OBSIDIAN);
    public static final RegisteredItem OBSIDIAN_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.OBSIDIAN);
    public static final RegisteredItem OBSIDIAN_HOE = Tools.regTool(ToolType.HOE, PMToolTier.OBSIDIAN);
    public static final RegisteredItem REDSTONE_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.REDSTONE);
    public static final RegisteredItem REDSTONE_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.REDSTONE);
    public static final RegisteredItem REDSTONE_AXE = Tools.regTool(ToolType.AXE, PMToolTier.REDSTONE);
    public static final RegisteredItem REDSTONE_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.REDSTONE);
    public static final RegisteredItem REDSTONE_HOE = Tools.regTool(ToolType.HOE, PMToolTier.REDSTONE);
    public static final RegisteredItem RUSTED_IRON_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.RUSTED_IRON);
    public static final RegisteredItem RUSTED_IRON_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.RUSTED_IRON);
    public static final RegisteredItem RUSTED_IRON_AXE = Tools.regTool(ToolType.AXE, PMToolTier.RUSTED_IRON);
    public static final RegisteredItem RUSTED_IRON_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.RUSTED_IRON);
    public static final RegisteredItem RUSTED_IRON_HOE = Tools.regTool(ToolType.HOE, PMToolTier.RUSTED_IRON);
    public static final RegisteredItem SILVER_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.SILVER);
    public static final RegisteredItem SILVER_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.SILVER);
    public static final RegisteredItem SILVER_AXE = Tools.regTool(ToolType.AXE, PMToolTier.SILVER);
    public static final RegisteredItem SILVER_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.SILVER);
    public static final RegisteredItem SILVER_HOE = Tools.regTool(ToolType.HOE, PMToolTier.SILVER);
    public static final RegisteredItem ENDERITE_SWORD = Tools.regTool(ToolType.SWORD, PMToolTier.ENDERITE);
    public static final RegisteredItem ENDERITE_PICKAXE = Tools.regTool(ToolType.PICKAXE, PMToolTier.ENDERITE);
    public static final RegisteredItem ENDERITE_AXE = Tools.regTool(ToolType.AXE, PMToolTier.ENDERITE);
    public static final RegisteredItem ENDERITE_SHOVEL = Tools.regTool(ToolType.SHOVEL, PMToolTier.ENDERITE);
    public static final RegisteredItem ENDERITE_HOE = Tools.regTool(ToolType.HOE, PMToolTier.ENDERITE);

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ToolEvents.class);
    }

    private static RegisteredItem regTool(ToolType type, PMToolTier tier) {
        Item upgradeItem;
        Item.Properties props = new Item.Properties();
        if (tier == PMToolTier.OBSIDIAN) {
            props = props.m_41486_();
        }
        Supplier<Item> tool = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ToolType.AXE -> () -> new AxeItem((Tier)tier, (float)((int)tier.m_6631_() + 4), 1.0f, new Item.Properties());
            case ToolType.HOE -> () -> new HoeItem((Tier)tier, 0, 4.0f, new Item.Properties());
            case ToolType.SWORD -> () -> new SwordItem((Tier)tier, (int)tier.m_6631_(), 3.0f, new Item.Properties());
            case ToolType.SHOVEL -> () -> new ShovelItem((Tier)tier, (float)((int)tier.m_6631_() - 4), 1.0f, new Item.Properties());
            case ToolType.PICKAXE -> () -> new PickaxeItem((Tier)tier, (int)tier.m_6631_() - 2, 1.0f, new Item.Properties());
        };
        String texture = "paradisemod:item/tool/" + tier.getShortName() + "_" + type.getName();
        Object englishMaterialName = Utils.localizedMaterialName(tier.getShortName(), false);
        englishMaterialName = ((String)englishMaterialName).substring(0, 1).toUpperCase() + ((String)englishMaterialName).substring(1);
        RegisteredItem toolItem = (RegisteredItem)((RegisteredItem)((RegisteredItem)PMRegistries.regItem(tier.getShortName() + "_" + type.getName(), tool).recipe((item, generator) -> generator.getShapedBuilder(type == ToolType.SWORD ? RecipeCategory.COMBAT : RecipeCategory.TOOLS, (ItemLike)item, type.recipePattern()).m_126127_(Character.valueOf('x'), (ItemLike)tier.getRepairItem()).m_126127_(Character.valueOf('y'), (ItemLike)tier.getStickItem()))).tab((ResourceKey<CreativeModeTab>)(type == ToolType.SWORD ? CreativeModeTabs.f_256797_ : CreativeModeTabs.f_256869_))).model((item, generator) -> ((ItemModelBuilder)((ItemModelBuilder)generator.getBuilder(tier.getShortName() + "_" + type.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", texture)).tag(PMTags.Items.PRESENTS).localizedName((String)englishMaterialName + " " + type.localizedName(false), type.localizedName(true) + " de " + Utils.localizedMaterialName(tier.getShortName(), true));
        if (type == ToolType.AXE) {
            toolItem = (RegisteredItem)toolItem.tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_);
        }
        if (tier == PMToolTier.SILVER) {
            toolItem = toolItem.tag(PMTags.Items.SILVER_RECYCLABLES);
        }
        if ((upgradeItem = tier.upgradableFrom(type)) != null) {
            toolItem = (RegisteredItem)toolItem.smithingRecipe((item, generator) -> generator.smithingRecipe((ItemLike)upgradeItem, (ItemLike)tier.getRepairItem(), SMITHING_UPGRADE, (ItemLike)item, type == ToolType.SWORD ? RecipeCategory.COMBAT : RecipeCategory.TOOLS));
        }
        return toolItem;
    }

    private static class ToolEvents {
        private ToolEvents() {
        }

        @SubscribeEvent
        public static void attackedByRustedIronTool(LivingAttackEvent event) {
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof LivingEntity) {
                TieredItem tool;
                LivingEntity attacker = (LivingEntity)entity;
                LivingEntity victim = event.getEntity();
                if (victim == null) {
                    return;
                }
                Item item = attacker.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                if (item instanceof TieredItem && (tool = (TieredItem)item).m_43314_() == PMToolTier.RUSTED_IRON) {
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 400));
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 400));
                }
            }
        }
    }

    protected static enum ToolType {
        PICKAXE,
        AXE,
        HOE,
        SWORD,
        SHOVEL;


        String getName() {
            return this.name().toLowerCase();
        }

        private String recipePattern() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PICKAXE -> "xxx\n y \n y ";
                case AXE -> " xx\n yx\n y ";
                case HOE -> " xx\n y \n y ";
                case SWORD -> " x \n x \n y ";
                case SHOVEL -> " x \n y \n y ";
            };
        }

        private String localizedName(boolean spanish) {
            if (spanish) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case PICKAXE -> "Pico";
                    case AXE -> "Hacha";
                    case HOE -> "Azada";
                    case SWORD -> "Espada";
                    case SHOVEL -> "Pala";
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PICKAXE -> "Shovel";
                case AXE -> "Axe";
                case HOE -> "Hoe";
                case SWORD -> "Sword";
                case SHOVEL -> "Shovel";
            };
        }
    }
}

