/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.building.Building;
import net.paradisemod.misc.Chests;
import net.paradisemod.misc.tile.CustomChestEntity;
import net.paradisemod.world.DeepDarkBlocks;

public class CustomChest
extends ChestBlock
implements ModeledBlock {
    private final Type chestType;
    private final boolean trapped;

    public CustomChest(Type chestType, boolean isTrapped) {
        super(BlockType.WOOD.getProperties().m_60953_(s -> chestType.getLightLevel()), () -> Chests.CHEST_TILE.get());
        this.chestType = chestType;
        this.trapped = isTrapped;
    }

    public CustomChestEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CustomChestEntity(pos, state, this.chestType, this.trapped);
    }

    public boolean m_7899_(@Nullable BlockState state) {
        return this.trapped;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (this.trapped) {
            int numPlayers = ChestBlockEntity.m_59086_((BlockGetter)world, (BlockPos)pos);
            return Math.min(numPlayers, 15);
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (this.trapped) {
            return side == Direction.UP ? blockState.m_60746_(blockAccess, pos, side) : 0;
        }
        return 0;
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().getBuilder("block/chest/" + this.chestType.getName() + (this.trapped ? "_trapped" : ""))).texture("particle", this.chestType.particleTexture());
        generator.simpleBlock((Block)this, (ModelFile)model);
    }

    public static enum Type {
        DUMMY1(false, 0),
        DUMMY2(false, 0),
        DUMMY3(false, 0),
        CACTUS(false, 0),
        PALO_VERDE(false, 0),
        MESQUITE(false, 0),
        BLACKENED_OAK(true, 0),
        BLACKENED_SPRUCE(true, 0),
        GLOWING_OAK(true, 7),
        GLOWING_CACTUS(true, 7);

        private final boolean deepDarkChest;
        private final int light;

        private Type(boolean deepDarkChest, int light) {
            this.deepDarkChest = deepDarkChest;
            this.light = light;
        }

        public boolean isDeepDarkChest() {
            return this.deepDarkChest;
        }

        public int getLightLevel() {
            return this.light;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public String localizedName(boolean spanish, boolean trapped) {
            return switch (this) {
                case DUMMY1 -> {
                    if (spanish) {
                        yield "Cofre falso 1" + (trapped ? " con trampa" : "");
                    }
                    yield (trapped ? "Trapped " : "") + "Dummy Chest 1";
                }
                case DUMMY2 -> {
                    if (spanish) {
                        yield "Cofre falso 2" + (trapped ? " con trampa" : "");
                    }
                    yield (trapped ? "Trapped " : "") + "Dummy Chest 2";
                }
                case DUMMY3 -> {
                    if (spanish) {
                        yield "Cofre falso 3" + (trapped ? " con trampa" : "");
                    }
                    yield (trapped ? "Trapped " : "") + "Dummy Chest 3";
                }
                default -> spanish ? "Cofre de " + Utils.localizedMaterialName(this.getName(), true) + (trapped ? " con trampa" : "") : (trapped ? "Trapped " : "") + Utils.localizedMaterialName(this.getName(), false) + " Chest";
            };
        }

        public String particleTexture() {
            return switch (this) {
                default -> "paradisemod:block/" + this.getName() + "_planks";
                case CACTUS, GLOWING_CACTUS -> "paradisemod:block/" + this.getName() + "_block";
                case DUMMY1 -> "minecraft:block/blue_wool";
                case DUMMY2 -> "minecraft:block/red_wool";
                case DUMMY3 -> "minecraft:block/yellow_wool";
            };
        }

        @Nullable
        public ItemLike getCraftItem(boolean trapped) {
            return switch (this) {
                case CACTUS -> {
                    if (trapped) {
                        yield Chests.CACTUS_CHEST;
                    }
                    yield Building.CACTUS_BLOCK;
                }
                case PALO_VERDE -> {
                    if (trapped) {
                        yield Chests.PALO_VERDE_CHEST;
                    }
                    yield Building.PALO_VERDE_PLANKS;
                }
                case MESQUITE -> {
                    if (trapped) {
                        yield Chests.MESQUITE_CHEST;
                    }
                    yield Building.MESQUITE_PLANKS;
                }
                case BLACKENED_OAK -> {
                    if (trapped) {
                        yield Chests.BLACKENED_OAK_CHEST;
                    }
                    yield DeepDarkBlocks.BLACKENED_OAK_PLANKS;
                }
                case BLACKENED_SPRUCE -> {
                    if (trapped) {
                        yield Chests.BLACKENED_SPRUCE_CHEST;
                    }
                    yield DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS;
                }
                case GLOWING_OAK -> {
                    if (trapped) {
                        yield Chests.GLOWING_OAK_CHEST;
                    }
                    yield DeepDarkBlocks.GLOWING_OAK_PLANKS;
                }
                case GLOWING_CACTUS -> {
                    if (trapped) {
                        yield Chests.GLOWING_CACTUS_CHEST;
                    }
                    yield DeepDarkBlocks.GLOWING_CACTUS_BLOCK;
                }
                default -> null;
            };
        }
    }
}

