/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.misc.tile;

import java.util.EnumMap;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.paradisemod.misc.blocks.CustomChest;
import net.paradisemod.misc.tile.CustomChestEntity;

public class CustomChestRenderer
extends ChestRenderer<CustomChestEntity> {
    private static EnumMap<CustomChest.Type, EnumMap<ChestType, Material>> NORMAL_TEXTURES = new EnumMap(CustomChest.Type.class);
    private static EnumMap<CustomChest.Type, EnumMap<ChestType, Material>> TRAPPED_TEXTURES = new EnumMap(CustomChest.Type.class);

    public CustomChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(CustomChestEntity chest, ChestType type) {
        CustomChest.Type chestType = chest.getChestType();
        EnumMap<ChestType, Material> normalTextures = NORMAL_TEXTURES.get((Object)chestType);
        EnumMap<ChestType, Material> trappedTextures = TRAPPED_TEXTURES.get((Object)chestType);
        return chest.isTrapped() ? trappedTextures.get(type) : normalTextures.get(type);
    }

    private static Material createChesMaterial(CustomChest.Type chest, ChestType type, boolean trapped) {
        String texName = chest.name().toLowerCase() + (trapped ? "_trapped" : "") + (String)(type == ChestType.SINGLE ? "" : "_" + type.name().toLowerCase());
        return new Material(Sheets.f_110740_, new ResourceLocation("paradisemod", "entity/chest/" + texName));
    }

    static {
        for (CustomChest.Type chest : CustomChest.Type.values()) {
            EnumMap<ChestType, Material> normalTextures = new EnumMap<ChestType, Material>(ChestType.class);
            EnumMap<ChestType, Material> trappedTextures = new EnumMap<ChestType, Material>(ChestType.class);
            for (ChestType type : ChestType.values()) {
                normalTextures.put(type, CustomChestRenderer.createChesMaterial(chest, type, false));
                trappedTextures.put(type, CustomChestRenderer.createChesMaterial(chest, type, true));
            }
            NORMAL_TEXTURES.put(chest, normalTextures);
            TRAPPED_TEXTURES.put(chest, trappedTextures);
        }
    }
}

