/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.monsters.client;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class CreatureRenderer<C extends Mob, M extends EntityModel<C>>
extends MobRenderer<C, M> {
    private final TextureSupplier<C> textureSupplier;

    public CreatureRenderer(EntityRendererProvider.Context context, M model, String texture, float shadowRadius) {
        super(context, model, shadowRadius);
        this.textureSupplier = c -> new ResourceLocation(texture);
    }

    public CreatureRenderer(EntityRendererProvider.Context context, M model, TextureSupplier<C> textureSupplier, float shadowRadius) {
        super(context, model, shadowRadius);
        this.textureSupplier = textureSupplier;
    }

    public CreatureRenderer(EntityRendererProvider.Context context, M model, String texture) {
        this(context, model, texture, 0.5f);
    }

    public CreatureRenderer(EntityRendererProvider.Context context, M model, TextureSupplier<C> textureSupplier) {
        this(context, model, textureSupplier, 0.5f);
    }

    public ResourceLocation getTextureLocation(C creature) {
        return this.textureSupplier.getTexture(creature);
    }

    public static interface TextureSupplier<C> {
        public ResourceLocation getTexture(C var1);
    }
}

