/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.monsters.client;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.paradisemod.monsters.client.CreatureModel;
import net.paradisemod.monsters.client.GargoyleAnimations;
import net.paradisemod.monsters.gargoyle.Gargoyle;

public class GargoyleModel
extends CreatureModel<Gargoyle> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("paradisemod", "gargoyle"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart wing1;
    private final ModelPart wing2;

    public GargoyleModel(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.root = root.m_171324_("root");
        this.leg1 = this.root.m_171324_("leg1");
        this.leg2 = this.root.m_171324_("leg2");
        this.body = this.root.m_171324_("body");
        this.head = this.root.m_171324_("head");
        this.arms = this.root.m_171324_("arms");
        this.wing1 = this.root.m_171324_("wing1");
        this.wing2 = this.root.m_171324_("wing2");
    }

    public void setupAnim(Gargoyle gargoyle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(gargoyle.attackingState, GargoyleAnimations.ATTACK, ageInTicks);
        this.m_233381_(gargoyle.flyingState, GargoyleAnimations.FLYING, ageInTicks);
        this.m_267799_(GargoyleAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.turnHeadToLook(gargoyle, this.head, headPitch, netHeadYaw);
        if (gargoyle.getState().isFlying()) {
            this.head.f_104203_ = -45.0f;
            this.root.f_104203_ = 45.0f;
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_().m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)0.0f));
        root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(16, 24).m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(16, 24).m_171488_(-2.0f, 0.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(26, 12).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, -7.0f, -3.0f, 10.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-2.0f, (float)0.0f));
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 17).m_171488_(0.0f, 2.0f, -3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-1.5f, -1.0f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 0).m_171488_(1.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 0).m_171488_(-1.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-12.0f, (float)-0.5f));
        root.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(11.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-7.0f, (float)0.0f));
        root.m_171599_("wing1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-11.0f, -2.0f, 0.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-11.0f, 0.0f, 1.0f, 11.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-5.0f, (float)2.0f));
        root.m_171599_("wing2", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(0.0f, -2.0f, 0.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(0.0f, 0.0f, 1.0f, 11.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-5.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

