/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.monsters.gargoyle;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMBlockTags;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.building.Building;
import net.paradisemod.monsters.gargoyle.GargoyleMoveControl;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;

public class Gargoyle
extends Monster
implements NeutralMob,
VariantHolder<Variant>,
FlyingAnimal {
    public static final EntityDataSerializer<State> STATE_SERIALIZER = EntityDataSerializer.m_238090_(State.class);
    public static final EntityDataSerializer<Variant> VARIANT_SERIALIZER = EntityDataSerializer.m_238090_(Variant.class);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Gargoyle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Variant> VARIANT = SynchedEntityData.m_135353_(Gargoyle.class, VARIANT_SERIALIZER);
    private static final EntityDataAccessor<State> STATE = SynchedEntityData.m_135353_(Gargoyle.class, STATE_SERIALIZER);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)14, (int)49);
    public AnimationState flyingState = new AnimationState();
    public AnimationState attackingState = new AnimationState();
    @Nullable
    private UUID persistentAngerTarget;

    public Gargoyle(EntityType<Gargoyle> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new GargoyleMoveControl(this);
        this.f_21364_ = 12;
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public Variant getVariant() {
        return (Variant)((Object)this.f_19804_.m_135370_(VARIANT));
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(STATE));
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public boolean m_6935_(Player player) {
        return this.m_21674_((LivingEntity)player);
    }

    public boolean m_29443_() {
        return this.getState().isFlying();
    }

    public void m_6710_(@Nullable LivingEntity creature) {
        if (creature instanceof Player) {
            Player player = (Player)creature;
            this.m_6598_(player);
        }
        super.m_6710_(creature);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("variant", this.getVariant().m_7912_());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)Variant.checkedValueOf(nbt.m_128461_("variant")));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key == STATE) {
            State state = this.getState();
            if (state.isFlying()) {
                this.flyingState.m_216977_(this.f_19797_);
            } else {
                this.flyingState.m_216973_();
            }
            if (state.isAttacking()) {
                this.attackingState.m_216977_(this.f_19797_);
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        BlockState blockBelow = world.m_8055_(this.m_20183_().m_7495_());
        this.setVariant(Variant.fromBlock(blockBelow));
        return super.m_6518_(world, difficulty, reason, spawnData, nbt);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return !world.m_8055_(this.m_20183_().m_7495_()).m_60795_();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_144108_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_144108_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)Variant.STONE);
        this.f_19804_.m_135372_(STATE, (Object)State.NONE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FlyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Gargoyle)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected ResourceLocation m_7582_() {
        RandomSource rand = this.m_9236_().f_46441_;
        Variant variant = this.getVariant();
        ResourceLocation blockKey = ForgeRegistries.BLOCKS.getKey((Object)variant.getDrop(rand));
        String nameSpace = blockKey.m_135827_();
        String name = blockKey.m_135815_();
        return new ResourceLocation(nameSpace, "blocks/" + name);
    }

    public static enum Variant implements StringRepresentable
    {
        ANDESITE(() -> Blocks.f_50334_, () -> Blocks.f_50387_),
        BLACKENED_SANDSTONE(DeepDarkBlocks.BLACKENED_SAND, DeepDarkBlocks.BLACKENED_SANDSTONE, DeepDarkBlocks.CUT_BLACKENED_SANDSTONE, DeepDarkBlocks.CHISELED_BLACKENED_SANDSTONE),
        CALCITE(() -> Blocks.f_152497_, Building.POLISHED_CALCITE, Building.POLISHED_CALCITE_BRICKS, Building.CHISELED_POLISHED_CALCITE),
        DARKSTONE(DeepDarkBlocks.GLOWING_NYLIUM, DeepDarkBlocks.OVERGROWN_DARKSTONE, DeepDarkBlocks.DARKSTONE, DeepDarkBlocks.POLISHED_DARKSTONE, DeepDarkBlocks.POLISHED_DARKSTONE_BRICKS, DeepDarkBlocks.CHISELED_POLISHED_DARKSTONE),
        DEEPSLATE(() -> Blocks.f_152550_, () -> Blocks.f_152593_, () -> Blocks.f_152555_, () -> Blocks.f_152589_, () -> Blocks.f_152551_, () -> Blocks.f_152559_),
        DIORITE(() -> Blocks.f_50228_, () -> Blocks.f_50281_),
        DRIPSTONE(() -> Blocks.f_152537_, Building.POLISHED_DRIPSTONE, Building.POLISHED_DRIPSTONE_BRICKS, Building.CHISELED_POLISHED_DRIPSTONE),
        END_STONE(PMWorld.OVERGROWN_END_STONE, () -> Blocks.f_50259_, Building.POLISHED_END_STONE, () -> Blocks.f_50443_),
        GRANITE(() -> Blocks.f_50122_, () -> Blocks.f_50175_),
        RED_SANDSTONE(() -> Blocks.f_49993_, () -> Blocks.f_50394_, () -> Blocks.f_50396_, () -> Blocks.f_50395_),
        SANDSTONE(() -> Blocks.f_49992_, () -> Blocks.f_50062_, () -> Blocks.f_50064_, () -> Blocks.f_50063_),
        STONE(() -> Blocks.f_50069_, () -> Blocks.f_50470_, () -> Blocks.f_50222_, () -> Blocks.f_50223_, () -> Blocks.f_50652_, () -> Blocks.f_50079_),
        TUFF(() -> Blocks.f_152496_, Building.POLISHED_TUFF, Building.POLISHED_TUFF_BRICKS, Building.CHISELED_POLISHED_TUFF);

        private final List<Supplier<Block>> matchingBlocks;

        @SafeVarargs
        private Variant(Supplier<Block> ... matchingBlocks) {
            this.matchingBlocks = List.of(matchingBlocks);
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public TagKey<Block> getTag() {
            return PMTags.createModTag("spawns_" + this.m_7912_() + "_gargoyles", Registries.f_256747_);
        }

        public Block getDrop(RandomSource rand) {
            ITag<Block> tag = Utils.getBlockTag(this.getTag());
            return (Block)tag.getRandomElement(rand).get();
        }

        public static Variant fromBlock(BlockState block) {
            for (Variant variant : Variant.values()) {
                String blockName = ForgeRegistries.BLOCKS.getKey((Object)block.m_60734_()).m_135815_();
                if (!block.m_204336_(variant.getTag()) && !blockName.contains(variant.m_7912_())) continue;
                return variant;
            }
            return STONE;
        }

        public static Variant checkedValueOf(String name) {
            try {
                return Variant.valueOf(name.toUpperCase());
            }
            catch (Exception yes) {
                return STONE;
            }
        }

        public static void genTags(PMBlockTags provider) {
            for (Variant variant : Variant.values()) {
                provider.m_206424_(variant.getTag()).m_255179_((Object[])((Block[])variant.matchingBlocks.stream().map(Supplier::get).toArray(Block[]::new)));
            }
        }
    }

    public static enum State {
        NONE,
        ATTACKING,
        FLYING,
        ATTACKING_IN_FLIGHT;


        public boolean isFlying() {
            return this == FLYING || this == ATTACKING_IN_FLIGHT;
        }

        public boolean isAttacking() {
            return this == ATTACKING || this == ATTACKING_IN_FLIGHT;
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        private final Gargoyle gargoyle;

        AttackGoal(Gargoyle gargoyle2) {
            super((PathfinderMob)gargoyle2, 0.5, false);
            this.gargoyle = gargoyle2;
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double attackReachSqr1 = this.m_6639_(enemy);
            if (distToEnemySqr <= attackReachSqr1 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.gargoyle.m_6674_(InteractionHand.MAIN_HAND);
                this.gargoyle.m_7327_((Entity)enemy);
                if (this.gargoyle.getState().isFlying()) {
                    this.gargoyle.setState(State.ATTACKING_IN_FLIGHT);
                } else {
                    this.gargoyle.setState(State.ATTACKING);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.gargoyle.getState().isFlying()) {
                this.gargoyle.setState(State.FLYING);
            } else {
                this.gargoyle.setState(State.NONE);
            }
        }
    }

    private class FlyGoal
    extends WaterAvoidingRandomFlyingGoal {
        private final Gargoyle gargoyle;

        FlyGoal(Gargoyle gargoyle2) {
            super((PathfinderMob)gargoyle2, 1.0);
            this.gargoyle = gargoyle2;
        }

        public void m_8056_() {
            this.gargoyle.m_20242_(true);
            double x = this.gargoyle.m_20185_();
            double y = this.gargoyle.m_20186_();
            double z = this.gargoyle.m_20189_();
            this.gargoyle.m_6034_(x, y + 0.5, z);
            if (this.gargoyle.getState().isAttacking()) {
                this.gargoyle.setState(State.ATTACKING_IN_FLIGHT);
            } else {
                this.gargoyle.setState(State.FLYING);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            this.gargoyle.m_20242_(false);
            this.gargoyle.setState(State.NONE);
            super.m_8041_();
        }
    }
}

