/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.monsters.werewolf;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.paradisemod.misc.PMToolTier;
import net.paradisemod.monsters.Monsters;
import net.paradisemod.monsters.werewolf.WerewolfIllager;

public class Werewolf
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Werewolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RAID_CAPTAIN = SynchedEntityData.m_135353_(Werewolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MORPH_COOLDOWN = SynchedEntityData.m_135353_(Werewolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackingState = new AnimationState();

    public Werewolf(EntityType<Werewolf> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 35;
    }

    public void shouldAttack(boolean attack) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attack);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key == IS_ATTACKING && this.isAttacking()) {
            this.attackingState.m_216977_(this.f_19797_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Level world = this.m_9236_();
        if (world.m_8044_() % 24000L < 18000L && !world.m_46470_() && this.canMorph()) {
            WerewolfIllager illager = Monsters.WEREWOLF_ILLAGER.create(world);
            illager.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            illager.armSword();
            illager.m_33075_(this.isRaidCaptain());
            illager.m_21530_();
            if (this.isRaidCaptain()) {
                illager.m_8061_(EquipmentSlot.HEAD, Raid.m_37779_());
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)illager);
            world.m_7967_((Entity)illager);
            this.m_146870_();
        }
    }

    public EntityType<Werewolf> m_6095_() {
        return Monsters.WEREWOLF.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188499_() ? SoundEvents.f_12620_ : SoundEvents.f_12619_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IS_RAID_CAPTAIN, (Object)false);
        this.f_19804_.m_135372_(MORPH_COOLDOWN, (Object)100);
    }

    public void m_8119_() {
        super.m_8119_();
        Integer cooldown = (Integer)this.f_19804_.m_135370_(MORPH_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(MORPH_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        TieredItem item;
        LivingEntity creature;
        Item item2;
        Entity causingEntity = source.m_7639_();
        if (causingEntity != null && causingEntity instanceof LivingEntity && (item2 = (creature = (LivingEntity)causingEntity).m_21205_().m_41720_()) instanceof TieredItem && (item = (TieredItem)item2).m_43314_() == PMToolTier.SILVER) {
            return super.m_6469_(source, amount * 3.0f);
        }
        return super.m_6469_(source, amount);
    }

    private boolean canMorph() {
        Integer cooldown = (Integer)this.f_19804_.m_135370_(MORPH_COOLDOWN);
        return cooldown == 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Ocelot.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Cat.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        this.m_21530_();
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("PatrolLeader", this.isRaidCaptain());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.shouldBeRaidCaptain(nbt.m_128471_("PatrolLeader"));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Monsters.WEREWOLF_ILLAGER.getSpawnEgg());
    }

    protected void shouldBeRaidCaptain(boolean isCaptain) {
        this.f_19804_.m_135381_(IS_RAID_CAPTAIN, (Object)isCaptain);
    }

    protected boolean isRaidCaptain() {
        return (Boolean)this.f_19804_.m_135370_(IS_RAID_CAPTAIN);
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        private final Werewolf werewolf;

        AttackGoal(Werewolf werewolf2) {
            super((PathfinderMob)werewolf2, 1.0, false);
            this.werewolf = werewolf2;
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double attackReachSqr1 = this.m_6639_(enemy);
            if (distToEnemySqr <= attackReachSqr1 && this.m_25565_() <= 0) {
                this.m_25563_();
                this.werewolf.m_6674_(InteractionHand.MAIN_HAND);
                this.werewolf.m_7327_((Entity)enemy);
                this.werewolf.shouldAttack(true);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.werewolf.shouldAttack(false);
        }
    }
}

