/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.monsters.werewolf;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.paradisemod.misc.PMToolTier;
import net.paradisemod.misc.Tools;
import net.paradisemod.monsters.Monsters;
import net.paradisemod.monsters.werewolf.Werewolf;

public class WerewolfIllager
extends AbstractIllager {
    private static final EntityDataAccessor<Integer> MORPH_COOLDOWN = SynchedEntityData.m_135353_(WerewolfIllager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public WerewolfIllager(EntityType<WerewolfIllager> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 35;
    }

    public void m_7895_(int wave, boolean unusedFalse) {
        boolean flag;
        ItemStack itemstack = new ItemStack((ItemLike)Tools.RUSTED_IRON_SWORD);
        Raid raid = this.m_37885_();
        int i = 1;
        if (wave > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.f_44977_, i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12620_;
    }

    public void m_8107_() {
        super.m_8107_();
        Level world = this.m_9236_();
        if ((world.m_46940_() > 0.9f && world.m_8044_() % 24000L >= 18000L || world.m_46470_()) && this.canMorph()) {
            Werewolf werewolf = Monsters.WEREWOLF.create(world);
            werewolf.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            werewolf.shouldBeRaidCaptain(this.m_33067_());
            werewolf.m_21530_();
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)werewolf);
            world.m_7967_((Entity)werewolf);
            this.m_146870_();
        }
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity creature;
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && (creature = (LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && creature.m_5647_() == null;
        }
        return false;
    }

    public EntityType<WerewolfIllager> m_6095_() {
        return Monsters.WEREWOLF_ILLAGER.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MORPH_COOLDOWN, (Object)100);
    }

    public void m_8119_() {
        super.m_8119_();
        Integer cooldown = (Integer)this.f_19804_.m_135370_(MORPH_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(MORPH_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        TieredItem item;
        LivingEntity creature;
        Item item2;
        Entity causingEntity = source.m_7639_();
        if (causingEntity != null && causingEntity instanceof LivingEntity && (item2 = (creature = (LivingEntity)causingEntity).m_21205_().m_41720_()) instanceof TieredItem && (item = (TieredItem)item2).m_43314_() == PMToolTier.SILVER) {
            return super.m_6469_(source, amount * 3.0f);
        }
        return super.m_6469_(source, amount);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        SpawnGroupData newSpawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = world.m_213780_();
        this.m_213945_(randomsource, difficulty);
        this.m_213946_(randomsource, difficulty);
        this.m_21530_();
        return newSpawnData;
    }

    private boolean canMorph() {
        return (Integer)this.f_19804_.m_135370_(MORPH_COOLDOWN) == 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WerewolfBreakDoorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance difficulty) {
        if (this.m_37885_() == null) {
            this.armSword();
        }
    }

    protected void armSword() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Tools.RUSTED_IRON_SWORD));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12051_;
    }

    private class WerewolfBreakDoorGoal
    extends BreakDoorGoal {
        WerewolfBreakDoorGoal(WerewolfIllager werewolf) {
            super((Mob)werewolf, 6, diff -> diff == Difficulty.NORMAL || diff == Difficulty.HARD);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return this.getWerewolf().m_37886_() && super.m_8045_();
        }

        public boolean m_8036_() {
            return this.getWerewolf().m_37886_() && this.getWerewolf().f_19796_.m_188503_(WerewolfBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }

        private WerewolfIllager getWerewolf() {
            return (WerewolfIllager)this.f_25189_;
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        AttackGoal(WerewolfIllager werewolf) {
            super((PathfinderMob)werewolf, 1.0, false);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * f * 2.0f + attackTarget.m_20205_();
            }
            return super.m_6639_(attackTarget);
        }
    }
}

