/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone;

import java.util.ArrayList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;

public class Buttons {
    public static final RegisteredBlock ANDESITE_BUTTON = Buttons.regStoneButton("andesite", (ItemLike)Blocks.f_50334_);
    public static final RegisteredBlock DIORITE_BUTTON = Buttons.regStoneButton("diorite", (ItemLike)Blocks.f_50228_);
    public static final RegisteredBlock GRANITE_BUTTON = Buttons.regStoneButton("granite", (ItemLike)Blocks.f_50122_);
    public static final RegisteredBlock COBBLESTONE_BUTTON = Buttons.regStoneButton("cobblestone", (ItemLike)Blocks.f_50652_);
    public static final RegisteredBlock DEEPSLATE_BUTTON = Buttons.regStoneButton("deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152550_);
    public static final RegisteredBlock POLISHED_DEEPSLATE_BUTTON = Buttons.regStoneButton("polished_deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152555_);
    public static final RegisteredBlock COBBLED_DEEPSLATE_BUTTON = Buttons.regStoneButton("cobbled_deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152551_);
    public static final RegisteredBlock MOSSY_COBBLESTONE_BUTTON = Buttons.regStoneButton("mossy_cobblestone", (ItemLike)Blocks.f_50079_);
    public static final RegisteredBlock END_STONE_BUTTON = Buttons.regStoneButton("end_stone", (ItemLike)Blocks.f_50259_);
    public static final RegisteredBlock DRIPSTONE_BUTTON = Buttons.regStoneButton("dripstone", PMBlockSetTypes.DRIPSTONE, (ItemLike)Blocks.f_152537_);
    public static final RegisteredBlock CALCITE_BUTTON = Buttons.regStoneButton("calcite", PMBlockSetTypes.CALCITE, (ItemLike)Blocks.f_152497_);
    public static final RegisteredBlock TUFF_BUTTON = Buttons.regStoneButton("tuff", PMBlockSetTypes.TUFF, (ItemLike)Blocks.f_152496_);
    public static final RegisteredBlock DARKSTONE_BUTTON = (RegisteredBlock)Buttons.regStoneButton("darkstone", DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKSTONE_BUTTON = Buttons.regStoneButton("blackstone", (ItemLike)Blocks.f_50730_);
    public static final RegisteredBlock POLISHED_ANDESITE_BUTTON = Buttons.regStoneButton("polished_andesite", (ItemLike)Blocks.f_50387_);
    public static final RegisteredBlock POLISHED_DIORITE_BUTTON = Buttons.regStoneButton("polished_diorite", (ItemLike)Blocks.f_50281_);
    public static final RegisteredBlock POLISHED_GRANITE_BUTTON = Buttons.regStoneButton("polished_granite", (ItemLike)Blocks.f_50175_);
    public static final RegisteredBlock POLISHED_DRIPSTONE_BUTTON = Buttons.regStoneButton("polished_dripstone", PMBlockSetTypes.DRIPSTONE, Building.POLISHED_DRIPSTONE);
    public static final RegisteredBlock POLISHED_CALCITE_BUTTON = Buttons.regStoneButton("polished_calcite", PMBlockSetTypes.CALCITE, Building.POLISHED_CALCITE);
    public static final RegisteredBlock POLISHED_TUFF_BUTTON = Buttons.regStoneButton("polished_tuff", PMBlockSetTypes.TUFF, Building.POLISHED_TUFF);
    public static final RegisteredBlock SMOOTH_STONE_BUTTON = Buttons.regStoneButton("smooth_stone", (ItemLike)Blocks.f_50470_);
    public static final RegisteredBlock POLISHED_END_STONE_BUTTON = Buttons.regStoneButton("polished_end_stone", Building.POLISHED_END_STONE);
    public static final RegisteredBlock POLISHED_DARKSTONE_BUTTON = Buttons.regStoneButton("polished_darkstone", DeepDarkBlocks.POLISHED_DARKSTONE);
    public static final RegisteredBlock SANDSTONE_BUTTON = Buttons.regStoneButton("sandstone", (ItemLike)Blocks.f_50062_);
    public static final RegisteredBlock RED_SANDSTONE_BUTTON = Buttons.regStoneButton("red_sandstone", (ItemLike)Blocks.f_50394_);
    public static final RegisteredBlock BLACKENED_SANDSTONE_BUTTON = (RegisteredBlock)Buttons.regStoneButton("blackened_sandstone", DeepDarkBlocks.BLACKENED_SANDSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BEDROCK_BUTTON = Buttons.regButton("bedrock", 20, BlockType.INDESTRUCTIBLE, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock OBSIDIAN_BUTTON = Buttons.regButton("obsidian", 20, BlockType.STRONG_STONE, (ItemLike)Blocks.f_50080_);
    public static final RegisteredBlock DIRT_BUTTON = Buttons.regButton("dirt", 20, PMBlockSetTypes.SOIL, BlockType.SOIL, (ItemLike)Blocks.f_50493_).tags(BlockTags.f_13093_, BlockTags.f_144283_);
    public static final RegisteredBlock GRASS_BUTTON = Buttons.regButton("grass", 20, PMBlockSetTypes.GRASS, BlockType.SOIL, (ItemLike)Blocks.f_50440_).tags(BlockTags.f_13093_, BlockTags.f_144283_);
    public static final RegisteredBlock DIAMOND_BUTTON = Buttons.regMetalButton("diamond", 14, (ItemLike)Items.f_42415_);
    public static final RegisteredBlock EMERALD_BUTTON = Buttons.regMetalButton("emerald", 10, (ItemLike)Items.f_42616_);
    public static final RegisteredBlock RUBY_BUTTON = Buttons.regMetalButton("ruby", 2, Misc.RUBY);
    public static final RegisteredBlock RUSTED_IRON_BUTTON = Buttons.regMetalButton("rusted_iron", 2, Misc.RUSTED_IRON_INGOT);
    public static final RegisteredBlock SILVER_BUTTON = Buttons.regMetalButton("silver", 20, Misc.SILVER_INGOT);
    public static final RegisteredBlock GLASS_BUTTON = Buttons.regButton("glass", 5, PMBlockSetTypes.GLASS, BlockType.GLASS, (ItemLike)Blocks.f_50058_).tag((TagKey<Block>)BlockTags.f_13093_);
    public static final RegisteredBlock CACTUS_BUTTON = Buttons.regWoodButton("cactus", Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_BUTTON = Buttons.regWoodButton("palo_verde", Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_BUTTON = Buttons.regWoodButton("mesquite", Building.MESQUITE_PLANKS);
    public static final RegisteredBlock POLISHED_ASPHALT_BUTTON = Buttons.regStoneButton("polished_asphalt", Building.POLISHED_ASPHALT);
    public static final RegisteredBlock BLACKENED_OAK_BUTTON = (RegisteredBlock)Buttons.regWoodButton("blackened_oak", DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_BUTTON = (RegisteredBlock)Buttons.regWoodButton("blackened_spruce", DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_BUTTON = ((RegisteredBlock)Buttons.regButton("glowing_oak", 30, PMBlockSetTypes.VARIANT_WOOD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60953_(s -> 7), (ItemLike)DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_13092_);
    public static final RegisteredBlock GLOWING_CACTUS_BUTTON = ((RegisteredBlock)Buttons.regButton("glowing_cactus", 30, PMBlockSetTypes.VARIANT_WOOD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60953_(s -> 7), (ItemLike)DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_13092_);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_BUTTON = Buttons.regGlowingObsidianButton(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regWoodButton(String name, ItemLike planks) {
        return Buttons.regButton(name, 30, BlockType.WOOD, planks);
    }

    private static RegisteredBlock regMetalButton(String name, int ticks, ItemLike craftItem) {
        return Buttons.regButton(name, ticks, BlockType.METAL, craftItem);
    }

    private static RegisteredBlock regStoneButton(String name, ItemLike stone) {
        return Buttons.regStoneButton(name, PMBlockSetTypes.VARIANT_STONE, stone);
    }

    private static RegisteredBlock regStoneButton(String name, BlockSetType stoneType, ItemLike stone) {
        return Buttons.regButton(name, 20, stoneType, BlockType.STONE, stone).tag((TagKey<Block>)BlockTags.f_279568_);
    }

    private static RegisteredBlock regGlowingObsidianButton(GlowingObsidianColor color) {
        return (RegisteredBlock)Buttons.regButton(color.getName() + "_glowing_obsidian", "paradisemod:block/glowing_obsidian/" + color.getName(), 20, PMBlockSetTypes.VARIANT_STONE, BlockType.STRONG_STONE.getProperties().m_60953_(s -> 7), Building.GLOWING_OBSIDIAN.get((Object)color)).tag((TagKey<Block>)BlockTags.f_13093_).tags(BlockType.STRONG_STONE.tags()).localizedName(color.localizedName(false) + " Glowing Obsidian Button", "Bot\u00f3n de obsidiana brillante " + color.localizedName(true));
    }

    private static RegisteredBlock regButton(String name, int ticks, BlockType type, ItemLike craftItem) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        BlockSetType blockSetType = PMBlockSetTypes.VARIANT_STONE;
        switch (type) {
            case WOOD: {
                blockSetType = PMBlockSetTypes.VARIANT_WOOD;
                tags.add(BlockTags.f_13092_);
                break;
            }
            case METAL: {
                blockSetType = PMBlockSetTypes.METAL;
                break;
            }
            case WEAK_METAL: {
                blockSetType = PMBlockSetTypes.WEAK_METAL;
                break;
            }
            case STONE: 
            case ENHANCED_STONE: 
            case STRONG_STONE: {
                tags.add(BlockTags.f_279568_);
                break;
            }
        }
        if (type != BlockType.WOOD && type != BlockType.STONE && type != BlockType.ENHANCED_STONE && type != BlockType.STRONG_STONE) {
            tags.add((TagKey<Block>)BlockTags.f_13093_);
            tags.addAll(type.tags());
        }
        return Buttons.regButton(name, ticks, blockSetType, type.getProperties(), craftItem).tags(tags);
    }

    private static RegisteredBlock regButton(String name, int ticks, BlockSetType blockType, BlockBehaviour.Properties properties, ItemLike craftItem) {
        return Buttons.regButton(name, Buttons.texturePath(name), ticks, blockType, properties, craftItem);
    }

    private static RegisteredBlock regButton(String name, int ticks, BlockSetType blockSetType, BlockType blockType, ItemLike craftItem) {
        return Buttons.regButton(name, Buttons.texturePath(name), ticks, blockSetType, blockType.getProperties(), craftItem);
    }

    private static RegisteredBlock regButton(String name, String texturePath, int ticks, BlockSetType blockType, BlockBehaviour.Properties properties, ItemLike craftItem) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_button", () -> new ButtonBlock(properties.m_60910_(), blockType, ticks, blockType == PMBlockSetTypes.VARIANT_WOOD)).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.REDSTONE, (ItemLike)item, craftItem))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).itemModel((block, generator) -> {
            if (name != "grass") {
                generator.buttonInventory(name + "_button", new ResourceLocation(texturePath));
            }
        }).blockStateGenerator((block, generator) -> Buttons.genButtonBlockState(name, texturePath, block, generator)).localizedName(Utils.localizedMaterialName(name, false) + " Button", "Bot\u00f3n de " + Utils.localizedMaterialName(name, true));
    }

    private static void genButtonBlockState(String name, String texturePath, RegisteredBlock buttonBlock, BlockStateGenerator generator) {
        if (name == "grass") {
            generator.buttonBlock((ButtonBlock)buttonBlock.get(), (ModelFile)generator.existingModel("button/grass"), (ModelFile)generator.existingModel("button/grass_pressed"));
        } else {
            BlockModelProvider modelBuilder = generator.models();
            BlockModelBuilder button = (BlockModelBuilder)modelBuilder.button("block/button/" + name, new ResourceLocation(texturePath));
            BlockModelBuilder buttonPressed = (BlockModelBuilder)modelBuilder.buttonPressed("block/button/" + name + "_pressed", new ResourceLocation(texturePath));
            if (name == "glass") {
                button = (BlockModelBuilder)button.renderType("cutout");
                buttonPressed = (BlockModelBuilder)buttonPressed.renderType("cutout");
            } else if (name.contains("glass")) {
                button = (BlockModelBuilder)button.renderType("translucent");
                buttonPressed = (BlockModelBuilder)buttonPressed.renderType("translucent");
            }
            generator.buttonBlock((ButtonBlock)buttonBlock.get(), (ModelFile)button, (ModelFile)buttonPressed);
        }
    }

    public static String texturePath(String name) {
        if (name == "blackened_sandstone") {
            return "paradisemod:block/blackened_sandstone_top";
        }
        if (name.endsWith("sandstone")) {
            return "minecraft:block/" + name + "_top";
        }
        return switch (name) {
            case "grass" -> "minecraft:block/grass_block_top";
            case "dripstone", "diamond", "emerald" -> "minecraft:block/" + name + "_block";
            case "darkstone", "polished_dripstone", "polished_calcite", "polished_tuff", "polished_end_stone", "polished_darkstone", "polished_asphalt" -> "paradisemod:block/" + name;
            case "ruby", "rusted_iron", "silver", "cactus", "glowing_cactus" -> "paradisemod:block/" + name + "_block";
            case "palo_verde", "mesquite", "blackened_oak", "blackened_spruce", "glowing_oak" -> "paradisemod:block/" + name + "_planks";
            case "basalt" -> "minecraft:block/basalt_side";
            case "icicle" -> "minecraft:block/ice";
            case "blue_icicle" -> "minecraft:block/blue_ice";
            default -> "minecraft:block/" + name;
        };
    }
}

