/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;

public class Lamps {
    public static EnumMap<DyeColor, RegisteredBlock> REDSTONE_LAMPS = new EnumMap(DyeColor.class);
    public static final RegisteredBlock BLACK_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.BLACK);
    public static final RegisteredBlock BLUE_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.BLUE);
    public static final RegisteredBlock BROWN_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.BROWN);
    public static final RegisteredBlock CYAN_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.CYAN);
    public static final RegisteredBlock GRAY_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.GRAY);
    public static final RegisteredBlock GREEN_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.GREEN);
    public static final RegisteredBlock LIGHT_BLUE_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.LIGHT_BLUE);
    public static final RegisteredBlock LIGHT_GRAY_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.LIGHT_GRAY);
    public static final RegisteredBlock LIME_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.LIME);
    public static final RegisteredBlock MAGENTA_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.MAGENTA);
    public static final RegisteredBlock ORANGE_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.ORANGE);
    public static final RegisteredBlock PINK_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.PINK);
    public static final RegisteredBlock PURPLE_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.PURPLE);
    public static final RegisteredBlock RED_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.RED);
    public static final RegisteredBlock WHITE_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.WHITE);
    public static final RegisteredBlock YELLOW_REDSTONE_LAMP = Lamps.regColoredRedstoneLamp(DyeColor.YELLOW);
    public static final RegisteredBlock GOLD_REDSTONE_LAMP = Lamps.goldRedstoneLamp();
    public static final RegisteredBlock IRIDESCENT_REDSTONE_LAMP = Lamps.iridescentRedstoneLamp();

    public static void init() {
    }

    private static RegisteredBlock regColoredRedstoneLamp(DyeColor color) {
        RegisteredBlock lamp = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(color.name().toLowerCase() + "_redstone_lamp", () -> new RedstoneLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50261_))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 8).m_126130_("lll").m_126130_("ldl").m_126130_("lll").m_126127_(Character.valueOf('d'), (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color)).m_126127_(Character.valueOf('l'), (ItemLike)Blocks.f_50261_))).tabs(CreativeModeTabs.f_257028_, CreativeModeTabs.f_256725_)).tag(PMTags.Blocks.BUOY_LIGHTS).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "colored_redstone_lamp")).blockStateGenerator((block, generator) -> {
            ModelFile.ExistingModelFile model = generator.existingModel("colored_redstone_lamp");
            ModelFile.ExistingModelFile modelOn = generator.existingModel("colored_redstone_lamp_on");
            generator.getVariantBuilder(block.get()).forAllStates(state -> {
                boolean isOn = (Boolean)state.m_61143_((Property)RedstoneLampBlock.f_55654_);
                if (isOn) {
                    return generator.buildVariantModel((ModelFile)modelOn);
                }
                return generator.buildVariantModel((ModelFile)model);
            });
        }).localizedName(PMTranslations.englishColor(color) + " Redstone Lamp", "L\u00e1mpara " + PMTranslations.spanishColor(color, true));
        REDSTONE_LAMPS.put(color, lamp);
        return lamp;
    }

    private static RegisteredBlock goldRedstoneLamp() {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("gold_redstone_lamp", () -> new RedstoneLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50261_)){

            public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
                if (entity instanceof LivingEntity) {
                    LivingEntity creature = (LivingEntity)entity;
                    creature.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100));
                }
            }

            public void m_5871_(ItemStack pStack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
                tooltip.add((Component)Component.m_237115_((String)"paradisemod.no_more_school").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }

            public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
                super.m_214162_(state, world, pos, rand);
                if (rand.m_188503_(10) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123770_, (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 0.0);
                }
            }
        }).tabs(CreativeModeTabs.f_257028_, CreativeModeTabs.f_256725_)).tag(PMTags.Blocks.BUOY_LIGHTS).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "colored_redstone_lamp")).blockStateGenerator((block, generator) -> {
            ModelFile.ExistingModelFile model = generator.existingModel("colored_redstone_lamp");
            ModelFile.ExistingModelFile modelOn = generator.existingModel("colored_redstone_lamp_on");
            generator.getVariantBuilder(block.get()).forAllStates(state -> {
                boolean isOn = (Boolean)state.m_61143_((Property)RedstoneLampBlock.f_55654_);
                if (isOn) {
                    return generator.buildVariantModel((ModelFile)modelOn);
                }
                return generator.buildVariantModel((ModelFile)model);
            });
        }).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("GGG").m_126130_("GlG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50074_).m_126127_(Character.valueOf('l'), (ItemLike)Blocks.f_50261_))).localizedName("Golden Redstone Lamp", "L\u00e1mpara dorada");
    }

    private static RegisteredBlock iridescentRedstoneLamp() {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("iridescent_redstone_lamp", () -> new RedstoneLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50261_)){

            public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
                world.m_7260_(pos, state, state, 8);
            }
        }).tabs(CreativeModeTabs.f_257028_, CreativeModeTabs.f_256725_)).tag(PMTags.Blocks.BUOY_LIGHTS).itemModel((block, generator) -> generator.parentBlockItem(block.get(), "colored_redstone_lamp")).blockStateGenerator((block, generator) -> {
            ModelFile.ExistingModelFile model = generator.existingModel("colored_redstone_lamp");
            ModelFile.ExistingModelFile modelOn = generator.existingModel("colored_redstone_lamp_on");
            generator.getVariantBuilder(block.get()).forAllStates(state -> {
                boolean isOn = (Boolean)state.m_61143_((Property)RedstoneLampBlock.f_55654_);
                if (isOn) {
                    return generator.buildVariantModel((ModelFile)modelOn);
                }
                return generator.buildVariantModel((ModelFile)model);
            });
        }).recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.REDSTONE, (ItemLike)item, new ItemLike[]{Items.f_42497_, Items.f_42536_, Items.f_42539_, Items.f_42496_, Items.f_42492_, Items.f_42494_, Items.f_42493_}))).localizedName("Iridescent Redstone Lamp", "L\u00e1mpara iridescente");
    }
}

