/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone;

import java.util.ArrayList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.PMBlockSetTypes;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.building.Building;
import net.paradisemod.building.GlowingObsidianColor;
import net.paradisemod.misc.Misc;
import net.paradisemod.redstone.Buttons;
import net.paradisemod.redstone.blocks.CustomPressurePlate;
import net.paradisemod.world.DeepDarkBlocks;

public class Plates {
    public static final RegisteredBlock ANDESITE_PRESSURE_PLATE = Plates.regStonePlate("andesite", (ItemLike)Blocks.f_50334_);
    public static final RegisteredBlock DIORITE_PRESSURE_PLATE = Plates.regStonePlate("diorite", (ItemLike)Blocks.f_50228_);
    public static final RegisteredBlock GRANITE_PRESSURE_PLATE = Plates.regStonePlate("granite", (ItemLike)Blocks.f_50122_);
    public static final RegisteredBlock DRIPSTONE_PRESSURE_PLATE = Plates.regStonePlate("dripstone", PMBlockSetTypes.DRIPSTONE, (ItemLike)Blocks.f_152537_);
    public static final RegisteredBlock CALCITE_PRESSURE_PLATE = Plates.regStonePlate("calcite", PMBlockSetTypes.CALCITE, (ItemLike)Blocks.f_152497_);
    public static final RegisteredBlock TUFF_PRESSURE_PLATE = Plates.regStonePlate("tuff", PMBlockSetTypes.TUFF, (ItemLike)Blocks.f_152496_);
    public static final RegisteredBlock COBBLESTONE_PRESSURE_PLATE = Plates.regStonePlate("cobblestone", (ItemLike)Blocks.f_50652_);
    public static final RegisteredBlock DEEPSLATE_PRESSURE_PLATE = Plates.regStonePlate("deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152550_);
    public static final RegisteredBlock COBBLED_DEEPSLATE_PRESSURE_PLATE = Plates.regStonePlate("cobbled_deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152551_);
    public static final RegisteredBlock POLISHED_DEEPSLATE_PRESSURE_PLATE = Plates.regStonePlate("polished_deepslate", PMBlockSetTypes.DEEPSLATE, (ItemLike)Blocks.f_152555_);
    public static final RegisteredBlock MOSSY_COBBLESTONE_PRESSURE_PLATE = Plates.regStonePlate("mossy_cobblestone", (ItemLike)Blocks.f_50079_);
    public static final RegisteredBlock END_STONE_PRESSURE_PLATE = Plates.regStonePlate("end_stone", (ItemLike)Blocks.f_50259_);
    public static final RegisteredBlock DARKSTONE_PRESSURE_PLATE = (RegisteredBlock)Plates.regStonePlate("darkstone", DeepDarkBlocks.DARKSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKSTONE_PRESSURE_PLATE = Plates.regStonePlate("blackstone", (ItemLike)Blocks.f_50730_);
    public static final RegisteredBlock POLISHED_ANDESITE_PRESSURE_PLATE = Plates.regStonePlate("polished_andesite", (ItemLike)Blocks.f_50387_);
    public static final RegisteredBlock POLISHED_DIORITE_PRESSURE_PLATE = Plates.regStonePlate("polished_diorite", (ItemLike)Blocks.f_50281_);
    public static final RegisteredBlock POLISHED_GRANITE_PRESSURE_PLATE = Plates.regStonePlate("polished_granite", (ItemLike)Blocks.f_50175_);
    public static final RegisteredBlock POLISHED_DRIPSTONE_PRESSURE_PLATE = Plates.regStonePlate("polished_dripstone", PMBlockSetTypes.DRIPSTONE, Building.POLISHED_DRIPSTONE);
    public static final RegisteredBlock POLISHED_CALCITE_PRESSURE_PLATE = Plates.regStonePlate("polished_calcite", PMBlockSetTypes.CALCITE, Building.POLISHED_CALCITE);
    public static final RegisteredBlock POLISHED_TUFF_PRESSURE_PLATE = Plates.regStonePlate("polished_tuff", PMBlockSetTypes.TUFF, Building.POLISHED_TUFF);
    public static final RegisteredBlock SMOOTH_STONE_PRESSURE_PLATE = Plates.regStonePlate("smooth_stone", (ItemLike)Blocks.f_50470_);
    public static final RegisteredBlock POLISHED_END_STONE_PRESSURE_PLATE = Plates.regStonePlate("polished_end_stone", Building.POLISHED_END_STONE);
    public static final RegisteredBlock POLISHED_DARKSTONE_PRESSURE_PLATE = Plates.regStonePlate("polished_darkstone", DeepDarkBlocks.POLISHED_DARKSTONE);
    public static final RegisteredBlock SANDSTONE_PRESSURE_PLATE = Plates.regStonePlate("sandstone", (ItemLike)Blocks.f_50062_);
    public static final RegisteredBlock RED_SANDSTONE_PRESSURE_PLATE = Plates.regStonePlate("red_sandstone", (ItemLike)Blocks.f_50394_);
    public static final RegisteredBlock BLACKENED_SANDSTONE_PRESSURE_PLATE = (RegisteredBlock)Plates.regStonePlate("blackened_sandstone", DeepDarkBlocks.BLACKENED_SANDSTONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BEDROCK_PRESSURE_PLATE = Plates.regPlate("bedrock", BlockType.INDESTRUCTIBLE, CustomPressurePlate.Sensitivity.PLAYERS, 20, (ItemLike)Blocks.f_50752_);
    public static final RegisteredBlock DIRT_PRESSURE_PLATE = Plates.regPlate("dirt", BlockType.SOIL, CustomPressurePlate.Sensitivity.EVERYTHING, 20, (ItemLike)Blocks.f_50493_);
    public static final RegisteredBlock GRASS_PRESSURE_PLATE = Plates.regPlate("grass", BlockType.SOIL, PMBlockSetTypes.GRASS, CustomPressurePlate.Sensitivity.EVERYTHING, 20, (ItemLike)Blocks.f_50440_).tags(BlockTags.f_13099_, BlockTags.f_144283_);
    public static final RegisteredBlock DIAMOND_PRESSURE_PLATE = Plates.regMetalPlate("diamond", 14, (ItemLike)Items.f_42415_);
    public static final RegisteredBlock EMERALD_PRESSURE_PLATE = Plates.regMetalPlate("emerald", 10, (ItemLike)Items.f_42616_);
    public static final RegisteredBlock RUBY_PRESSURE_PLATE = Plates.regMetalPlate("ruby", 2, Misc.RUBY);
    public static final RegisteredBlock RUSTED_IRON_PRESSURE_PLATE = Plates.regMetalPlate("rusted_iron", 2, Misc.RUSTED_IRON_INGOT);
    public static final RegisteredBlock SILVER_PRESSURE_PLATE = Plates.regMetalPlate("silver", 20, Misc.SILVER_INGOT);
    public static final RegisteredBlock GLASS_PRESSURE_PLATE = Plates.regPlate("glass", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), PMBlockSetTypes.GLASS, CustomPressurePlate.Sensitivity.EVERYTHING, 5, (ItemLike)Blocks.f_50058_).tag((TagKey<Block>)BlockTags.f_13099_);
    public static final RegisteredBlock CACTUS_PRESSURE_PLATE = Plates.regWoodPlate("cactus", Building.CACTUS_BLOCK);
    public static final RegisteredBlock PALO_VERDE_PRESSURE_PLATE = Plates.regWoodPlate("palo_verde", Building.PALO_VERDE_PLANKS);
    public static final RegisteredBlock MESQUITE_PRESSURE_PLATE = Plates.regWoodPlate("mesquite", Building.MESQUITE_PLANKS);
    public static final RegisteredBlock POLISHED_ASPHALT_PRESSURE_PLATE = Plates.regStonePlate("polished_asphalt", Building.POLISHED_ASPHALT);
    public static final RegisteredBlock BLACKENED_OAK_PRESSURE_PLATE = (RegisteredBlock)Plates.regWoodPlate("blackened_oak", DeepDarkBlocks.BLACKENED_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_PRESSURE_PLATE = (RegisteredBlock)Plates.regWoodPlate("blackened_spruce", DeepDarkBlocks.BLACKENED_SPRUCE_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_PRESSURE_PLATE = ((RegisteredBlock)Plates.regPlate("glowing_oak", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60953_(state -> 7), PMBlockSetTypes.VARIANT_WOOD, CustomPressurePlate.Sensitivity.EVERYTHING, 30, (ItemLike)DeepDarkBlocks.GLOWING_OAK_PLANKS).tab(DeepDarkBlocks.DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_13100_);
    public static final RegisteredBlock GLOWING_CACTUS_PRESSURE_PLATE = ((RegisteredBlock)Plates.regPlate("glowing_cactus", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60953_(state -> 7), PMBlockSetTypes.VARIANT_WOOD, CustomPressurePlate.Sensitivity.EVERYTHING, 30, (ItemLike)DeepDarkBlocks.GLOWING_CACTUS_BLOCK).tab(DeepDarkBlocks.DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_13100_);
    public static final RegisteredBlock BLACK_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.BLACK);
    public static final RegisteredBlock BLUE_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.BLUE);
    public static final RegisteredBlock GREEN_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.GREEN);
    public static final RegisteredBlock INDIGO_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.INDIGO);
    public static final RegisteredBlock ORANGE_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.ORANGE);
    public static final RegisteredBlock RED_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.RED);
    public static final RegisteredBlock VIOLET_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.VIOLET);
    public static final RegisteredBlock WHITE_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.WHITE);
    public static final RegisteredBlock YELLOW_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.YELLOW);
    public static final RegisteredBlock GOLD_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.GOLD);
    public static final RegisteredBlock SILVER_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.SILVER);
    public static final RegisteredBlock IRON_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.IRON);
    public static final RegisteredBlock COPPER_GLOWING_OBSIDIAN_PRESSURE_PLATE = Plates.regGlowingObsidianPlate(GlowingObsidianColor.COPPER);

    public static void init() {
    }

    private static RegisteredBlock regWoodPlate(String name, ItemLike planks) {
        return Plates.regPlate(name, BlockType.WOOD, CustomPressurePlate.Sensitivity.EVERYTHING, 30, planks);
    }

    private static RegisteredBlock regMetalPlate(String name, int ticks, ItemLike craftItem) {
        return Plates.regPlate(name, BlockType.METAL, CustomPressurePlate.Sensitivity.MOBS, ticks, craftItem);
    }

    private static RegisteredBlock regStonePlate(String name, ItemLike stone) {
        return Plates.regStonePlate(name, PMBlockSetTypes.VARIANT_STONE, stone);
    }

    private static RegisteredBlock regStonePlate(String name, BlockSetType stoneType, ItemLike stone) {
        return Plates.regPlate(name, BlockType.STONE.getProperties(), stoneType, CustomPressurePlate.Sensitivity.MOBS, 20, stone).tags(BlockTags.f_13101_, BlockTags.f_144282_);
    }

    private static RegisteredBlock regGlowingObsidianPlate(GlowingObsidianColor color) {
        return (RegisteredBlock)Plates.regPlate(color.getName() + "_glowing_obsidian", "paradisemod:block/glowing_obsidian/" + color.getName(), BlockType.STRONG_STONE.getProperties().m_60953_(state -> 7), PMBlockSetTypes.VARIANT_STONE, CustomPressurePlate.Sensitivity.PLAYERS, 20, Building.GLOWING_OBSIDIAN.get((Object)color)).localizedName(color.localizedName(false) + " Glowing Obsidian Pressure Plate", "Placa de presi\u00f3n de obsidiana brillante " + color.localizedName(true));
    }

    private static RegisteredBlock regPlate(String name, BlockType type, CustomPressurePlate.Sensitivity sensitivity, int ticks, ItemLike craftItem) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        BlockSetType blockSetType = PMBlockSetTypes.VARIANT_STONE;
        switch (type) {
            case WOOD: {
                blockSetType = PMBlockSetTypes.VARIANT_WOOD;
                tags.add(BlockTags.f_13100_);
                break;
            }
            case METAL: {
                blockSetType = PMBlockSetTypes.METAL;
                break;
            }
            case WEAK_METAL: {
                blockSetType = PMBlockSetTypes.WEAK_METAL;
                break;
            }
            case SOIL: {
                blockSetType = PMBlockSetTypes.SOIL;
                break;
            }
        }
        if (type != BlockType.WOOD) {
            tags.add(BlockTags.f_13099_);
            tags.addAll(type.tags());
        }
        return Plates.regPlate(name, type.getProperties().m_60910_(), blockSetType, sensitivity, ticks, craftItem).tags(tags);
    }

    private static RegisteredBlock regPlate(String name, BlockType blockType, BlockSetType blockSetType, CustomPressurePlate.Sensitivity sensitivity, int ticks, ItemLike craftItem) {
        return Plates.regPlate(name, blockType.getProperties(), blockSetType, sensitivity, ticks, craftItem);
    }

    private static RegisteredBlock regPlate(String name, BlockBehaviour.Properties props, BlockSetType blockType, CustomPressurePlate.Sensitivity sensitivity, int ticks, ItemLike craftItem) {
        return Plates.regPlate(name, Buttons.texturePath(name), props.m_60910_(), blockType, sensitivity, ticks, craftItem);
    }

    private static RegisteredBlock regPlate(String name, String texturePath, BlockBehaviour.Properties props, BlockSetType blockType, CustomPressurePlate.Sensitivity sensitivity, int ticks, ItemLike craftItem) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_pressure_plate", () -> new CustomPressurePlate(sensitivity, blockType, props.m_60910_(), ticks)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).blockStateGenerator((block, generator) -> Plates.genPlateBlockState(name, texturePath, block, generator)).itemModel((block, generator) -> generator.withExistingParent(name + "_pressure_plate", "paradisemod:block/plate/" + name)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("II").m_126127_(Character.valueOf('I'), craftItem))).localizedName(Utils.localizedMaterialName(name, false) + " Pressure Plate", "Placa de presi\u00f3n de " + Utils.localizedMaterialName(name, true));
    }

    private static void genPlateBlockState(String name, String texturePath, RegisteredBlock plateBlock, BlockStateGenerator generator) {
        if (name == "grass") {
            generator.pressurePlateBlock((CustomPressurePlate)plateBlock.get(), (ModelFile)generator.existingModel("plate/grass"), (ModelFile)generator.existingModel("plate/grass_down"));
        } else {
            BlockModelProvider modelBuilder = generator.models();
            BlockModelBuilder plate = (BlockModelBuilder)modelBuilder.pressurePlate("block/plate/" + name, new ResourceLocation(texturePath));
            BlockModelBuilder plateDown = (BlockModelBuilder)modelBuilder.pressurePlateDown("block/plate/" + name + "_down", new ResourceLocation(texturePath));
            if (name == "glass") {
                plate = (BlockModelBuilder)plate.renderType("cutout");
                plateDown = (BlockModelBuilder)plateDown.renderType("cutout");
            } else if (name.contains("glass")) {
                plate = (BlockModelBuilder)plate.renderType("translucent");
                plateDown = (BlockModelBuilder)plateDown.renderType("translucent");
            }
            generator.pressurePlateBlock((CustomPressurePlate)plateBlock.get(), (ModelFile)plate, (ModelFile)plateDown);
        }
    }
}

