/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.Events;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.redstone.Buttons;
import net.paradisemod.redstone.Lamps;
import net.paradisemod.redstone.Plates;
import net.paradisemod.redstone.blocks.Antenna;
import net.paradisemod.redstone.blocks.EntityObserver;
import net.paradisemod.redstone.blocks.PulseExtenderRepeater;
import net.paradisemod.redstone.blocks.RedstoneWire;
import net.paradisemod.redstone.blocks.Spike;
import net.paradisemod.redstone.blocks.Transmitter;
import net.paradisemod.redstone.blocks.WireRepeater;
import net.paradisemod.redstone.blocks.superpiston.MovingSuperPiston;
import net.paradisemod.redstone.blocks.superpiston.SuperPiston;
import net.paradisemod.redstone.blocks.superpiston.SuperPistonHead;
import net.paradisemod.redstone.tile.SuperPistonEntity;
import net.paradisemod.redstone.tile.SuperPistonRenderer;

public class Redstone {
    public static final RegisteredBlock SPIKE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("spike", Spike::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("I").m_126130_("I").m_126130_("N").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('N'), Tags.Items.INGOTS_NETHERITE))).localizedName("Spike", "Pincho");
    public static final RegisteredBlock ENTITY_OBSERVER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("entity_observer", EntityObserver::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).tag((TagKey<Block>)BlockTags.f_144282_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("CCC").m_126130_("RDQ").m_126130_("CCC").m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50652_).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50320_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_))).localizedName("Entity Observer", "Observador de entidades");
    public static final RegisteredBlock MOSSY_COBBLESTONE_LEVER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("mossy_cobblestone_lever", () -> new LeverBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50164_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).itemModel((block, generator) -> generator.flatBlockItem((RegisteredBlock)block)).blockStateGenerator((block, generator) -> {
        ModelFile.ExistingModelFile lever = generator.existingModel("mossy_cobblestone_lever");
        ModelFile.ExistingModelFile leverOn = generator.existingModel("mossy_cobblestone_lever_on");
        generator.getVariantBuilder(block.get()).forAllStates(state -> {
            AttachFace face = (AttachFace)state.m_61143_((Property)LeverBlock.f_53179_);
            Direction facing = (Direction)state.m_61143_((Property)LeverBlock.f_54117_);
            boolean powered = (Boolean)state.m_61143_((Property)LeverBlock.f_54622_);
            int xRot = 0;
            int yRot = 0;
            block0 : switch (face) {
                case FLOOR: {
                    yRot = BlockStateGenerator.calcYRot(facing);
                    break;
                }
                case CEILING: {
                    xRot = 180;
                    switch (facing) {
                        case EAST: {
                            yRot = 270;
                            break;
                        }
                        case NORTH: {
                            yRot = 180;
                            break;
                        }
                        case WEST: {
                            yRot = 90;
                        }
                    }
                    break;
                }
                case WALL: {
                    xRot = 90;
                    switch (facing) {
                        case EAST: {
                            yRot = 90;
                            break block0;
                        }
                        case SOUTH: {
                            yRot = 180;
                            break block0;
                        }
                        case WEST: {
                            yRot = 270;
                        }
                    }
                }
            }
            return generator.buildVariantModel((ModelFile)(powered ? leverOn : lever), xRot, yRot);
        });
    }).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("s").m_126130_("M").m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('M'), (ItemLike)Blocks.f_50079_))).localizedName("Mossy Cobblestone Lever", "Palanca de piedra labrada musgosa");
    public static final RegisteredBlock PULSE_EXTENDER_REPEATER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("pulse_extender_repeater", PulseExtenderRepeater::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_(" X ").m_126130_("#Q#").m_126130_("III").m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50174_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_))).localizedName("Pulse Extender Repeater", "Repetidor de extensor de pulso");
    public static final RegisteredBlock REDSTONE_WIRE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("redstone_wire", RedstoneWire::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 16).m_126130_("GRG").m_126130_("GRG").m_126130_("GRG").m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_))).localizedName("Redstone Wire", "Alambre de piedra roja");
    public static final RegisteredBlock WIRE_REPEATER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("wire_repeater", WireRepeater::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("TWT").m_126130_("SSS").m_126127_(Character.valueOf('W'), (ItemLike)REDSTONE_WIRE).m_126127_(Character.valueOf('T'), (ItemLike)Blocks.f_50174_).m_206416_(Character.valueOf('S'), Tags.Items.STONE))).localizedName("Redstone Wire Repeater", "Repetidor de alambre de piedra roja");
    public static final RegisteredBlock SUPER_PISTON = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("super_piston", () -> new SuperPiston(false)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("III").m_126130_("ODO").m_126130_("ORO").m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('O'), (ItemLike)Blocks.f_50080_))).localizedName("Super Piston", "Superpist\u00f3n");
    public static final RegisteredBlock STICKY_SUPER_PISTON = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("sticky_super_piston", () -> new SuperPiston(true)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_("S").m_126130_("P").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42518_).m_126127_(Character.valueOf('P'), (ItemLike)SUPER_PISTON))).localizedName("Sticky Super Piston", "Superpist\u00f3n pegajoso");
    public static final RegisteredBlock SUPER_PISTON_HEAD = PMRegistries.regBlock("super_piston_head", SuperPistonHead::new);
    public static final RegisteredBlock MOVING_SUPER_PISTON = PMRegistries.regBlock("moving_super_piston", MovingSuperPiston::new);
    public static final RegistryObject<BlockEntityType<SuperPistonEntity>> SUPER_PISTON_TILE = PMRegistries.createTile("super_piston_tile", SuperPistonEntity::new, MOVING_SUPER_PISTON);
    public static final ArrayList<RegisteredBlock> TRANSMITTERS = new ArrayList();
    public static final ArrayList<RegisteredBlock> ANTENNAS = new ArrayList();

    public static void init(IEventBus eventbus) {
        for (DyeColor color : DyeColor.values()) {
            RegisteredBlock transmitter = ((RegisteredBlock)PMRegistries.regBlockItem(color.m_41065_() + "_transmitter", () -> new Transmitter(color)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).itemTag(PMTags.Items.TRANSMITTERS);
            if (color == DyeColor.RED) {
                transmitter = (RegisteredBlock)transmitter.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_(" X ").m_126130_("#G#").m_126130_("III").m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50174_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD));
            }
            TRANSMITTERS.add((RegisteredBlock)((RegisteredBlock)transmitter.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 8).m_126130_("TTT").m_126130_("TDT").m_126130_("TTT").m_206416_(Character.valueOf('T'), PMTags.Items.TRANSMITTERS).m_126127_(Character.valueOf('D'), (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color)))).localizedName(PMTranslations.englishColor(color) + " Transmitter", "Transmisor " + PMTranslations.spanishColor(color, false)));
        }
        for (DyeColor color : DyeColor.values()) {
            RegisteredBlock antenna = ((RegisteredBlock)PMRegistries.regBlockItem(color.m_41065_() + "_antenna", () -> new Antenna(color)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).itemTag(PMTags.Items.ANTENNAS);
            if (color == DyeColor.RED) {
                antenna = (RegisteredBlock)antenna.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item).m_126130_(" r ").m_126130_(" RN").m_126130_("SSS").m_126127_(Character.valueOf('r'), (ItemLike)Blocks.f_50174_).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('N'), Tags.Items.INGOTS_NETHERITE));
            }
            ANTENNAS.add((RegisteredBlock)((RegisteredBlock)antenna.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)item, 8).m_126130_("AAA").m_126130_("ADA").m_126130_("AAA").m_206416_(Character.valueOf('A'), PMTags.Items.ANTENNAS).m_126127_(Character.valueOf('D'), (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color)))).localizedName(PMTranslations.englishColor(color) + " Antenna", "Antena " + PMTranslations.spanishColor(color, true)));
        }
        Lamps.init();
        Buttons.init();
        Plates.init();
        for (Map.Entry entry : Lamps.REDSTONE_LAMPS.entrySet()) {
            DyeColor dyeColor = (DyeColor)entry.getKey();
            RegisteredBlock lamp = (RegisteredBlock)entry.getValue();
            Events.registerBasicColoredBlocks(dyeColor.m_41070_(), lamp);
        }
        Events.registerGrassColoredBlocks(Buttons.GRASS_BUTTON, Plates.GRASS_PRESSURE_PLATE);
        Events.registerBasicColoredBlocks(-2053602, Lamps.GOLD_REDSTONE_LAMP);
        Events.registerRainbowBlocks(Lamps.IRIDESCENT_REDSTONE_LAMP);
        ParadiseMod.LOG.info("Loaded Redstone module");
    }

    public static void initClient() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SUPER_PISTON_TILE.get()), SuperPistonRenderer::new);
    }
}

