/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.redstone.blocks.Transmitter;

public class Antenna
extends Block
implements ModeledBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape SHAPE1 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape SHAPE2 = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private static final VoxelShape SHAPE3 = Block.m_49796_((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0);
    private final DyeColor color;

    public Antenna(DyeColor color) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50146_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.color = color;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        boolean foundPowered = false;
        for (int i = -16; i <= 16; ++i) {
            for (int j = -16; j <= 16; ++j) {
                for (int k = -16; k <= 16; ++k) {
                    BlockPos newPos = pos.m_7918_(i, j, k);
                    BlockState testState = world.m_8055_(newPos);
                    Block block = testState.m_60734_();
                    if (!(block instanceof Transmitter)) continue;
                    Transmitter transmitter = (Transmitter)block;
                    if (transmitter.color != this.color || ((Boolean)testState.m_61143_((Property)Transmitter.RECEIVER)).booleanValue() || !((Boolean)testState.m_61143_((Property)Transmitter.POWERED)).booleanValue()) continue;
                    foundPowered = true;
                    break;
                }
                if (foundPowered) break;
            }
            if (foundPowered) break;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(foundPowered)), 3);
        for (Direction direction : Direction.values()) {
            world.m_46672_(pos.m_121945_(direction), (Block)this);
        }
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public int m_6378_(BlockState state, BlockGetter read, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter reader, BlockPos pos, Direction side) {
        return this.m_6378_(state, reader, pos, side);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + (rand.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            float f = -0.3125f;
            float d3 = f * (float)Direction.UP.m_122429_();
            float d4 = f * (float)Direction.UP.m_122431_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + (double)d3, d1, d2 + (double)d4, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83124_((VoxelShape)SHAPE1, (VoxelShape[])new VoxelShape[]{SHAPE2, SHAPE3});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return;
        }
        Antenna.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        return !blockBelow.m_60795_();
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.parentBlockItem(this, "antenna/" + this.color.m_41065_());
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder antenna = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/antenna/" + this.color.m_41065_(), generator.modLoc("block/antenna/parent"))).texture("texture", "block/antenna/" + this.color.m_41065_());
        BlockModelBuilder antennaOn = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/antenna/" + this.color.m_41065_() + "_on", generator.modLoc("block/antenna/parent_on"))).texture("texture", "block/antenna/" + this.color.m_41065_());
        generator.getVariantBuilder(this).forAllStates(state -> {
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                return generator.buildVariantModel((ModelFile)antennaOn);
            }
            return generator.buildVariantModel((ModelFile)antenna);
        });
    }
}

