/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class CustomPressurePlate
extends PressurePlateBlock {
    private final int ticks;
    private final Sensitivity sensitivity;
    private final BlockSetType blockType;

    public CustomPressurePlate(Sensitivity sensitivity, BlockSetType blockType, BlockBehaviour.Properties properties, int plateTicks) {
        super(PressurePlateBlock.Sensitivity.EVERYTHING, properties.m_280606_(), blockType);
        this.sensitivity = sensitivity;
        this.ticks = plateTicks;
        this.blockType = blockType;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int signal = this.m_6016_(state);
        if (signal > 0) {
            this.m_152143_(null, (Level)world, pos, state, signal);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        int signal;
        if (!world.f_46443_ && (signal = this.m_6016_(state)) == 0) {
            this.m_152143_(entity, world, pos, state, signal);
        }
    }

    private void m_152143_(Entity entity, Level world, BlockPos pos, BlockState state, int signalStrength) {
        boolean shouldBePowered;
        int shouldBeSignal = this.m_6693_(world, pos);
        boolean powered = signalStrength > 0;
        boolean bl = shouldBePowered = shouldBeSignal > 0;
        if (signalStrength != shouldBeSignal) {
            BlockState blockstate = this.m_7422_(state, shouldBeSignal);
            world.m_7731_(pos, blockstate, 2);
            this.m_49291_(world, pos);
            world.m_6550_(pos, state, blockstate);
        }
        if (!shouldBePowered && powered) {
            world.m_247517_(null, pos, this.blockType.f_271234_(), SoundSource.BLOCKS);
            world.m_142346_(entity, GameEvent.f_223703_, pos);
        } else if (shouldBePowered && !powered) {
            world.m_247517_(null, pos, this.blockType.f_271481_(), SoundSource.BLOCKS);
            world.m_142346_(entity, GameEvent.f_223702_, pos);
        }
        if (shouldBePowered) {
            world.m_186460_(pos, (Block)this, this.ticks);
        }
    }

    public int m_7342_() {
        return this.ticks;
    }

    public int m_6693_(Level world, BlockPos pos) {
        AABB axisalignedbb = f_49287_.m_82338_(pos);
        Class<LivingEntity> entityClass = null;
        switch (this.sensitivity) {
            case MOBS: {
                entityClass = LivingEntity.class;
                break;
            }
            case PLAYERS: {
                entityClass = Player.class;
            }
        }
        List entities = world.m_45933_(null, axisalignedbb);
        if (entityClass != null) {
            entities = world.m_45976_(entityClass, axisalignedbb);
        }
        for (Entity entity : entities) {
            if (entity.m_6090_()) continue;
            return 15;
        }
        return 0;
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS,
        PLAYERS;

    }
}

