/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;

public class EntityObserver
extends Block
implements ModeledBlock {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)4);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public EntityObserver() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50455_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(1))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.EAST));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, POWERED, FACING});
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && state.m_61143_((Property)FACING) == side ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter reader, BlockPos pos, Direction side) {
        return state.m_60746_(reader, pos, side);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_().m_122424_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        world.m_7731_(pos, (BlockState)state.m_61122_((Property)DISTANCE), 3);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockPos readPos;
        for (int i = 1; i <= (Integer)state.m_61143_((Property)DISTANCE) && !world.m_8055_(readPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), i)).m_60815_(); ++i) {
            AABB box = new AABB(readPos, readPos.m_7918_(1, 1, 1));
            List entities = world.m_45933_(null, box);
            Boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            if (!entities.isEmpty()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered == false)), 3);
                continue;
            }
            if (!powered.booleanValue()) continue;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
        for (Direction direction : Direction.values()) {
            world.m_46672_(pos.m_121945_(direction), (Block)this);
        }
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == state.m_61143_((Property)FACING);
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.parentBlockItem(this, "entity_observer/off_1");
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        ModelFile[] offModels = new ModelFile[]{((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/off_1", generator.modLoc("block/entity_observer/parent"))).texture("top", "block/entity_observer/top_1"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/off_2", generator.modLoc("block/entity_observer/parent"))).texture("top", "block/entity_observer/top_2"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/off_3", generator.modLoc("block/entity_observer/parent"))).texture("top", "block/entity_observer/top_3"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/off_4", generator.modLoc("block/entity_observer/parent"))).texture("top", "block/entity_observer/top_4")};
        ModelFile[] onModels = new ModelFile[]{((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/on_1", generator.modLoc("block/entity_observer/parent_on"))).texture("top", "block/entity_observer/top_1"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/on_2", generator.modLoc("block/entity_observer/parent_on"))).texture("top", "block/entity_observer/top_2"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/on_3", generator.modLoc("block/entity_observer/parent_on"))).texture("top", "block/entity_observer/top_3"), ((BlockModelBuilder)modelBuilder.withExistingParent("block/entity_observer/on_4", generator.modLoc("block/entity_observer/parent_on"))).texture("top", "block/entity_observer/top_4")};
        generator.getVariantBuilder(this).forAllStates(state -> {
            int distance = (Integer)state.m_61143_((Property)DISTANCE);
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            ModelFile model = offModels[distance - 1];
            if (powered) {
                model = onModels[distance - 1];
            }
            return generator.buildVariantModel(model, facing);
        });
    }
}

