/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.redstone.blocks.Antenna;
import net.paradisemod.redstone.blocks.Transmitter;
import net.paradisemod.redstone.blocks.WireRepeater;

public class RedstoneWire
extends Block
implements SimpleWaterloggedBlock,
ModeledBlock {
    private static final VoxelShape CENTER = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape CONNECT_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape CONNECT_NORTH_NORMAL = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)4.0);
    private static final VoxelShape CONNECT_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape CONNECT_SOUTH_NORMAL = Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0, (double)16.0);
    private static final VoxelShape CONNECT_EAST = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape CONNECT_EAST_NORMAL = Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0);
    private static final VoxelShape CONNECT_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape CONNECT_WEST_NORMAL = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)6.0, (double)10.0);
    private static final VoxelShape CONNECT_UP = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape CONNECT_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final HashMap<BlockState, VoxelShape> SHAPES_CACHE = new HashMap();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final EnumProperty<Connection> NORTH = EnumProperty.m_61587_((String)"north", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.m_61587_((String)"south", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.m_61587_((String)"east", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.m_61587_((String)"west", Connection.class);
    public static final EnumProperty<BaseDirection> BASEDIR = EnumProperty.m_61587_((String)"basedir", BaseDirection.class);

    public RedstoneWire() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)Connection.NONE))).m_61124_(SOUTH, (Comparable)((Object)Connection.NONE))).m_61124_(EAST, (Comparable)((Object)Connection.NONE))).m_61124_(WEST, (Comparable)((Object)Connection.NONE))).m_61124_(BASEDIR, (Comparable)((Object)BaseDirection.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (SHAPES_CACHE.isEmpty()) {
            for (BlockState state : this.m_49965_().m_61056_()) {
                if ((Integer)state.m_61143_((Property)POWER) != 0 || state.m_61143_(BASEDIR) != BaseDirection.NONE || ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) continue;
                SHAPES_CACHE.put(state, RedstoneWire.calcShape(state));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POWER, UP, DOWN, NORTH, SOUTH, EAST, WEST, BASEDIR});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean isMoving) {
        ArrayList<Integer> adjStrengths = new ArrayList<Integer>();
        adjStrengths.add(0);
        BlockState newState = state;
        ArrayList<Direction> baseDirs = new ArrayList<Direction>();
        for (Direction facing : Direction.values()) {
            BlockPos relPos;
            BlockState relState;
            BlockPos facingPos = pos.m_121945_(facing);
            BlockState testState = world.m_8055_(facingPos);
            Block testBlock = testState.m_60734_();
            if (testBlock instanceof ObserverBlock && facing != testState.m_61143_((Property)ObserverBlock.f_52588_)) continue;
            int signal = world.m_277185_(facingPos, facing);
            if (signal <= 15) {
                adjStrengths.add(signal);
            }
            boolean connectable = testState.canRedstoneConnectTo((BlockGetter)world, facingPos, facing) || testState.m_60734_() instanceof RedstoneWire;
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case UP: {
                    BlockState blockState = (BlockState)newState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(connectable));
                    break;
                }
                case DOWN: {
                    BlockState blockState = (BlockState)newState.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(connectable));
                    break;
                }
                case EAST: {
                    BlockState blockState = (BlockState)newState.m_61124_(EAST, (Comparable)((Object)Connection.get(testState, connectable)));
                    break;
                }
                case WEST: {
                    BlockState blockState = (BlockState)newState.m_61124_(WEST, (Comparable)((Object)Connection.get(testState, connectable)));
                    break;
                }
                case NORTH: {
                    BlockState blockState = (BlockState)newState.m_61124_(NORTH, (Comparable)((Object)Connection.get(testState, connectable)));
                    break;
                }
                case SOUTH: {
                    BlockState blockState = newState = (BlockState)newState.m_61124_(SOUTH, (Comparable)((Object)Connection.get(testState, connectable)));
                }
            }
            if (connectable || !(relState = world.m_8055_(relPos = pos.m_121945_(facing))).m_60783_((BlockGetter)world, relPos, facing.m_122424_())) continue;
            baseDirs.add(facing);
        }
        BaseDirection dir = !baseDirs.isEmpty() ? BaseDirection.fromDir((Direction)baseDirs.get(0)) : BaseDirection.NONE;
        newState = (BlockState)newState.m_61124_(BASEDIR, (Comparable)((Object)dir));
        int greatestStrength = Utils.getMaxValue(adjStrengths);
        world.m_7731_(pos, (BlockState)newState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(greatestStrength)), 3);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.m_6861_(state, world, pos, null, null, false);
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction otherFacing) {
        Direction wireFacing = otherFacing.m_122424_();
        BlockState otherState = reader.m_8055_(pos.m_121945_(wireFacing));
        Block otherBlock = otherState.m_60734_();
        boolean connected = false;
        switch (wireFacing) {
            case UP: {
                if (otherBlock instanceof RedstoneWire) {
                    connected = (Boolean)state.m_61143_((Property)UP);
                    break;
                }
                connected = (Boolean)state.m_61143_((Property)DOWN);
                break;
            }
            case DOWN: {
                if (otherBlock instanceof RedstoneWire) {
                    connected = (Boolean)state.m_61143_((Property)DOWN);
                    break;
                }
                connected = (Boolean)state.m_61143_((Property)UP);
                break;
            }
            case NORTH: {
                connected = ((Connection)((Object)state.m_61143_(NORTH))).connected();
                break;
            }
            case SOUTH: {
                connected = ((Connection)((Object)state.m_61143_(SOUTH))).connected();
                break;
            }
            case EAST: {
                connected = ((Connection)((Object)state.m_61143_(EAST))).connected();
                break;
            }
            case WEST: {
                connected = ((Connection)((Object)state.m_61143_(WEST))).connected();
            }
        }
        int power = (Integer)state.m_61143_((Property)POWER) - 1;
        if (power < 0) {
            power = 0;
        }
        return connected ? power : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return SHAPES_CACHE.get(((BlockState)((BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_(BASEDIR, (Comparable)((Object)BaseDirection.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape calcShape(BlockState state) {
        VoxelShape shape = CENTER;
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_UP);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_DOWN);
        }
        if (((Connection)((Object)state.m_61143_(NORTH))).connected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_NORTH);
        }
        if (state.m_61143_(NORTH) == Connection.NORMAL) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_NORTH_NORMAL);
        }
        if (((Connection)((Object)state.m_61143_(SOUTH))).connected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_SOUTH);
        }
        if (state.m_61143_(SOUTH) == Connection.NORMAL) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_SOUTH_NORMAL);
        }
        if (((Connection)((Object)state.m_61143_(EAST))).connected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_EAST);
        }
        if (state.m_61143_(EAST) == Connection.NORMAL) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_EAST_NORMAL);
        }
        if (((Connection)((Object)state.m_61143_(WEST))).connected()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_WEST);
        }
        if (state.m_61143_(WEST) == Connection.NORMAL) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECT_WEST_NORMAL);
        }
        return shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if ((Integer)state.m_61143_((Property)POWER) > 0) {
            double d0 = (double)pos.m_123341_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + (rand.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            float f = -0.3125f;
            float d3 = f * (float)Direction.UP.m_122429_();
            float d4 = f * (float)Direction.UP.m_122431_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + (double)d3, d1, d2 + (double)d4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        ModelFile.ExistingModelFile base = generator.existingModel("redstone_wire/base");
        ModelFile.ExistingModelFile center = generator.existingModel("redstone_wire/center");
        ModelFile.ExistingModelFile link = generator.existingModel("redstone_wire/link");
        ModelFile.ExistingModelFile linkNormal = generator.existingModel("redstone_wire/link_normal");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generator.getMultipartBuilder(this).part().modelFile((ModelFile)center).addModel()).end().part().modelFile((ModelFile)base).rotationX(90).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.DOWN}).condition((Property)DOWN, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)base).rotationX(270).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.UP}).condition((Property)UP, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)base).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.NORTH}).condition(NORTH, (Comparable[])new Connection[]{Connection.NONE}).end().part().modelFile((ModelFile)base).rotationY(180).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.SOUTH}).condition(SOUTH, (Comparable[])new Connection[]{Connection.NONE}).end().part().modelFile((ModelFile)base).rotationY(90).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.EAST}).condition(EAST, (Comparable[])new Connection[]{Connection.NONE}).end().part().modelFile((ModelFile)base).rotationY(270).addModel()).condition(BASEDIR, (Comparable[])new BaseDirection[]{BaseDirection.WEST}).condition(WEST, (Comparable[])new Connection[]{Connection.NONE}).end().part().modelFile((ModelFile)link).rotationX(270).addModel()).condition((Property)UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)link).rotationX(90).addModel()).condition((Property)DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)link).rotationY(90).addModel()).condition(EAST, (Comparable[])new Connection[]{Connection.WIRE}).end().part().modelFile((ModelFile)linkNormal).rotationY(90).addModel()).condition(EAST, (Comparable[])new Connection[]{Connection.NORMAL}).end().part().modelFile((ModelFile)link).rotationY(270).addModel()).condition(WEST, (Comparable[])new Connection[]{Connection.WIRE}).end().part().modelFile((ModelFile)linkNormal).rotationY(270).addModel()).condition(WEST, (Comparable[])new Connection[]{Connection.NORMAL}).end().part().modelFile((ModelFile)link).addModel()).condition(NORTH, (Comparable[])new Connection[]{Connection.WIRE}).end().part().modelFile((ModelFile)linkNormal).addModel()).condition(NORTH, (Comparable[])new Connection[]{Connection.NORMAL}).end().part().modelFile((ModelFile)link).rotationY(180).addModel()).condition(SOUTH, (Comparable[])new Connection[]{Connection.WIRE}).end().part().modelFile((ModelFile)linkNormal).rotationY(180).addModel()).condition(SOUTH, (Comparable[])new Connection[]{Connection.NORMAL}).end();
    }

    public static enum Connection implements StringRepresentable
    {
        WIRE,
        NORMAL,
        NONE;


        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public static Connection get(BlockState testState, boolean connectable) {
            Block testBlock = testState.m_60734_();
            if (connectable) {
                if (testBlock instanceof DiodeBlock || testBlock instanceof Antenna || testBlock instanceof Transmitter || testBlock instanceof DaylightDetectorBlock) {
                    return NORMAL;
                }
                if (testState.m_60815_() || testBlock instanceof RedstoneWire || testBlock instanceof WireRepeater) {
                    return WIRE;
                }
                return NORMAL;
            }
            return NONE;
        }

        public boolean connected() {
            return this == NORMAL || this == WIRE;
        }
    }

    public static enum BaseDirection implements StringRepresentable
    {
        UP,
        DOWN,
        EAST,
        WEST,
        NORTH,
        SOUTH,
        NONE;


        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public static BaseDirection fromDir(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> DOWN;
                case Direction.UP -> UP;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
            };
        }
    }
}

