/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.data.tags.PMTags;

public class Transmitter
extends Block
implements ModeledBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty RECEIVER = BooleanProperty.m_61465_((String)"receiver");
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected final DyeColor color;
    private final int range;

    public Transmitter(DyeColor color) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50146_));
        this.range = (Integer)PMConfig.SETTINGS.redstone.transmitterRange.get();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RECEIVER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.EAST));
        this.color = color;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, RECEIVER, FACING});
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)RECEIVER)).booleanValue()) {
            boolean foundPowered = false;
            for (int i = -this.range; i <= this.range; ++i) {
                for (int j = -this.range; j <= this.range; ++j) {
                    for (int k = -this.range; k <= this.range; ++k) {
                        BlockPos newPos = pos.m_7918_(i, j, k);
                        BlockState testState = world.m_8055_(newPos);
                        Block block = testState.m_60734_();
                        if (!(block instanceof Transmitter)) continue;
                        Transmitter transmitter = (Transmitter)block;
                        if (transmitter.color != this.color || ((Boolean)testState.m_61143_((Property)RECEIVER)).booleanValue() || !((Boolean)testState.m_61143_((Property)POWERED)).booleanValue()) continue;
                        foundPowered = true;
                        break;
                    }
                    if (foundPowered) break;
                }
                if (foundPowered) break;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(foundPowered)), 3);
        } else {
            BlockPos adjPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            int signal = world.m_277185_(adjPos, (Direction)state.m_61143_((Property)FACING));
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal > 0)), 3);
        }
        for (Direction direction : Direction.values()) {
            world.m_46672_(pos.m_121945_(direction), (Block)this);
        }
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Boolean receiver = (Boolean)state.m_61143_((Property)RECEIVER);
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        float pitch = (Boolean)state.m_61143_((Property)RECEIVER) != false ? 0.55f : 0.5f;
        world.m_5594_(player, pos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, pitch);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)RECEIVER, (Comparable)Boolean.valueOf(receiver == false)), 3);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    public int m_6378_(BlockState state, BlockGetter read, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)RECEIVER) != false && (Boolean)state.m_61143_((Property)POWERED) != false && side == ((Direction)state.m_61143_((Property)FACING)).m_122424_() ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter reader, BlockPos pos, Direction side) {
        return this.m_6378_(state, reader, pos, side);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            double d0 = (double)pos.m_123341_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + (rand.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            float f = -0.3125f;
            float d3 = f * (float)direction.m_122429_();
            float d4 = f * (float)direction.m_122431_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + (double)d3, d1, d2 + (double)d4, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return;
        }
        Transmitter.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        return blockBelow.m_204336_(PMTags.Blocks.GROUND_BLOCKS);
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.basicItem(this.m_5456_(), "transmitter/" + this.color.m_41065_());
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/transmitter/" + this.color.m_41065_(), generator.modLoc("block/transmitter/parent"))).texture("texture", "block/transmitter/" + this.color.m_41065_());
        BlockModelBuilder modelOn = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/transmitter/" + this.color.m_41065_() + "_on", generator.modLoc("block/transmitter/parent_on"))).texture("texture", "block/transmitter/" + this.color.m_41065_());
        BlockModelBuilder receiverModel = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/transmitter/" + this.color.m_41065_() + "_receiver", generator.modLoc("block/transmitter/parent_receiver"))).texture("texture", "block/transmitter/" + this.color.m_41065_());
        BlockModelBuilder receiverModelOn = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/transmitter/" + this.color.m_41065_() + "_receiver_on", generator.modLoc("block/transmitter/parent_receiver_on"))).texture("texture", "block/transmitter/" + this.color.m_41065_());
        generator.getVariantBuilder(this).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            boolean receiver = (Boolean)state.m_61143_((Property)RECEIVER);
            if (powered && receiver) {
                return generator.buildVariantModel((ModelFile)receiverModelOn, facing, true);
            }
            if (receiver) {
                return generator.buildVariantModel((ModelFile)receiverModel, facing, true);
            }
            if (powered) {
                return generator.buildVariantModel((ModelFile)modelOn, facing, true);
            }
            return generator.buildVariantModel((ModelFile)model, facing, true);
        });
    }
}

