/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.redstone.blocks.EntityObserver;
import net.paradisemod.redstone.blocks.RedstoneWire;
import net.paradisemod.redstone.blocks.Transmitter;

public class WireRepeater
extends Block
implements SimpleWaterloggedBlock,
ModeledBlock {
    private static final VoxelShape SHAPE_NS = Block.m_49796_((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0, (double)14.0);
    private static final VoxelShape SHAPE_EW = Block.m_49796_((double)2.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0);
    private static final VoxelShape SHAPE_UD = Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty DELAY = BlockStateProperties.f_61413_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public WireRepeater() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)DELAY, (Comparable)Integer.valueOf(1))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, FACING, DELAY, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean waterlogged = fluid.m_76152_() == Fluids.f_76193_;
        Direction facing = ctx.m_7820_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return side == facing || side == facing.m_122424_();
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            double d0 = (double)pos.m_123341_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + (rand.m_188500_() - 0.5) * 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + (rand.m_188500_() - 0.5) * 0.2;
            float f = -0.3125f;
            float d3 = f * (float)direction.m_122429_();
            float d4 = f * (float)direction.m_122431_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + (double)d3, d1, d2 + (double)d4, 0.0, 0.0, 0.0);
        }
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction otherFacing) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && otherFacing == ((Direction)state.m_61143_((Property)FACING)).m_122424_() ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter reader, BlockPos pos, Direction side) {
        return this.m_6378_(state, reader, pos, side);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.m_6861_(state, world, pos, null, null, false);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean isMoving) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos behind = pos.m_121945_(facing.m_122424_());
        BlockState testState = world.m_8055_(behind);
        Direction relFacing = WireRepeater.getRelativeDirecion(testState, facing);
        int signal = world.m_277185_(behind, relFacing);
        if (testState.m_60734_() instanceof RedstoneWire) {
            signal = (Integer)testState.m_61143_((Property)RedstoneWire.POWER);
        }
        if (signal == 0) {
            world.m_186464_(pos, (Block)this, (Integer)state.m_61143_((Property)DELAY) * 2, TickPriority.VERY_HIGH);
        } else {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos behind = pos.m_121945_(facing.m_122424_());
        BlockState testState = world.m_8055_(behind);
        int signal = 0;
        if (testState.m_60734_() instanceof RedstoneWire) {
            signal = (Integer)testState.m_61143_((Property)RedstoneWire.POWER);
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal > 0)), 3);
    }

    private static Direction getRelativeDirecion(BlockState state, Direction dir) {
        Block testBlock = state.m_60734_();
        return testBlock instanceof RedstoneWire || testBlock instanceof RedStoneWireBlock || testBlock instanceof DiodeBlock || testBlock instanceof Transmitter || testBlock instanceof ObserverBlock || testBlock instanceof EntityObserver || testBlock instanceof WireRepeater ? dir.m_122424_() : dir;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        int delay = (Integer)state.m_61143_((Property)DELAY);
        delay = delay == 4 ? 1 : ++delay;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)DELAY, (Comparable)Integer.valueOf(delay)), 3);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NS;
            case Direction.EAST, Direction.WEST -> SHAPE_EW;
            default -> SHAPE_UD;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.parentBlockItem(this, "wire_repeater/1");
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        ModelFile[] offModels = new ModelFile[]{generator.existingModel("wire_repeater/1"), generator.existingModel("wire_repeater/2"), generator.existingModel("wire_repeater/3"), generator.existingModel("wire_repeater/4")};
        ModelFile[] onModels = new ModelFile[]{generator.existingModel("wire_repeater/1_on"), generator.existingModel("wire_repeater/2_on"), generator.existingModel("wire_repeater/3_on"), generator.existingModel("wire_repeater/4_on")};
        generator.getVariantBuilder(this).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            int delay = (Integer)state.m_61143_((Property)DELAY);
            ModelFile model = offModels[delay - 1];
            if (powered) {
                model = onModels[delay - 1];
            }
            return generator.buildVariantModel(model, facing);
        }, new Property[]{WATERLOGGED});
    }
}

