/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks.superpiston;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.redstone.Redstone;
import net.paradisemod.redstone.blocks.superpiston.SuperPistonStructure;
import net.paradisemod.redstone.tile.SuperPistonEntity;

public class SuperPiston
extends PistonBaseBlock
implements ModeledBlock {
    private final boolean sticky;

    public SuperPiston(boolean sticky) {
        super(sticky, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50039_));
        this.sticky = sticky;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_60153_) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_) {
            this.extendIfPowered(world, pos, state);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !world.f_46443_ && world.m_7702_(pos) == null) {
            this.extendIfPowered(world, pos, state);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.f_46443_) {
            this.extendIfPowered(world, pos, state);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        if (!world.f_46443_) {
            boolean flag = this.isNeighborPowered(world, pos, direction);
            if (flag && (id == 1 || id == 2)) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_60153_, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.m_60181_(world, pos, direction, true)) {
                return false;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_60153_, (Comparable)Boolean.valueOf(true)), 67);
            world.m_5594_(null, pos, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.25f + 0.6f);
            world.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)state));
        } else if (id == 1 || id == 2) {
            BlockEntity blockentity1 = world.m_7702_(pos.m_121945_(direction));
            if (blockentity1 instanceof SuperPistonEntity) {
                SuperPistonEntity piston = (SuperPistonEntity)blockentity1;
                piston.m_60401_();
            }
            BlockState blockstate = (BlockState)((BlockState)Redstone.MOVING_SUPER_PISTON.get().m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)direction)).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.sticky ? PistonType.STICKY : PistonType.DEFAULT));
            world.m_7731_(pos, blockstate, 20);
            world.m_151523_((BlockEntity)new SuperPistonEntity(pos, blockstate, (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.m_122376_((int)(param & 7))), direction, false, true));
            world.m_6289_(pos, blockstate.m_60734_());
            blockstate.m_60701_((LevelAccessor)world, pos, 2);
            if (this.sticky) {
                SuperPistonEntity piston;
                BlockEntity blockentity;
                BlockPos blockpos = pos.m_7918_(direction.m_122429_() * 2, direction.m_122430_() * 2, direction.m_122431_() * 2);
                BlockState blockstate1 = world.m_8055_(blockpos);
                boolean flag1 = false;
                if (blockstate1.m_60713_(Redstone.MOVING_SUPER_PISTON.get()) && (blockentity = world.m_7702_(blockpos)) instanceof SuperPistonEntity && (piston = (SuperPistonEntity)blockentity).m_60392_() == direction && piston.m_60387_()) {
                    piston.m_60401_();
                    flag1 = true;
                }
                if (!flag1) {
                    if (id != 1 || blockstate1.m_60795_() || !SuperPiston.m_60204_((BlockState)blockstate1, (Level)world, (BlockPos)blockpos, (Direction)direction.m_122424_(), (boolean)false, (Direction)direction) || blockstate1.m_60811_() != PushReaction.NORMAL && !blockstate1.m_60713_(Redstone.SUPER_PISTON.get()) && !blockstate1.m_60713_(Redstone.STICKY_SUPER_PISTON.get())) {
                        world.m_7471_(pos.m_121945_(direction), false);
                    } else {
                        this.m_60181_(world, pos, direction, false);
                    }
                }
            } else {
                world.m_7471_(pos.m_121945_(direction), false);
            }
            world.m_5594_(null, pos, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.15f + 0.6f);
            world.m_220407_(GameEvent.f_223703_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
        }
        return true;
    }

    private boolean isNeighborPowered(Level world, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !world.m_276987_(pos.m_121945_(direction), direction)) continue;
            return true;
        }
        if (world.m_276987_(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.m_7494_();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !world.m_276987_(blockpos.m_121945_(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    private boolean m_60181_(Level world, BlockPos pos, Direction dir, boolean extending) {
        SuperPistonStructure structure;
        BlockPos blockpos = pos.m_121945_(dir);
        if (!extending && world.m_8055_(blockpos).m_60713_(Redstone.SUPER_PISTON_HEAD.get())) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 20);
        }
        if (!(structure = new SuperPistonStructure(world, pos, dir, extending)).resolve()) {
            return false;
        }
        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
        List<BlockPos> list = structure.getToPush();
        ArrayList<BlockState> list1 = new ArrayList<BlockState>();
        for (BlockPos blockpos1 : list) {
            BlockState blockstate = world.m_8055_(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = structure.getToDestroy();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = extending ? dir : dir.m_122424_();
        int j = 0;
        for (int k = list2.size() - 1; k >= 0; --k) {
            BlockPos blockpos2 = list2.get(k);
            BlockState blockState = world.m_8055_(blockpos2);
            BlockEntity tile = blockState.m_155947_() ? world.m_7702_(blockpos2) : null;
            SuperPiston.m_49892_((BlockState)blockState, (LevelAccessor)world, (BlockPos)blockpos2, (BlockEntity)tile);
            world.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 18);
            if (!blockState.m_204336_(BlockTags.f_13076_)) {
                world.m_142052_(blockpos2, blockState);
            }
            ablockstate[j++] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockState = world.m_8055_(blockpos3);
            blockpos3 = blockpos3.m_121945_(direction);
            map.remove(blockpos3);
            BlockState blockstate8 = (BlockState)Redstone.MOVING_SUPER_PISTON.get().m_49966_().m_61124_((Property)f_52588_, (Comparable)dir);
            world.m_7731_(blockpos3, blockstate8, 68);
            world.m_151523_((BlockEntity)new SuperPistonEntity(blockpos3, blockstate8, (BlockState)list1.get(l), dir, extending, false));
            ablockstate[j++] = blockState;
        }
        if (extending) {
            PistonType pistontype = this.sticky ? PistonType.STICKY : PistonType.DEFAULT;
            Iterator<Object> movedState = (BlockState)((BlockState)Redstone.SUPER_PISTON_HEAD.get().m_49966_().m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)dir)).m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)pistontype);
            BlockState blockState = (BlockState)((BlockState)Redstone.MOVING_SUPER_PISTON.get().m_49966_().m_61124_((Property)MovingPistonBlock.f_60046_, (Comparable)dir)).m_61124_((Property)MovingPistonBlock.f_60047_, (Comparable)(this.sticky ? PistonType.STICKY : PistonType.DEFAULT));
            map.remove(blockpos);
            world.m_7731_(blockpos, blockState, 68);
            world.m_151523_((BlockEntity)new SuperPistonEntity(blockpos, blockState, (BlockState)movedState, dir, true, true));
        }
        BlockState blockstate3 = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos : map.keySet()) {
            world.m_7731_(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)entry.getValue();
            blockstate2.m_60758_((LevelAccessor)world, blockpos5, 2);
            blockstate3.m_60701_((LevelAccessor)world, blockpos5, 2);
            blockstate3.m_60758_((LevelAccessor)world, blockpos5, 2);
        }
        j = 0;
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[j++];
            BlockPos blockpos6 = list2.get(i1);
            blockState.m_60758_((LevelAccessor)world, blockpos6, 2);
            world.m_46672_(blockpos6, blockState.m_60734_());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            world.m_46672_(list.get(j1), ablockstate[j++].m_60734_());
        }
        if (extending) {
            world.m_46672_(blockpos, Redstone.SUPER_PISTON_HEAD.get());
        }
        return true;
    }

    private void extendIfPowered(Level world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        boolean powered = this.hasPower(world, pos, facing);
        if (powered && !((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
            SuperPistonStructure structure = new SuperPistonStructure(world, pos, facing, true);
            if (structure.resolve()) {
                world.m_7696_(pos, (Block)this, 0, facing.m_122411_());
            }
        } else if (!powered && ((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
            SuperPistonEntity piston;
            BlockEntity tile;
            BlockPos facingPos = pos.m_5484_(facing, 2);
            BlockState facingState = world.m_8055_(facingPos);
            int i = 1;
            if (facingState.m_60713_(Redstone.MOVING_SUPER_PISTON.get()) && facingState.m_61143_((Property)f_52588_) == facing && (tile = world.m_7702_(facingPos)) instanceof SuperPistonEntity && (piston = (SuperPistonEntity)tile).m_60387_() && (piston.m_60350_(0.0f) < 0.5f || world.m_46467_() == piston.m_60402_() || ((ServerLevel)world).m_8874_())) {
                i = 2;
            }
            world.m_7696_(pos, (Block)this, i, facing.m_122411_());
        }
    }

    private boolean hasPower(Level world, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !world.m_276987_(pos.m_121945_(direction), direction)) continue;
            return true;
        }
        if (world.m_276987_(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.m_7494_();
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !world.m_276987_(blockpos.m_121945_(direction), direction)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPush(BlockState state, Level world, BlockPos pos, Direction facing, boolean shouldDestroy, Direction dir) {
        List<Block> pistons = List.of(Blocks.f_50039_, Blocks.f_50032_, Redstone.SUPER_PISTON.get(), Redstone.STICKY_SUPER_PISTON.get());
        if (pos.m_123342_() >= world.m_141937_() && pos.m_123342_() <= world.m_151558_() - 1 && world.m_6857_().m_61937_(pos)) {
            if (state.m_60795_()) {
                return true;
            }
            if (facing == Direction.DOWN && pos.m_123342_() == world.m_141937_()) {
                return false;
            }
            if (facing == Direction.UP && pos.m_123342_() == world.m_151558_() - 1) {
                return false;
            }
            if (!pistons.contains(state.m_60734_())) {
                if (state.m_60800_((BlockGetter)world, pos) == -1.0f) {
                    return false;
                }
                switch (state.m_60811_()) {
                    case DESTROY: {
                        return shouldDestroy;
                    }
                    case BLOCK: 
                    case PUSH_ONLY: {
                        return facing == dir;
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)f_60153_)).booleanValue()) {
                return false;
            }
            return !state.m_155947_();
        }
        return false;
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)generator.getBuilder((this.sticky ? "sticky_" : "") + "super_piston")).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:block/cube_bottom_top"))).texture("bottom", "paradisemod:block/super_piston/bottom")).texture("side", "paradisemod:block/super_piston/side")).texture("top", "paradisemod:block/super_piston/top" + (this.sticky ? "_sticky" : ""));
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String topTexture = "paradisemod:block/super_piston/top" + (this.sticky ? "_sticky" : "");
        String bottomTexture = "paradisemod:block/super_piston/bottom";
        String sideTexture = "paradisemod:block/super_piston/side";
        String insideTexture = "paradisemod:block/super_piston/inner";
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder pistonModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/" + (this.sticky ? "sticky" : "normal"), "block/template_piston")).texture("platform", topTexture)).texture("bottom", bottomTexture)).texture("side", sideTexture);
        BlockModelBuilder extendedModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/extended", "block/piston_extended")).texture("bottom", bottomTexture)).texture("side", sideTexture)).texture("inside", insideTexture);
        generator.getVariantBuilder((Block)this).forAllStates(state -> {
            boolean extended = (Boolean)state.m_61143_((Property)f_60153_);
            Direction facing = (Direction)state.m_61143_((Property)f_52588_);
            if (extended) {
                return generator.buildVariantModel((ModelFile)extendedModel, facing);
            }
            return generator.buildVariantModel((ModelFile)pistonModel, facing);
        });
    }
}

