/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks.superpiston;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.redstone.Redstone;

public class SuperPistonHead
extends PistonHeadBlock
implements ModeledBlock {
    public SuperPistonHead() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50040_));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockstate = world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_()));
        return this.fitsBase(state, blockstate) || blockstate.m_60713_(Redstone.MOVING_SUPER_PISTON.get()) && blockstate.m_61143_((Property)f_52588_) == state.m_61143_((Property)f_52588_);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        if (!world.f_46443_ && player.m_150110_().f_35937_ && this.fitsBase(state, world.m_8055_(blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_())))) {
            world.m_46961_(blockpos, false);
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, isMoving);
            BlockPos basePos = pos.m_121945_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
            if (this.fitsBase(state, world.m_8055_(basePos))) {
                world.m_46961_(basePos, true);
            }
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_61143_((Property)f_60235_) == PistonType.DEFAULT ? new ItemStack((ItemLike)Redstone.SUPER_PISTON.get().m_5456_()) : new ItemStack((ItemLike)Redstone.STICKY_SUPER_PISTON.get().m_5456_());
    }

    private boolean fitsBase(BlockState headState, BlockState baseState) {
        RegisteredBlock block = headState.m_61143_((Property)f_60235_) == PistonType.DEFAULT ? Redstone.SUPER_PISTON : Redstone.STICKY_SUPER_PISTON;
        return baseState.m_60713_(block.get()) && (Boolean)baseState.m_61143_((Property)PistonBaseBlock.f_60153_) != false && baseState.m_61143_((Property)f_52588_) == headState.m_61143_((Property)f_52588_);
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String topTexture = "paradisemod:block/super_piston/top";
        String sideTexture = "paradisemod:block/super_piston/side";
        BlockModelProvider modelBuilder = generator.models();
        BlockModelBuilder headModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/head", "block/template_piston_head")).texture("platform", topTexture)).texture("side", sideTexture)).texture("unsticky", topTexture);
        BlockModelBuilder headShortModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/head_short", "block/template_piston_head_short")).texture("platform", topTexture)).texture("side", sideTexture)).texture("unsticky", topTexture);
        BlockModelBuilder stickyHeadModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/head_sticky", "block/template_piston_head")).texture("platform", topTexture)).texture("side", sideTexture)).texture("unsticky", topTexture);
        BlockModelBuilder stickyHeadShortModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/super_piston/head_sticky_short", "block/template_piston_head_short")).texture("platform", topTexture)).texture("side", sideTexture)).texture("unsticky", topTexture);
        generator.getVariantBuilder((Block)this).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)f_52588_);
            boolean isShort = (Boolean)state.m_61143_((Property)f_60236_);
            PistonType type = (PistonType)state.m_61143_((Property)f_60235_);
            if (isShort && type == PistonType.STICKY) {
                return generator.buildVariantModel((ModelFile)stickyHeadShortModel, facing);
            }
            if (isShort) {
                return generator.buildVariantModel((ModelFile)headShortModel, facing);
            }
            if (type == PistonType.STICKY) {
                return generator.buildVariantModel((ModelFile)stickyHeadModel, facing);
            }
            return generator.buildVariantModel((ModelFile)headModel, facing);
        });
    }
}

