/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.blocks.superpiston;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.paradisemod.base.PMConfig;
import net.paradisemod.redstone.blocks.superpiston.SuperPiston;

public class SuperPistonStructure {
    private final Level world;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos startPos;
    private final Direction pushDirection;
    private final ArrayList<BlockPos> toPush = new ArrayList();
    private final ArrayList<BlockPos> toDestroy = new ArrayList();
    private final Direction pistonDirection;
    private final int maxBlocks;

    public SuperPistonStructure(Level world, BlockPos pistonPos, Direction pistonDirection, boolean extending) {
        this.maxBlocks = (Integer)PMConfig.SETTINGS.redstone.superPistonPushLimit.get();
        this.world = world;
        this.pistonPos = pistonPos;
        this.pistonDirection = pistonDirection;
        this.extending = extending;
        if (extending) {
            this.pushDirection = pistonDirection;
            this.startPos = pistonPos.m_121945_(pistonDirection);
        } else {
            this.pushDirection = pistonDirection.m_122424_();
            this.startPos = pistonPos.m_5484_(pistonDirection, 2);
        }
    }

    public boolean resolve() {
        this.toPush.clear();
        this.toDestroy.clear();
        BlockState blockstate = this.world.m_8055_(this.startPos);
        if (!SuperPiston.canPush(blockstate, this.world, this.startPos, this.pushDirection, false, this.pistonDirection)) {
            if (this.extending && blockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int i = 0; i < this.toPush.size(); ++i) {
            BlockPos pushPos = this.toPush.get(i);
            if (!this.world.m_8055_(pushPos).isStickyBlock() || this.addBranchingBlocks(pushPos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos originPos, Direction direction) {
        BlockState blockstate = this.world.m_8055_(originPos);
        if (this.world.m_46859_(originPos)) {
            return true;
        }
        if (!SuperPiston.canPush(blockstate, this.world, originPos, this.pushDirection, false, direction)) {
            return true;
        }
        if (originPos.equals((Object)this.pistonPos)) {
            return true;
        }
        if (this.toPush.contains(originPos)) {
            return true;
        }
        int i = 1;
        if (i + this.toPush.size() > this.maxBlocks) {
            return false;
        }
        while (blockstate.isStickyBlock()) {
            BlockPos blockpos = originPos.m_5484_(this.pushDirection.m_122424_(), i);
            BlockState oldState = blockstate;
            blockstate = this.world.m_8055_(blockpos);
            if (blockstate.m_60795_() || !oldState.canStickTo(blockstate) || !SuperPiston.canPush(blockstate, this.world, blockpos, this.pushDirection, false, this.pushDirection.m_122424_()) || blockpos.equals((Object)this.pistonPos)) break;
            if (++i + this.toPush.size() <= this.maxBlocks) continue;
            return false;
        }
        int l = 0;
        for (int i1 = i - 1; i1 >= 0; --i1) {
            this.toPush.add(originPos.m_5484_(this.pushDirection.m_122424_(), i1));
            ++l;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int j;
            if ((j = this.toPush.indexOf(blockpos1 = originPos.m_5484_(this.pushDirection, j1))) > -1) {
                this.reorderListAtCollision(l, j);
                for (int k = 0; k <= j + l; ++k) {
                    BlockPos blockpos2 = this.toPush.get(k);
                    if (!this.world.m_8055_(blockpos2).isStickyBlock() || this.addBranchingBlocks(blockpos2)) continue;
                    return false;
                }
                return true;
            }
            blockstate = this.world.m_8055_(blockpos1);
            if (blockstate.m_60795_()) {
                return true;
            }
            if (!SuperPiston.canPush(blockstate, this.world, blockpos1, this.pushDirection, true, this.pushDirection) || blockpos1.equals((Object)this.pistonPos)) {
                return false;
            }
            if (blockstate.m_60811_() == PushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                return true;
            }
            if (this.toPush.size() >= this.maxBlocks) {
                return false;
            }
            this.toPush.add(blockpos1);
            ++l;
            ++j1;
        }
    }

    private void reorderListAtCollision(int offsets, int index) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.toPush.subList(0, index));
        ArrayList<BlockPos> list1 = new ArrayList<BlockPos>(this.toPush.subList(this.toPush.size() - offsets, this.toPush.size()));
        ArrayList<BlockPos> list2 = new ArrayList<BlockPos>(this.toPush.subList(index, this.toPush.size() - offsets));
        this.toPush.clear();
        this.toPush.addAll(list);
        this.toPush.addAll(list1);
        this.toPush.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos fromPos) {
        BlockState blockstate = this.world.m_8055_(fromPos);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (direction.m_122434_() == this.pushDirection.m_122434_() || !(blockstate1 = this.world.m_8055_(blockpos = fromPos.m_121945_(direction))).canStickTo(blockstate) || this.addBlockLine(blockpos, direction)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getToPush() {
        return this.toPush;
    }

    public List<BlockPos> getToDestroy() {
        return this.toDestroy;
    }
}

