/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.redstone.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.paradisemod.redstone.Redstone;
import net.paradisemod.redstone.tile.SuperPistonEntity;

public class SuperPistonRenderer
implements BlockEntityRenderer<SuperPistonEntity> {
    private BlockRenderDispatcher blockRenderer;

    public SuperPistonRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(SuperPistonEntity piston, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = piston.m_58904_();
        if (world != null) {
            BlockPos pistonPos = piston.m_58899_().m_121945_(piston.m_60399_().m_122424_());
            BlockState movedState = piston.m_60400_();
            if (!movedState.m_60795_()) {
                ModelBlockRenderer.m_111000_();
                matrixStack.m_85836_();
                matrixStack.m_252880_(piston.m_60380_(partialTicks), piston.m_60385_(partialTicks), piston.m_60388_(partialTicks));
                if (movedState.m_60713_(Redstone.SUPER_PISTON_HEAD.get()) && piston.m_60350_(partialTicks) <= 4.0f) {
                    movedState = (BlockState)movedState.m_61124_((Property)PistonHeadBlock.f_60236_, (Comparable)Boolean.valueOf(piston.m_60350_(partialTicks) <= 0.5f));
                    this.renderBlock(pistonPos, movedState, matrixStack, buffer, world, false, combinedOverlay);
                } else if (piston.m_60397_() && !piston.m_60387_()) {
                    PistonType type = movedState.m_60713_(Redstone.STICKY_SUPER_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT;
                    BlockState pistonHead = (BlockState)((BlockState)((BlockState)Redstone.SUPER_PISTON_HEAD.get().m_49966_().m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)type)).m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)((Direction)movedState.m_61143_((Property)PistonBaseBlock.f_52588_)))).m_61124_((Property)PistonHeadBlock.f_60236_, (Comparable)Boolean.valueOf(piston.m_60350_(partialTicks) >= 0.5f));
                    this.renderBlock(pistonPos, pistonHead, matrixStack, buffer, world, false, combinedOverlay);
                    BlockPos destPos = pistonPos.m_121945_(piston.m_60399_());
                    matrixStack.m_85849_();
                    matrixStack.m_85836_();
                    movedState = (BlockState)movedState.m_61124_((Property)PistonBaseBlock.f_60153_, (Comparable)Boolean.valueOf(true));
                    this.renderBlock(destPos, movedState, matrixStack, buffer, world, true, combinedOverlay);
                } else {
                    this.renderBlock(pistonPos, movedState, matrixStack, buffer, world, false, combinedOverlay);
                }
                matrixStack.m_85849_();
                ModelBlockRenderer.m_111077_();
            }
        }
    }

    private void renderBlock(BlockPos pos, BlockState state, PoseStack matrixStack, MultiBufferSource buffer, Level world, boolean checkSides, int combinedOverlay) {
        if (this.blockRenderer == null) {
            this.blockRenderer = Minecraft.m_91087_().m_91289_();
        }
        ForgeHooksClient.renderPistonMovedBlocks((BlockPos)pos, (BlockState)state, (PoseStack)matrixStack, (MultiBufferSource)buffer, (Level)world, (boolean)checkSides, (int)combinedOverlay, (BlockRenderDispatcher)this.blockRenderer);
    }
}

