/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.blocks.CrystalCluster;

public class CrystalClusters {
    public static final RegisteredBlock DIAMOND_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("diamond", (ItemLike)Items.f_42415_);
    public static final RegisteredBlock EMERALD_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("emerald", (ItemLike)Items.f_42616_);
    public static final RegisteredBlock HONEY_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("honey", Misc.HONEY_CRYSTAL);
    public static final RegisteredBlock LAPIS_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("lapis", (ItemLike)Items.f_42534_);
    public static final RegisteredBlock QUARTZ_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("quartz", (ItemLike)Items.f_42692_);
    public static final RegisteredBlock REDSTONE_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("redstone", (ItemLike)Items.f_42451_);
    public static final RegisteredBlock RUBY_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("ruby", Misc.RUBY);
    public static final RegisteredBlock SALT_CRYSTAL_CLUSTER = CrystalClusters.regCrystalCluster("salt", Misc.SALT_ITEM);
    public static final RegisteredBlock ENDER_PEARL_CLUSTER = CrystalClusters.regCrystalCluster("ender_pearl", (ItemLike)Items.f_42584_);

    public static void init() {
    }

    private static RegisteredBlock regCrystalCluster(String name, ItemLike item) {
        Object regName = name.equals("ender_pearl") ? "ender_pearl_cluster" : name + "_crystal_cluster";
        RegisteredBlock crystal = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem((String)regName, () -> new CrystalCluster(name == "ender_pearl", name == "redstone")).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).itemModel((arg_0, arg_1) -> CrystalClusters.lambda$regCrystalCluster$1((String)regName, name, arg_0, arg_1)).blockStateGenerator((block, generator) -> {
            BlockModelProvider modelBuilder = generator.models();
            ModelFile[] models = new ModelFile[]{((BlockModelBuilder)modelBuilder.withExistingParent("block/crystal_cluster/" + name + "_0", new ResourceLocation("paradisemod:block/template/crystal_0"))).texture("texture", "paradisemod:block/crystal_cluster/" + name), ((BlockModelBuilder)modelBuilder.withExistingParent("block/crystal_cluster/" + name + "_1", new ResourceLocation("paradisemod:block/template/crystal_1"))).texture("texture", "paradisemod:block/crystal_cluster/" + name), ((BlockModelBuilder)modelBuilder.withExistingParent("block/crystal_cluster/" + name + "_2", new ResourceLocation("paradisemod:block/template/crystal_2"))).texture("texture", "paradisemod:block/crystal_cluster/" + name), ((BlockModelBuilder)modelBuilder.withExistingParent("block/crystal_cluster/" + name + "_3", new ResourceLocation("paradisemod:block/template/crystal_3"))).texture("texture", "paradisemod:block/crystal_cluster/" + name)};
            generator.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
                Direction facing = (Direction)state.m_61143_((Property)CrystalCluster.f_52588_);
                int crystalType = (Integer)state.m_61143_((Property)CrystalCluster.TYPE);
                return generator.buildVariantModelFacingUp(models[crystalType], facing);
            }, new Property[]{CrystalCluster.WATERLOGGED});
        }).lootTable((block, generator) -> generator.randomItemDrop((Block)block, item, 4)).localizedName((String)(name.equals("ender_pearl") ? "Ender Pearl Cluster" : Utils.localizedMaterialName(name, false) + " Crystal Cluster"), "Racimo de " + Utils.localizedMaterialName(name, true));
        if (name != "honey" && name != "ender_pearl") {
            crystal = crystal.tag(PMTags.Blocks.CRYSTAL_CLUSTERS);
        }
        return crystal;
    }

    private static /* synthetic */ void lambda$regCrystalCluster$1(String regName, String name, RegisteredBlock block, ItemModelGenerator generator) {
        generator.withExistingParent(regName, new ResourceLocation("paradisemod:block/crystal_cluster/" + name + "_0"));
    }
}

