/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.eventbus.api.IEventBus;
import net.paradisemod.base.BlockTemplates;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Events;
import net.paradisemod.base.blocks.CustomPlant;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredCreativeTab;
import net.paradisemod.building.Slabs;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.world.blocks.SpreadableBlock;
import net.paradisemod.world.trees.BlackenedOakTree;
import net.paradisemod.world.trees.BlackenedSpruceTree;
import net.paradisemod.world.trees.GlowingOakTree;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class DeepDarkBlocks {
    public static final RegisteredCreativeTab DEEP_DARK_TAB = new RegisteredCreativeTab("deep_dark", () -> DARKSTONE, "Deep Dark Blocks", "Bloques del oscuro profundo");
    public static final RegisteredBlock DARKSTONE = (RegisteredBlock)((RegisteredBlock)BlockTemplates.improvedRock("darkstone").tab(DEEP_DARK_TAB)).tags(BlockTags.f_144274_, PMTags.Blocks.GROUND_BLOCKS).itemTags(ItemTags.f_13166_, ItemTags.f_13165_).localizedName("Darkstone", "Piedra oscura");
    public static final RegisteredBlock POLISHED_DARKSTONE = (RegisteredBlock)((RegisteredBlock)BlockTemplates.improvedRock("polished_darkstone", DARKSTONE).tab(DEEP_DARK_TAB)).localizedName("Polished Darkstone", "Piedra oscura pulida");
    public static final RegisteredBlock POLISHED_DARKSTONE_BRICKS = (RegisteredBlock)((RegisteredBlock)BlockTemplates.cutImprovedRock("polished_darkstone_bricks", POLISHED_DARKSTONE, DARKSTONE).tab(DEEP_DARK_TAB)).localizedName("Polished Darkstone Bricks", "Ladrillos de piedra oscura pulida");
    public static final RegisteredBlock CHISELED_POLISHED_DARKSTONE = (RegisteredBlock)((RegisteredBlock)BlockTemplates.cutImprovedRock("chiseled_polished_darkstone", POLISHED_DARKSTONE, DARKSTONE).tab(DEEP_DARK_TAB)).localizedName("Chiseled Polished Darkstone", "Piedra oscura pulida grabada");
    public static final RegisteredBlock BLACKENED_SAND = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("blackened_sand", () -> new FallingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(BlockTags.f_144283_, BlockTags.f_13029_).localizedName("Blackened Sand", "Arena ennegrecida");
    public static final RegisteredBlock BLACKENED_SANDSTONE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("blackened_sandstone").tab(DEEP_DARK_TAB)).tag(PMTags.Blocks.GROUND_BLOCKS).localizedName("Blackened Sandstone", "Arenisca ennegrecida")).blockStateGenerator((block, generator) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("blackened_sandstone", "block/cube_bottom_top")).texture("side", "paradisemod:block/blackened_sandstone")).texture("top", "paradisemod:block/blackened_sandstone_top")).texture("bottom", "paradisemod:block/blackened_sandstone_bottom");
        generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
    }).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("ss").m_126130_("ss").m_126127_(Character.valueOf('s'), (ItemLike)BLACKENED_SAND));
    public static final RegisteredBlock CUT_BLACKENED_SANDSTONE = ((RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("cut_blackened_sandstone", BLACKENED_SANDSTONE).tab(DEEP_DARK_TAB)).tag(PMTags.Blocks.GROUND_BLOCKS).localizedName("Cut Blackened Sandstone", "Arenisca ennegrecida cortada")).blockStateGenerator((block, generator) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("cut_blackened_sandstone", "block/cube_column")).texture("side", "paradisemod:block/cut_blackened_sandstone")).texture("end", "paradisemod:block/blackened_sandstone_top");
        generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
    });
    public static final RegisteredBlock CHISELED_BLACKENED_SANDSTONE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("chiseled_blackened_sandstone").tab(DEEP_DARK_TAB)).tag(PMTags.Blocks.GROUND_BLOCKS).localizedName("Chiseled Blackened Sandstone", "Arenisca ennegrecida grabada")).blockStateGenerator((block, generator) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("chiseled_blackened_sandstone", "block/cube_column")).texture("side", "paradisemod:block/chiseled_blackened_sandstone")).texture("end", "paradisemod:block/blackened_sandstone_top");
        generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
    }).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)Slabs.BLACKENED_SANDSTONE_SLAB))).stonecutterRecipes(BLACKENED_SANDSTONE, CUT_BLACKENED_SANDSTONE);
    public static final RegisteredBlock SMOOTH_BLACKENED_SANDSTONE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)BlockTemplates.rock("smooth_blackened_sandstone").tab(DEEP_DARK_TAB)).tag(PMTags.Blocks.GROUND_BLOCKS).localizedName("Smooth Blackened Sandstone", "Arenisca ennegrecida lisa")).blockStateGenerator((block, generator) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("block/smooth_blackened_sandstone", "block/cube_all")).texture("all", "paradisemod:block/blackened_sandstone_top");
        generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
    }).stonecutterRecipes(BLACKENED_SANDSTONE, CUT_BLACKENED_SANDSTONE);
    public static final RegisteredBlock REGENERATION_STONE = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("regeneration_stone", () -> new Block(BlockType.STONE.getProperties().m_60953_(s -> 7)){

        public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity creature = (LivingEntity)entity;
            creature.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100));
        }
    }).tab(DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_144282_).localizedName("Regeneration Stone", "Piedra de regeneraci\u00f3n");
    public static final RegisteredBlock DARK_MAGMA_BLOCK = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("dark_magma_block", () -> new MagmaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50450_))).tab(DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_144282_).localizedName("Dark Magma Block", "Bloque oscuro de magma");
    public static final RegisteredBlock GLOWING_NYLIUM = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowing_nylium", () -> new SpreadableBlock(DARKSTONE.get(), (TagKey)PMTags.Blocks.GLOWING_FOLIAGE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_).m_60953_(s -> 7)){

        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            world.m_7260_(pos, state, state, 8);
        }
    }).tab(DEEP_DARK_TAB)).tags(BlockTags.f_144282_, BlockTags.f_144274_, BlockTags.f_13057_, PMTags.Blocks.GROUND_BLOCKS).blockStateGenerator((block, generator) -> {
        BlockModelProvider modelBuilder = generator.models();
        ModelFile.ExistingModelFile model = generator.existingModel("glowing_nylium");
        BlockModelBuilder snowy = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.cubeBottomTop("snowy_glowing_nylium", new ResourceLocation("paradisemod:block/snowy_overgrown_darkstone_side"), new ResourceLocation("paradisemod:block/darkstone"), generator.mcLoc("block/grass_block_top"))).renderType("cutout");
        generator.getVariantBuilder(block.get()).forAllStates(state -> {
            boolean isBlockSnowy = (Boolean)state.m_61143_((Property)SpreadableBlock.f_56637_);
            if (isBlockSnowy) {
                return generator.buildVariantModel((ModelFile)snowy);
            }
            return generator.buildVariantModel((ModelFile)model);
        });
    }).lootTable((block, generator) -> generator.dropUnlessSilkTouch((Block)block, DARKSTONE)).localizedName("Glowing Nylium", "Nilio brillante");
    public static final RegisteredBlock OVERGROWN_DARKSTONE = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("overgrown_darkstone", () -> new SpreadableBlock(DARKSTONE.get(), PMTags.Blocks.BLACKENED_FOLIAGE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_))).tab(DEEP_DARK_TAB)).tags(BlockTags.f_144282_, BlockTags.f_144274_, BlockTags.f_13057_, PMTags.Blocks.GROUND_BLOCKS).blockStateGenerator((block, generator) -> generator.grassBlockLike((RegisteredBlock)block, "paradisemod:block/darkstone", true)).lootTable((block, generator) -> generator.dropUnlessSilkTouch((Block)block, DARKSTONE)).localizedName("Overgrown Darkstone", "Piedra ocura sobrecrecida");
    public static final RegisteredBlock GLOWING_SHRUB = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowing_shrub", () -> new CustomPlant(false, CustomPlant.Type.DEEP_DARK, 7){

        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            world.m_7260_(pos, state, state, 8);
        }
    }).tab(DEEP_DARK_TAB)).tags(BlockTags.f_278411_, PMTags.Blocks.GLOWING_FOLIAGE).blockStateGenerator((block, generator) -> generator.tintedGrass((RegisteredBlock)block)).itemModelAlreadyExists().localizedName("Glowing Shrub", "Arbusto brillante");
    public static final RegisteredBlock BLACKENED_SHRUB = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("blackened_shrub", () -> new CustomPlant(false, true, CustomPlant.Type.DEEP_DARK)).tab(DEEP_DARK_TAB)).tags(BlockTags.f_278411_, PMTags.Blocks.BLACKENED_FOLIAGE).blockStateGenerator((block, generator) -> generator.tintedGrass((RegisteredBlock)block)).itemModelAlreadyExists().localizedName("Blackened Shrub", "Arbusto ennegrecido");
    public static final RegisteredBlock GLOWSHROOM_BLOCK = DeepDarkBlocks.getGlowshroomBlock(false);
    public static final RegisteredBlock GLOWSHROOM_STEM = DeepDarkBlocks.getGlowshroomBlock(true);
    public static final RegisteredBlock GLOWSHROOM = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowshroom", () -> new MushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50073_).m_60953_(s -> 7).m_60955_(), PMFoliage.HUGE_GLOWSHROOM)).tab(DEEP_DARK_TAB)).blockStateGenerator((block, generator) -> generator.simpleBlock((RegisteredBlock)block, (ModelFile)generator.existingModel("glowshroom"))).itemModel((block, generator) -> generator.flatBlockItem("glowshroom")).tag(PMTags.Blocks.GLOWING_FOLIAGE).localizedName("Glowshroom", "Hongo brillante");
    public static final RegisteredBlock STRIPPED_BLACKENED_OAK_LOG = (RegisteredBlock)BlockTemplates.strippedLog("blackened_oak", false, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_LOG = (RegisteredBlock)BlockTemplates.log("blackened_oak", false, STRIPPED_BLACKENED_OAK_LOG, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock STRIPPED_BLACKENED_OAK_WOOD = (RegisteredBlock)BlockTemplates.strippedLog("blackened_oak", true, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_WOOD = (RegisteredBlock)BlockTemplates.log("blackened_oak", true, STRIPPED_BLACKENED_OAK_WOOD, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_SAPLING = Decoration.regSapling("blackened_oak", (AbstractTreeGrower)new BlackenedOakTree(), true, false);
    public static final RegisteredBlock BLACKENED_OAK_LEAVES = (RegisteredBlock)BlockTemplates.leaves("blackened_oak", "oak", BLACKENED_OAK_SAPLING, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_OAK_PLANKS = (RegisteredBlock)BlockTemplates.planks("blackened_oak", false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock STRIPPED_BLACKENED_SPRUCE_LOG = (RegisteredBlock)BlockTemplates.strippedLog("blackened_spruce", false, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_LOG = (RegisteredBlock)BlockTemplates.log("blackened_spruce", false, STRIPPED_BLACKENED_SPRUCE_LOG, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock STRIPPED_BLACKENED_SPRUCE_WOOD = (RegisteredBlock)BlockTemplates.strippedLog("blackened_spruce", true, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_WOOD = (RegisteredBlock)BlockTemplates.log("blackened_spruce", true, STRIPPED_BLACKENED_SPRUCE_WOOD, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_SAPLING = Decoration.regSapling("blackened_spruce", new BlackenedSpruceTree(), true, false);
    public static final RegisteredBlock BLACKENED_SPRUCE_LEAVES = (RegisteredBlock)BlockTemplates.leaves("blackened_spruce", "spruce", BLACKENED_SPRUCE_SAPLING, false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock BLACKENED_SPRUCE_PLANKS = (RegisteredBlock)BlockTemplates.planks("blackened_spruce", false).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock STRIPPED_GLOWING_OAK_LOG = (RegisteredBlock)BlockTemplates.strippedLog("glowing_oak", false, true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_LOG = (RegisteredBlock)BlockTemplates.log("glowing_oak", false, STRIPPED_GLOWING_OAK_LOG, true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock STRIPPED_GLOWING_OAK_WOOD = (RegisteredBlock)BlockTemplates.strippedLog("glowing_oak", true, true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_WOOD = (RegisteredBlock)BlockTemplates.log("glowing_oak", true, STRIPPED_GLOWING_OAK_WOOD, true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_SAPLING = Decoration.regSapling("glowing_oak", new GlowingOakTree(), true, true);
    public static final RegisteredBlock GLOWING_OAK_LEAVES = (RegisteredBlock)BlockTemplates.leaves("glowing_oak", "oak", GLOWING_OAK_SAPLING, true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_OAK_PLANKS = (RegisteredBlock)BlockTemplates.planks("glowing_oak", true).tab(DEEP_DARK_TAB);
    public static final RegisteredBlock GLOWING_CACTUS = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowing_cactus", () -> new CactusBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50128_).m_60953_(s -> 7)){

        public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
            BlockState plant = plantable.getPlant(world, pos.m_121945_(facing));
            if (plant.m_60734_() == this) {
                return state.m_60713_((Block)this) || state.m_204336_(BlockTags.f_13029_);
            }
            return false;
        }
    }).tab(DEEP_DARK_TAB)).blockStateGenerator((block, generator) -> generator.simpleBlock((RegisteredBlock)block, (ModelFile)generator.existingModel("glowing_cactus"))).localizedName("Glowing Cactus", "Cactus brillante");
    public static final RegisteredBlock GLOWING_CACTUS_BLOCK = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("glowing_cactus_block", () -> new Block(BlockType.WOOD.getProperties().m_60953_(s -> 7))).tab(DEEP_DARK_TAB)).tag((TagKey<Block>)BlockTags.f_13090_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("cc").m_126130_("cc").m_126127_(Character.valueOf('c'), (ItemLike)GLOWING_CACTUS))).localizedName("Glowing Cactus Block", "Bloque de cactus brillante");

    public static void init(IEventBus eventbus) {
        Events.registerRainbowBlocks(GLOWING_NYLIUM, GLOWING_OAK_LEAVES, GLOWING_SHRUB);
        Events.registerBasicColoredBlocks(0x1A1A1A, BLACKENED_OAK_LEAVES, BLACKENED_SHRUB);
        Events.registerBasicColoredBlocks(0x363636, BLACKENED_SPRUCE_LEAVES);
    }

    private static RegisteredBlock getGlowshroomBlock(boolean isStem) {
        String name = "glowshroom_" + (isStem ? "stem" : "block");
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name, () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_).m_60953_(s -> 7).m_60955_()){

            public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
                return adjacentBlockState.m_60713_((Block)this);
            }
        }).tab(DEEP_DARK_TAB)).itemModel((block, generator) -> ((ItemModelBuilder)generator.withExistingParent(name, "minecraft:block/cube_all")).texture("all", "paradisemod:block/" + name)).blockStateGenerator((block, generator) -> {
            BlockModelProvider modelBuilder = generator.models();
            BlockModelBuilder outside = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("glowshroom_" + (isStem ? "stem" : "block"), "block/template_single_face")).texture("texture", "block/glowshroom_" + (isStem ? "stem" : "block"))).renderType("translucent");
            BlockModelBuilder inside = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("glowshroom_block_inside", "block/template_single_face")).texture("texture", "block/glowshroom_block_inside")).renderType("translucent");
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generator.getMultipartBuilder(block.get()).part().modelFile((ModelFile)outside).addModel()).condition((Property)HugeMushroomBlock.f_54127_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outside).rotationY(90).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54128_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outside).rotationY(180).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54129_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outside).rotationY(270).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54130_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outside).rotationX(270).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54131_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)outside).rotationX(90).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54132_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)inside).addModel()).condition((Property)HugeMushroomBlock.f_54127_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)inside).rotationY(90).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54128_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)inside).rotationY(180).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54129_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)inside).rotationY(270).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54130_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)inside).rotationX(270).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54131_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)inside).rotationX(90).uvLock(true).addModel()).condition((Property)HugeMushroomBlock.f_54132_, (Comparable[])new Boolean[]{false}).end();
        }).lootTable((block, generator) -> generator.dropUnlessSilkTouch((Block)block, GLOWSHROOM)).localizedName("Glowshroom " + (isStem ? "Stem" : "Block"), (isStem ? "Tallo" : "Bloque") + " de hongo brillante");
    }
}

