/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.misc.Misc;
import net.paradisemod.world.DeepDarkBlocks;

public class Ores {
    public static final RegisteredBlock END_RUBY_ORE = Ores.createOre("end_ruby", Blocks.f_50089_, (Tier)Tiers.IRON);
    public static final RegisteredBlock ENDERITE_ORE = Ores.createOre("enderite", Blocks.f_50089_, (Tier)Tiers.DIAMOND);
    public static final RegisteredBlock NETHER_SILVER_ORE = Ores.createOre("nether_silver", Blocks.f_49998_, (Tier)Tiers.WOOD);
    public static final RegisteredBlock RUBY_ORE = Ores.createOre("ruby", Blocks.f_50089_, (Tier)Tiers.IRON);
    public static final RegisteredBlock SALT_ORE = Ores.createOre("salt", Blocks.f_49997_, (Tier)Tiers.WOOD);
    public static final RegisteredBlock SILVER_ORE = Ores.createOre("silver", Blocks.f_49995_, (Tier)Tiers.STONE);
    public static final RegisteredBlock DEEPSLATE_RUBY_ORE = Ores.createOre("deepslate_ruby", Blocks.f_152474_, (Tier)Tiers.IRON);
    public static final RegisteredBlock DEEPSLATE_SALT_ORE = Ores.createOre("deepslate_salt", Blocks.f_152469_, (Tier)Tiers.WOOD);
    public static final RegisteredBlock DEEPSLATE_SILVER_ORE = Ores.createOre("deepslate_silver", Blocks.f_152467_, (Tier)Tiers.STONE);
    public static final RegisteredBlock DARKSTONE_COAL_ORE = (RegisteredBlock)Ores.createOre("darkstone_coal", Blocks.f_49997_, (Tier)Tiers.WOOD).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock DARKSTONE_GOLD_ORE = (RegisteredBlock)Ores.createOre("darkstone_gold", Blocks.f_49995_, (Tier)Tiers.IRON).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock DARKSTONE_IRON_ORE = (RegisteredBlock)Ores.createOre("darkstone_iron", Blocks.f_49996_, (Tier)Tiers.STONE).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock DARKSTONE_SILVER_ORE = (RegisteredBlock)Ores.createOre("darkstone_silver", Blocks.f_49995_, (Tier)Tiers.IRON).tab(DeepDarkBlocks.DEEP_DARK_TAB);
    public static final RegisteredBlock BLAZE_BLOCK = Ores.createResourceBlock("blaze", BlockType.WEAK_METAL, true);
    public static final RegisteredBlock ENDERITE_BLOCK = Ores.createResourceBlock("enderite", BlockType.NETHERITE_LIKE, false);
    public static final RegisteredBlock COMPACT_SALT_BLOCK = Ores.createResourceBlock("compact_salt", BlockType.STONE, false);
    public static final RegisteredBlock RUBY_BLOCK = Ores.createResourceBlock("ruby", BlockType.METAL, false);
    public static final RegisteredBlock RUSTED_IRON_BLOCK = Ores.createResourceBlock("rusted_iron", BlockType.WEAK_METAL, false);
    public static final RegisteredBlock SILVER_BLOCK = Ores.createResourceBlock("silver", BlockType.METAL, false);
    public static final RegisteredBlock SALT_BLOCK = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("salt_block", () -> new FallingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("ss").m_126130_("ss").m_126127_(Character.valueOf('s'), (ItemLike)Misc.SALT_ITEM))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(BlockTags.f_144283_, PMTags.Blocks.GROUND_BLOCKS).localizedName("Salt Block", "Bloque de sal");

    public static void init() {
    }

    private static RegisteredBlock createOre(String name, Block mimic, Tier toolTier) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        if (name.contains("gold")) {
            tags.add(BlockTags.f_13043_);
        }
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)mimic))).lootTable((block, generator) -> {
            ItemLike drop = Ores.getDrop(name);
            if (drop != null) {
                generator.randomItemDrop((Block)block, drop, name.endsWith("ruby") || name == "darkstone_coal" ? 1 : 4);
            } else {
                generator.m_245724_((Block)block);
            }
        }).blockStateGenerator((block, generator) -> generator.simpleBlock(block.get(), "ore/" + name)).itemModel((block, generator) -> generator.parentBlockItem((RegisteredBlock)block, "ore/" + name)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(tags).tags(BlockTags.f_144282_, toolTier.getTag()).localizedName(Ores.localizedName(name, false) + " Ore", "Mineral de " + Ores.localizedName(name, true));
    }

    private static RegisteredBlock createResourceBlock(String name, BlockType type, boolean glows) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>(type.tags());
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_block", () -> new Block(type.getProperties().m_60953_(s -> glows ? 15 : 0))).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_126127_(Character.valueOf('i'), Ores.resourceBlockItem(name)))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(tags).tag((TagKey<Block>)BlockTags.f_13079_).localizedName(Ores.localizedName(name, false) + " Block", "Bloque de " + Ores.localizedName(name, true));
    }

    @Nullable
    private static ItemLike getDrop(String oreName) {
        return switch (oreName) {
            case "ruby", "end_ruby", "deepslate_ruby" -> Misc.RUBY;
            case "salt", "deepslate_salt" -> Misc.SALT_ITEM;
            case "darkstone_coal" -> Items.f_42413_;
            case "nether_silver" -> Misc.SILVER_NUGGET;
            default -> null;
        };
    }

    private static ItemLike resourceBlockItem(String name) {
        return switch (name) {
            case "blaze" -> Items.f_42593_;
            case "enderite" -> Misc.ENDERITE_INGOT;
            case "compact_salt" -> Misc.SALT_ITEM;
            case "ruby" -> Misc.RUBY;
            case "rusted_iron" -> Misc.RUSTED_IRON_INGOT;
            case "silver" -> Misc.SILVER_INGOT;
            default -> (ItemLike)Utils.modErrorTyped("The resource block type " + name + " has no item!");
        };
    }

    private static String localizedName(String name, boolean spanish) {
        if (spanish) {
            return switch (name) {
                case "blaze" -> "polvo de fuego";
                case "ruby", "end_ruby", "deepslate_ruby" -> "rub\u00ed";
                case "enderite" -> "metal del Fin";
                case "silver", "nether_silver", "deepslate_silver", "darkstone_silver" -> "plata";
                case "salt", "deepslate_salt" -> "sal";
                case "compact_salt" -> "sal compacta";
                case "darkstone_coal" -> "carb\u00f3n";
                case "darkstone_iron" -> "hierro";
                case "darkstone_gold" -> "oro";
                case "rusted_iron" -> "hierro oxidado";
                default -> "";
            };
        }
        return switch (name) {
            case "blaze" -> "Blaze";
            case "ruby", "end_ruby", "deepslate_ruby" -> "Ruby";
            case "enderite" -> "Enderite";
            case "silver", "nether_silver", "deepslate_silver", "darkstone_silver" -> "Silver";
            case "salt", "deepslate_salt" -> "Salt";
            case "compact_salt" -> "Compact Salt";
            case "darkstone_coal" -> "Coal";
            case "darkstone_iron" -> "Iron";
            case "darkstone_gold" -> "Gold";
            case "rusted_iron" -> "Rusted Iron";
            default -> "";
        };
    }
}

