/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.Events;
import net.paradisemod.base.Utils;
import net.paradisemod.base.blocks.CustomPlant;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.redstone.Buttons;
import net.paradisemod.world.CrystalClusters;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.Ores;
import net.paradisemod.world.PMWorldEvents;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.blocks.LargeCaveFormation;
import net.paradisemod.world.blocks.PMPortalBlock;
import net.paradisemod.world.blocks.PoweredAir;
import net.paradisemod.world.blocks.ShatteredRedstoneBlock;
import net.paradisemod.world.blocks.SmallCaveFormation;
import net.paradisemod.world.blocks.SpreadableBlock;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.world.fluid.PMFluids;
import net.paradisemod.worldgen.PMBiomeModifier;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.structures.PMStructures;
import net.paradisemod.worldgen.surfacerules.PMBandlands;
import net.paradisemod.worldgen.surfacerules.PMSurfaceRules;
import terrablender.api.SurfaceRuleManager;

public class PMWorld {
    public static final RegisteredBlock ANDESITE_FORMATION = PMWorld.regSmallFormation("andesite");
    public static final RegisteredBlock BASALT_FORMATION = PMWorld.regSmallFormation("basalt", SoundType.f_56718_);
    public static final RegisteredBlock BLUE_ICICLE = PMWorld.regSmallFormation("blue_icicle", SoundType.f_56744_);
    public static final RegisteredBlock DARKSTONE_FORMATION = PMWorld.regSmallFormation("darkstone");
    public static final RegisteredBlock DEEPSLATE_FORMATION = PMWorld.regSmallFormation("deepslate", SoundType.f_154677_);
    public static final RegisteredBlock TUFF_FORMATION = PMWorld.regSmallFormation("tuff", SoundType.f_154659_);
    public static final RegisteredBlock DIORITE_FORMATION = PMWorld.regSmallFormation("diorite");
    public static final RegisteredBlock GRANITE_FORMATION = PMWorld.regSmallFormation("granite");
    public static final RegisteredBlock ICICLE = PMWorld.regSmallFormation("icicle", SoundType.f_56744_);
    public static final RegisteredBlock MOSSY_COBBLESTONE_FORMATION = PMWorld.regSmallFormation("mossy_cobblestone");
    public static final RegisteredBlock NETHERRACK_FORMATION = PMWorld.regSmallFormation("netherrack", SoundType.f_56720_);
    public static final RegisteredBlock RED_SANDSTONE_FORMATION = PMWorld.regSmallFormation("red_sandstone");
    public static final RegisteredBlock SANDSTONE_FORMATION = PMWorld.regSmallFormation("sandstone");
    public static final RegisteredBlock BLACKENED_SANDSTONE_FORMATION = PMWorld.regSmallFormation("blackened_sandstone");
    public static final RegisteredBlock STONE_FORMATION = PMWorld.regSmallFormation("stone");
    public static final RegisteredBlock END_STONE_FORMATION = PMWorld.regSmallFormation("end_stone");
    public static final RegisteredBlock LARGE_ANDESITE_FORMATION = PMWorld.regLargeFormation("andesite", Blocks.f_50334_);
    public static final RegisteredBlock LARGE_BASALT_FORMATION = PMWorld.regLargeFormation("basalt", Blocks.f_50137_);
    public static final RegisteredBlock LARGE_BLUE_ICICLE = PMWorld.regLargeFormation("blue_icicle", Blocks.f_50568_);
    public static final RegisteredBlock LARGE_DARKSTONE_FORMATION = PMWorld.regLargeFormation("darkstone", DeepDarkBlocks.DARKSTONE);
    public static final RegisteredBlock LARGE_DEEPSLATE_FORMATION = PMWorld.regLargeFormation("deepslate", Blocks.f_152550_);
    public static final RegisteredBlock LARGE_TUFF_FORMATION = PMWorld.regLargeFormation("tuff", Blocks.f_152496_);
    public static final RegisteredBlock LARGE_DIORITE_FORMATION = PMWorld.regLargeFormation("diorite", Blocks.f_50228_);
    public static final RegisteredBlock LARGE_GRANITE_FORMATION = PMWorld.regLargeFormation("granite", Blocks.f_50122_);
    public static final RegisteredBlock LARGE_ICICLE = PMWorld.regLargeFormation("icicle", Blocks.f_50126_);
    public static final RegisteredBlock LARGE_MOSSY_COBBLESTONE_FORMATION = PMWorld.regLargeFormation("mossy_cobblestone", Blocks.f_50079_);
    public static final RegisteredBlock LARGE_NETHERRACK_FORMATION = PMWorld.regLargeFormation("netherrack", Blocks.f_50134_);
    public static final RegisteredBlock LARGE_RED_SANDSTONE_FORMATION = PMWorld.regLargeFormation("red_sandstone", Blocks.f_50394_);
    public static final RegisteredBlock LARGE_SANDSTONE_FORMATION = PMWorld.regLargeFormation("sandstone", Blocks.f_50062_);
    public static final RegisteredBlock LARGE_BLACKENED_SANDSTONE_FORMATION = PMWorld.regLargeFormation("blackened_sandstone", DeepDarkBlocks.BLACKENED_SANDSTONE);
    public static final RegisteredBlock LARGE_STONE_FORMATION = PMWorld.regLargeFormation("stone", Blocks.f_50069_);
    public static final RegisteredBlock LARGE_END_STONE_FORMATION = PMWorld.regLargeFormation("end_stone", Blocks.f_50259_);
    public static final RegisteredBlock SHATTERED_REDSTONE_BLOCK = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("shattered_redstone_block", ShatteredRedstoneBlock::new).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).tags(BlockTags.f_144282_, BlockTags.f_144285_).localizedName("Shattered Redstone Block", "Bloque destruido de piedra roja");
    public static final RegisteredBlock POWERED_AIR = PMRegistries.regBlock("powered_air", PoweredAir::new).blockStateGenerator((block, generator) -> generator.simpleBlock((RegisteredBlock)block, (ModelFile)generator.existingMCModel("air"))).noDrops();
    public static final RegisteredBlock OVERGROWN_END_STONE = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("overgrown_end_stone", () -> new SpreadableBlock(Blocks.f_50259_, PMTags.Blocks.END_FOLIAGE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_))).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(BlockTags.f_144282_, Tags.Blocks.END_STONES, BlockTags.f_13069_, PMTags.Blocks.GROUND_BLOCKS).blockStateGenerator((block, generator) -> generator.grassBlockLike((RegisteredBlock)block, "minecraft:block/end_stone", false)).lootTable((block, generator) -> generator.dropUnlessSilkTouch((Block)block, (ItemLike)Blocks.f_50259_)).localizedName("Overgrown End Stone", "Piedra sobrecrecida del Fin");
    public static final RegisteredBlock END_GRASS = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("end_grass", () -> new CustomPlant(false, true, CustomPlant.Type.END)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(BlockTags.f_278411_, PMTags.Blocks.END_FOLIAGE).blockStateGenerator((block, generator) -> generator.tintedGrass((RegisteredBlock)block)).localizedName("Ender Grass", "Pasto del Fin");
    public static final RegisteredBlock TALL_END_GRASS = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("tall_end_grass", () -> new CustomPlant(true, true, CustomPlant.Type.END)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).tags(BlockTags.f_278411_, PMTags.Blocks.END_FOLIAGE).blockStateGenerator((block, generator) -> generator.simpleBlock((RegisteredBlock)block, (ModelFile)generator.existingModel("tall_end_grass"))).itemModel((block, generator) -> ((ItemModelBuilder)((ItemModelBuilder)generator.getBuilder("item/tall_end_grass")).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", generator.mcLoc("block/tall_grass_top"))).localizedName("Tall Ender Grass", "Pasto alto del Fin");
    public static final RegisteredBlock OVERWORLD_CORE_PORTAL = PMWorld.regPortalBlock(PMDimensions.Type.OVERWORLD_CORE);
    public static final RegisteredBlock DEEP_DARK_PORTAL = PMWorld.regPortalBlock(PMDimensions.Type.DEEP_DARK);
    public static final RegisteredBlock ELYSIUM_PORTAL = PMWorld.regPortalBlock(PMDimensions.Type.ELYSIUM);

    public static void init(IEventBus eventbus) {
        PMDimensions.init(eventbus);
        PMFluids.init(eventbus);
        PMStructures.init(eventbus);
        PMFeatures.init(eventbus);
        PMCarvers.init(eventbus);
        PMBiomeModifier.init(eventbus);
        PMBiomes.init(eventbus);
        DeepDarkBlocks.init(eventbus);
        CrystalClusters.init();
        Ores.init();
        eventbus.addListener(event -> {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256898_, (ResourceLocation)new ResourceLocation("paradisemod:bandlands"), (Object)PMBandlands.CODEC.f_216232_());
            event.enqueueWork(() -> SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"paradisemod", (SurfaceRules.RuleSource)PMSurfaceRules.buildOverworldRules()));
        });
        MinecraftForge.EVENT_BUS.register(PMWorldEvents.class);
        Events.registerBasicColoredBlocks(2192490, END_GRASS, TALL_END_GRASS);
        ParadiseMod.LOG.info("Loaded World module");
    }

    public static void initClient(FMLClientSetupEvent event) {
        PMFluids.initClient();
    }

    public static OptionalInt getGroundLevel(LevelAccessor world, int minY, int maxY, BlockPos pos, boolean isUnderwater, Block ... groundBlocks) {
        for (int y = maxY; y > minY; --y) {
            BlockPos newPos = pos.m_175288_(y);
            BlockState block = world.m_8055_(newPos);
            BlockState blockAbove = world.m_8055_(newPos.m_7494_());
            if ((!isUnderwater || !List.of(groundBlocks).contains(block.m_60734_()) || !blockAbove.m_60713_(Blocks.f_49990_)) && (!List.of(groundBlocks).contains(block.m_60734_()) || blockAbove.m_280296_() && !blockAbove.m_204336_(BlockTags.f_13106_))) continue;
            return OptionalInt.of(y);
        }
        return OptionalInt.empty();
    }

    public static OptionalInt getGroundLevel(LevelAccessor world, int minY, int maxY, BlockPos pos, Block ... groundBlocks) {
        return PMWorld.getGroundLevel(world, minY, maxY, pos, false, groundBlocks);
    }

    public static OptionalInt getGroundLevel(LevelAccessor world, int minY, int maxY, BlockPos pos) {
        for (int y = maxY; y > minY; --y) {
            BlockPos newPos = pos.m_175288_(y);
            BlockState block = world.m_8055_(newPos);
            BlockState blockAbove = world.m_8055_(newPos.m_7494_());
            if (!block.m_204336_(PMTags.Blocks.GROUND_BLOCKS) || blockAbove.m_280296_() && !blockAbove.m_204336_(BlockTags.f_13106_) && !blockAbove.m_60713_(Decoration.PRICKLY_PEAR.get())) continue;
            return OptionalInt.of(y);
        }
        return OptionalInt.empty();
    }

    public static int getLowestY(LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        int deltaX = Math.abs(pos2.m_123341_() - pos1.m_123341_());
        int deltaZ = Math.abs(pos2.m_123343_() - pos1.m_123343_());
        ArrayList<Integer> yVals = new ArrayList<Integer>();
        for (int x = 0; x < deltaX; ++x) {
            for (int z = 0; z < deltaZ; ++z) {
                yVals.add(PMWorld.getGroundLevel(world, world.m_141937_(), world.m_151558_(), pos1.m_7918_(x, 0, z)).orElse(-64));
            }
        }
        return Utils.getMinValue(yVals);
    }

    public static int getHighestY(LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        int deltaX = Math.abs(pos2.m_123341_() - pos1.m_123341_());
        int deltaZ = Math.abs(pos2.m_123343_() - pos1.m_123343_());
        ArrayList<Integer> yVals = new ArrayList<Integer>();
        for (int x = 0; x < deltaX; ++x) {
            for (int z = 0; z < deltaZ; ++z) {
                yVals.add(PMWorld.getGroundLevel(world, world.m_141937_(), world.m_151558_(), pos1.m_7918_(x, 0, z)).orElse(-64));
            }
        }
        return Utils.getMaxValue(yVals);
    }

    public static boolean doNotReplace(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_204336_(BlockTags.f_144287_);
    }

    public static void updateBlockStates(LevelAccessor world, BlockPos pos, int sizeX, int sizeY, int sizeZ) {
        for (int x = 0; x <= sizeX; ++x) {
            for (int z = 0; z <= sizeZ; ++z) {
                for (int y = 0; y <= sizeY; ++y) {
                    BlockPos newPos = pos.m_7918_(x, y, z);
                    BlockState curState = world.m_8055_(newPos);
                    curState.m_60701_(world, newPos, 32);
                }
            }
        }
    }

    public static boolean isFiller(LevelAccessor world, BlockPos pos, boolean airOnly) {
        if (world.m_8055_(pos).m_60713_(Blocks.f_49991_) || world.m_8055_(pos).m_60713_(Blocks.f_50155_)) {
            return false;
        }
        if (airOnly && world.m_8055_(pos).m_60795_()) {
            for (Direction facing : Direction.values()) {
                if (world.m_8055_(pos.m_121945_(facing)).m_60795_()) continue;
                return false;
            }
            return true;
        }
        if (!world.m_8055_(pos).m_60815_()) {
            for (Direction facing : Direction.values()) {
                if (!world.m_8055_(pos.m_121945_(facing)).m_60815_()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isBlockExposed(LevelAccessor world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState curState = world.m_8055_(pos.m_121945_(direction));
            if (!curState.m_60795_() && !world.m_46801_(pos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInWall(LevelAccessor world, BlockPos pos) {
        int vertFacings = 0;
        int horizFacings = 0;
        for (Direction direction : Direction.values()) {
            BlockState curState = world.m_8055_(pos.m_121945_(direction));
            boolean isSolid = curState.m_280296_();
            if (direction.m_122434_() == Direction.Axis.Y && isSolid) {
                ++vertFacings;
                continue;
            }
            if (!isSolid) continue;
            ++horizFacings;
        }
        return horizFacings >= 1 && horizFacings <= 3 && vertFacings >= 1;
    }

    private static RegisteredBlock regPortalBlock(PMDimensions.Type dimType) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(dimType.getName() + "_portal", () -> new PMPortalBlock(dimType)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).renderType("translucent").recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 6).m_126130_("iii").m_126130_("ipi").m_126130_("iii").m_126127_(Character.valueOf('i'), dimType.portalCraftItem()).m_126127_(Character.valueOf('p'), (ItemLike)Items.f_42584_))).localizedName(dimType.localizedName(false) + " Portal", "Portal de " + dimType.localizedName(true));
    }

    private static RegisteredBlock regLargeFormation(String name, Supplier<Block> matchingBlock) {
        String formationName = "large_" + (String)(name.contains("icicle") ? name : name + "_formation");
        String englishName = switch (name) {
            case "icicle" -> "Large Icicle";
            case "blue_icicle" -> "Large Blue Icicle";
            default -> "Large " + Utils.localizedMaterialName(name, false) + " Cave Formation";
        };
        String spanishName = switch (name) {
            case "icicle" -> "Car\u00e1mbano grande";
            case "blue_icicle" -> "Car\u00e1mbano azul grande";
            default -> "Formaci\u00f3n grande de cueva de " + Utils.localizedMaterialName(name, true);
        };
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(formationName, () -> new LargeCaveFormation((Block)matchingBlock.get())).tab(name == "darkstone" ? DeepDarkBlocks.DEEP_DARK_TAB.key() : CreativeModeTabs.f_256776_)).itemModel((block, generator) -> generator.withExistingParent(formationName, new ResourceLocation("paradisemod:block/large_formation/" + name + "_large"))).blockStateGenerator((block, generator) -> {
            BlockModelProvider modelBuilder = generator.models();
            BlockModelBuilder small = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/large_formation/" + name + "_small", new ResourceLocation("paradisemod:block/template/large_formation_small"))).texture("texture", Buttons.texturePath(name));
            BlockModelBuilder medium = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/large_formation/" + name + "_medium", new ResourceLocation("paradisemod:block/template/large_formation_medium"))).texture("texture", Buttons.texturePath(name));
            BlockModelBuilder large = (BlockModelBuilder)((BlockModelBuilder)modelBuilder.withExistingParent("block/large_formation/" + name + "_large", new ResourceLocation("paradisemod:block/template/large_formation_large"))).texture("texture", Buttons.texturePath(name));
            if (name == "icicle") {
                small = (BlockModelBuilder)small.renderType("translucent");
                medium = (BlockModelBuilder)medium.renderType("translucent");
                large = (BlockModelBuilder)large.renderType("translucent");
            }
            PMWorld.buildLargeFormationBlockstate(block.get(), generator, (ModelFile)small, (ModelFile)medium, (ModelFile)large);
        }).noDrops().localizedName(englishName, spanishName);
    }

    private static void buildLargeFormationBlockstate(Block formation, BlockStateGenerator generator, ModelFile small, ModelFile medium, ModelFile large) {
        generator.getVariantBuilder(formation).forAllStatesExcept(state -> switch ((LargeCaveFormation.Size)((Object)((Object)state.m_61143_(LargeCaveFormation.SIZE)))) {
            default -> throw new IncompatibleClassChangeError();
            case LargeCaveFormation.Size.SMALL -> generator.buildVariantModel(small);
            case LargeCaveFormation.Size.MEDIUM -> generator.buildVariantModel(medium);
            case LargeCaveFormation.Size.LARGE -> generator.buildVariantModel(large);
        }, new Property[]{LargeCaveFormation.WATERLOGGED});
    }

    private static RegisteredBlock regLargeFormation(String name, Block matchingBlock) {
        return PMWorld.regLargeFormation(name, () -> matchingBlock);
    }

    private static RegisteredBlock regSmallFormation(String name, SoundType sound) {
        Object formationName = name.contains("icicle") ? name : name + "_formation";
        String englishName = switch (name) {
            case "icicle" -> "Icicle";
            case "blue_icicle" -> "Blue Icicle";
            default -> Utils.localizedMaterialName(name, false) + " Cave Formation";
        };
        String spanishName = switch (name) {
            case "icicle" -> "Car\u00e1mbano";
            case "blue_icicle" -> "Car\u00e1mbano azul";
            default -> "Formaci\u00f3n de cueva de " + Utils.localizedMaterialName(name, true);
        };
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem((String)formationName, () -> new SmallCaveFormation(sound)).tab(name == "darkstone" ? DeepDarkBlocks.DEEP_DARK_TAB.key() : CreativeModeTabs.f_256776_)).itemModel((arg_0, arg_1) -> PMWorld.lambda$regSmallFormation$19((String)formationName, name, arg_0, arg_1)).blockStateGenerator((block, generator) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().withExistingParent("block/formation/" + name, new ResourceLocation("paradisemod:block/template/formation"))).texture("texture", Buttons.texturePath(name));
            if (name == "icicle") {
                model = (BlockModelBuilder)model.renderType("translucent");
            }
            BlockModelBuilder newModel = model;
            generator.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
                Direction facing = (Direction)state.m_61143_((Property)SmallCaveFormation.f_52588_);
                return generator.buildVariantModelFacingUp((ModelFile)newModel, facing);
            }, new Property[]{SmallCaveFormation.WATERLOGGED});
        }).noDrops().localizedName(englishName, spanishName);
    }

    private static RegisteredBlock regSmallFormation(String name) {
        return PMWorld.regSmallFormation(name, SoundType.f_56742_);
    }

    private static /* synthetic */ void lambda$regSmallFormation$19(String formationName, String name, RegisteredBlock block, ItemModelGenerator generator) {
        generator.withExistingParent(formationName, new ResourceLocation("paradisemod:block/formation/" + name));
    }

    @FunctionalInterface
    public static interface WorldgenFactory<T> {
        public T generate(BootstapContext<T> var1);
    }
}

