/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.fml.ModList;
import net.paradisemod.base.Utils;
import net.paradisemod.base.mixin.WeightedListAccessor;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.noise.FastNoiseLite;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer0;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.LayeredNoiseUtil;
import terrablender.worldgen.noise.ZoomLayer;

public class BiomeGroup {
    protected final String name;
    protected final int numLayers;
    @Nullable
    private Registry<Biome> biomeRegistry;
    private final BiomeInit upperLayer;
    private final BiomeInit lowerLayer;
    private final ArrayList<ResourceKey<Biome>> allBiomes = new ArrayList();

    protected BiomeGroup(String name) {
        this.name = name;
        this.numLayers = switch (name) {
            case "overworld_core" -> 4;
            case "deep_dark" -> 3;
            case "elysium" -> 2;
            default -> (Integer)Utils.modErrorTyped("Biome group name \"" + name + "\" is invalid!");
        };
        this.upperLayer = new BiomeInit(false);
        this.lowerLayer = new BiomeInit(true);
        this.biomeRegistry = null;
    }

    protected void initBiomeRegistry(Registry<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
    }

    protected List<Area> genBiomes(long seed) {
        ArrayList<Area> biomeLayers = new ArrayList<Area>();
        biomeLayers.add(this.lowerLayer.genLayers(seed));
        for (int i = 1; i < this.numLayers; ++i) {
            biomeLayers.add(this.upperLayer.genLayers(seed + 420777L * (long)i));
        }
        return biomeLayers;
    }

    protected Stream<Holder<Biome>> getAllBiomes() {
        return this.allBiomes.stream().map(biome -> this.biomeRegistry.m_246971_(biome));
    }

    protected List<FastNoiseLite> getLayerNoises(long seed) {
        ArrayList<FastNoiseLite> noises = new ArrayList<FastNoiseLite>();
        for (int i = 0; i < this.numLayers - 1; ++i) {
            FastNoiseLite noise = new FastNoiseLite((int)seed + 420777 * i);
            noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
            noise.SetFrequency(0.005f);
            noises.add(noise);
        }
        return noises;
    }

    protected Holder<Biome> getBiome(Area layer, int x, int z) {
        return (Holder)this.biomeRegistry.m_203300_(layer.get(x, z)).orElseThrow();
    }

    private static SimpleWeightedRandomList<ResourceKey<Biome>> deepDarkBiomes() {
        return new SimpleWeightedRandomList.Builder().m_146271_((Object)Biomes.f_220594_, 20).m_146271_(PMBiomes.DEEP_DARK_FLATS, 10).m_146271_(PMBiomes.FROZEN_DEEP_DARK_FLATS, 10).m_146271_(PMBiomes.GLOWING_GLACIER, 10).m_146271_(PMBiomes.POLAR_WINTER, 10).m_146271_(PMBiomes.SILVA_INSOMNIUM, 10).m_146271_(PMBiomes.TAIGA_INSOMNIUM, 10).m_146271_(PMBiomes.DARK_VOLCANIC_FIELD, 10).m_146271_(PMBiomes.DARK_DESERT, 10).m_146271_(PMBiomes.GLOWING_FOREST, 5).m_146271_(PMBiomes.CRYSTAL_FOREST, 5).m_146270_();
    }

    private static SimpleWeightedRandomList<ResourceKey<Biome>> OWCBiomes(boolean lower) {
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        for (ResourceKey<Biome> biome : PMBiomes.ROSE_LANDS_BY_COLOR.values()) {
            builder = builder.m_146271_(biome, 5);
        }
        if (lower) {
            builder = builder.m_146271_(PMBiomes.WARM_UNDERGROUND_OCEAN, 10).m_146271_(PMBiomes.LUKEWARM_UNDERGROUND_OCEAN, 10).m_146271_(PMBiomes.UNDERGROUND_OCEAN, 10).m_146271_(PMBiomes.COLD_UNDERGROUND_OCEAN, 10).m_146271_(PMBiomes.FROZEN_UNDERGROUND_OCEAN, 10).m_146271_(PMBiomes.UNDERGROUND_SWAMP, 10).m_146271_(PMBiomes.UNDERGROUND_MANGROVE_SWAMP, 10);
        }
        if (ModList.get().isLoaded("quark")) {
            builder = builder.m_146271_(PMBiomes.GLIMMERING_WEALD, 10);
        }
        return builder.m_146271_((Object)Biomes.f_151784_, 10).m_146271_((Object)Biomes.f_151785_, 10).m_146271_(PMBiomes.UNDERGROUND_GRASSLAND, 10).m_146271_(PMBiomes.UNDERGROUND_DARK_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_FLOWER_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_BIRCH_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_AUTUMN_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_TAIGA, 10).m_146271_(PMBiomes.COLD_UNDERGROUND_ROCKY_DESERT, 10).m_146271_(PMBiomes.SNOWY_UNDERGROUND_ROCKY_DESERT, 10).m_146271_(PMBiomes.SNOWY_UNDERGROUND_TAIGA, 10).m_146271_(PMBiomes.UNDERGROUND_TUNDRA, 10).m_146271_(PMBiomes.ICE_SPIKES_CAVE, 10).m_146271_(PMBiomes.UNDERGROUND_GLACIER, 10).m_146271_(PMBiomes.UNDERGROUND_JUNGLE, 10).m_146271_(PMBiomes.UNDERGROUND_TEMPERATE_RAINFOREST, 10).m_146271_(PMBiomes.UNDERGROUND_DESERT, 10).m_146271_(PMBiomes.SALT_CAVE, 10).m_146271_(PMBiomes.VOLCANIC_CAVE, 10).m_146271_(PMBiomes.TERRACOTTA_CAVE, 10).m_146271_(PMBiomes.UNDERGROUND_ROCKY_DESERT, 10).m_146271_(PMBiomes.UNDERGROUND_PALO_VERDE_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_MESQUITE_FOREST, 10).m_146271_(PMBiomes.UNDERGROUND_SAVANNA, 10).m_146271_(PMBiomes.UNDERGROUND_CHERRY_FOREST, 10).m_146271_(PMBiomes.MUSHROOM_CAVE, 10).m_146271_(PMBiomes.HONEY_CAVE, 10).m_146270_();
    }

    private static SimpleWeightedRandomList<ResourceKey<Biome>> elysiumBiomes(boolean lower) {
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        for (ResourceKey<Biome> biome : PMBiomes.ROSE_FIELDS_BY_COLOR.values()) {
            builder = builder.m_146271_(biome, 5);
        }
        if (lower) {
            builder = builder.m_146271_((Object)Biomes.f_151784_, 10).m_146271_((Object)Biomes.f_151785_, 10).m_146271_(PMBiomes.SALT_DEPOSIT, 10);
            if (ModList.get().isLoaded("quark")) {
                builder = builder.m_146271_(PMBiomes.GLIMMERING_WEALD, 10);
            }
        }
        return builder.m_146271_((Object)Biomes.f_48202_, 10).m_146271_((Object)Biomes.f_48207_, 10).m_146271_((Object)Biomes.f_48151_, 10).m_146271_((Object)Biomes.f_48205_, 10).m_146271_((Object)Biomes.f_48149_, 10).m_146271_((Object)Biomes.f_48206_, 10).m_146271_((Object)Biomes.f_48152_, 10).m_146271_((Object)Biomes.f_186761_, 10).m_146271_((Object)Biomes.f_48203_, 10).m_146271_(PMBiomes.HIGH_ROCKY_DESERT, 10).m_146271_(PMBiomes.SNOWY_ROCKY_DESERT, 10).m_146271_(PMBiomes.GLACIER, 10).m_146271_(PMBiomes.SUBGLACIAL_VOLCANIC_FIELD, 10).m_146271_(PMBiomes.ROCKY_DESERT, 10).m_146271_((Object)Biomes.f_220595_, 10).m_146271_((Object)Biomes.f_271432_, 10).m_146271_((Object)Biomes.f_186762_, 7).m_146271_(PMBiomes.AUTUMN_FOREST, 5).m_146271_(PMBiomes.TEMPERATE_RAINFOREST, 5).m_146271_(PMBiomes.SALT_FLAT, 5).m_146271_(PMBiomes.VOLCANIC_FIELD, 5).m_146271_(PMBiomes.PALO_VERDE_FOREST, 5).m_146271_(PMBiomes.MESQUITE_FOREST, 5).m_146271_(PMBiomes.THE_ORIGIN, 5).m_146271_(PMBiomes.WEEPING_FOREST, 5).m_146271_(PMBiomes.FROZEN_WEEPING_FOREST, 5).m_146271_(PMBiomes.CHRISTMAS_FOREST, 5).m_146271_(PMBiomes.CONCRETE_BADLANDS, 5).m_146271_((Object)Biomes.f_48222_, 5).m_146271_((Object)Biomes.f_48179_, 5).m_146271_((Object)Biomes.f_48159_, 5).m_146271_((Object)Biomes.f_48182_, 5).m_146271_((Object)Biomes.f_48197_, 5).m_146271_((Object)Biomes.f_48215_, 5).m_146270_();
    }

    private class BiomeInit
    implements AreaTransformer0 {
        private final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> entries;
        private final int totalWeight;

        BiomeInit(boolean lower) {
            SimpleWeightedRandomList biomes = switch (BiomeGroup.this.name) {
                case "overworld_core" -> BiomeGroup.OWCBiomes(lower);
                case "deep_dark" -> BiomeGroup.deepDarkBiomes();
                case "elysium" -> BiomeGroup.elysiumBiomes(lower);
                default -> (SimpleWeightedRandomList)Utils.modErrorTyped("This should not be reached!");
            };
            this.totalWeight = ((WeightedListAccessor)biomes).totalWeight();
            this.entries = BiomeInit.getEntries((SimpleWeightedRandomList<ResourceKey<Biome>>)biomes, BiomeGroup.this.allBiomes);
        }

        public int apply(AreaContext areaContext, int x, int z) {
            Optional weightedItem = WeightedRandom.m_146314_(this.entries, (int)areaContext.nextRandom(this.totalWeight));
            WeightedEntry.Wrapper resourceKeyWrapper = (WeightedEntry.Wrapper)weightedItem.get();
            ResourceKey key = (ResourceKey)resourceKeyWrapper.m_146310_();
            return BiomeGroup.this.biomeRegistry.m_7447_((Object)((Biome)BiomeGroup.this.biomeRegistry.m_6246_(key)));
        }

        private Area genLayers(long seed) {
            LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, seed, seedModifier);
            AreaFactory factory = this.run(contextFactory.apply(1L));
            factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
            factory = LayeredNoiseUtil.zoom((long)2001L, (AreaTransformer1)ZoomLayer.FUZZY, (AreaFactory)factory, (int)3, contextFactory);
            factory = LayeredNoiseUtil.zoom((long)1001L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)factory, (int)4, contextFactory);
            return factory.make();
        }

        private static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getEntries(SimpleWeightedRandomList<ResourceKey<Biome>> biomeList, ArrayList<ResourceKey<Biome>> allBiomeList) {
            ImmutableList items = ((WeightedListAccessor)biomeList).items();
            for (WeightedEntry.Wrapper biomeItem : items) {
                ResourceKey biome = (ResourceKey)biomeItem.m_146310_();
                allBiomeList.add((ResourceKey<Biome>)biome);
            }
            return items;
        }
    }
}

