/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.common.BiomeManager;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class BiomeRegion
extends Region {
    private final HashMap<ResourceKey<Biome>, ResourceKey<Biome>> mappedBiomes = new HashMap();

    public BiomeRegion(String name) {
        super(new ResourceLocation("paradisemod", name), RegionType.OVERWORLD, 8);
    }

    public boolean addBiome(BiomeManager.BiomeType type, ResourceKey<Biome> biome) {
        ResourceKey similarVanillaBiome = switch (type) {
            case BiomeManager.BiomeType.DESERT -> Biomes.f_48203_;
            case BiomeManager.BiomeType.WARM -> Biomes.f_48205_;
            case BiomeManager.BiomeType.COOL -> Biomes.f_48206_;
            case BiomeManager.BiomeType.ICY -> Biomes.f_186761_;
            default -> Biomes.f_48202_;
        };
        return this.addBiome((ResourceKey<Biome>)similarVanillaBiome, biome);
    }

    public boolean addBiome(ResourceKey<Biome> biomeToReplace, ResourceKey<Biome> biome) {
        if (this.mappedBiomes.containsKey(biomeToReplace)) {
            return false;
        }
        this.mappedBiomes.put(biomeToReplace, biome);
        return true;
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            for (Map.Entry<ResourceKey<Biome>, ResourceKey<Biome>> entry : this.mappedBiomes.entrySet()) {
                ResourceKey<Biome> biomeToReplace = entry.getKey();
                ResourceKey<Biome> biome = entry.getValue();
                builder.replaceBiome(biomeToReplace, biome);
            }
        });
    }
}

