/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.foliage.PMFoliage;
import net.paradisemod.worldgen.structures.PMStructures;

public class DeepDarkBiome {
    public static Biome insomniumForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean taiga) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMFeatures.INSOMNIUM_FOSSIL);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMStructures.HOME);
        if (taiga) {
            genSettings.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, PMFeatures.INSOMNIUM_ROCK);
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.BLACKENED_SPRUCE_COVER);
        } else {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.LARGE_BLACKENED_FOLIAGE);
        }
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.BLACKENED_FOLIAGE);
        if (!taiga) {
            genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.PSYCHEDELIC_LAKE);
            genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.PSYCHEDELIC_LAKE_UNDERGROUND);
            genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.PSYCHEDELIC_SPRING);
        }
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, true, 0.25f, 0.0f, 5720372, 5720372, 1051650, 1051650);
    }

    public static Biome glowingForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean crystals) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMStructures.HOME);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.GLOWING_FOLIAGE);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.LARGE_GLOWING_FOLIAGE);
        if (crystals) {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.CRYSTAL_FOREST_CRYSTALS);
        }
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.PSYCHEDELIC_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.PSYCHEDELIC_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.PSYCHEDELIC_SPRING);
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, true, 0.25f, 1.0f, 2836811, 2836811, 334625, 334625);
    }

    public static Biome deepDarkFlats(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean frozen) {
        boolean downfall;
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.DDF_CRYSTALS);
        float temp = frozen ? -1.0f : 0.25f;
        boolean bl = downfall = frozen;
        if (frozen) {
            genSettings.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, PMFeatures.ICE_CHUNK);
        }
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, true, temp, (float)downfall, 2836811, 2836811, 0, 0);
    }

    public static Biome deepDarkGlacier(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.CREVASSE));
        genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.ICE_CAVES));
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMStructures.RESEARCH_BASE);
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, true, -1.0f, 1.0f, 2836811, 2836811, 723733, 723733);
    }

    public static Biome darkVolcanicField(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.VOLCANIC_DARK_LAVA_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.VOLCANIC_LAVA_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_GOLD_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_GOLD_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_SILVER_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_SILVER_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_IRON_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_IRON_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_COPPER_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_COPPER_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_BLACK_GLOWING_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_GOLD_GLOWING_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_SILVER_GLOWING_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_IRON_GLOWING_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_COPPER_GLOWING_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.DARK_MAGMA);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_TUFF);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.VOLCANIC_DARK_LAVA_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.GOLD_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.SILVER_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.IRON_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.COPPER_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.DARK_FISSURE);
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, false, 2.0f, 0.0f, 4159204, 329011, 0, 0);
    }

    public static Biome darkDesert(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        DeepDarkBiome.defaultFeatures(spawnInfo, genSettings);
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnInfo);
        return DeepDarkBiome.createBiome(genSettings, spawnInfo, false, 2.0f, 0.0f, 4159204, 329011, 0, 0);
    }

    private static void defaultFeatures(MobSpawnSettings.Builder spawnInfo, BiomeGenerationSettings.Builder genSettings) {
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20497_, 100, 2, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnInfo);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.DEEP_DARK_LAVA_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.DEEP_DARK_LAVA_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.DARK_LAVA_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.DARK_LAVA_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.GLOWING_WATER_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.GLOWING_WATER_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.WATER_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.WATER_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMStructures.SMALL_DARK_DUNGEON);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMStructures.DEEP_DARK_BLACK_CROSS);
        genSettings.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, PMStructures.DEEP_DARK_GOLD_CROSS);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.REGEN_STONE_BLOB);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.DEEP_DARK_DEEPSLATE_BLOB);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.GLOWING_WATER_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.DEEP_DARK_WATER_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.DEEP_DARK_LAVA_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.DARK_LAVA_SPRING);
        genSettings.m_255308_(GenerationStep.Carving.AIR, PMCarvers.DEEP_DARK_CAVES);
        genSettings.m_255308_(GenerationStep.Carving.AIR, PMCarvers.DEEP_DARK_CANYONS);
    }

    private static Biome createBiome(BiomeGenerationSettings.Builder genSettings, MobSpawnSettings.Builder spawnInfo, boolean hasRain, float temp, float downfall, int waterColor, int waterFogColor, int fogColor, int skyColor) {
        return new Biome.BiomeBuilder().m_264558_(hasRain).m_47609_(temp).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215729_)).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(skyColor).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnInfo.m_48381_()).m_47601_(genSettings.m_255380_()).m_47592_();
    }
}

