/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.features.foliage.PMFoliage;

public class OverworldBiome {
    public static Biome autumnForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        OverworldBiome.defaultVegetationAndSpawns(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.AUTUMN_PUMPKINS);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.AUTUMN_PLACER);
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, 0.8f, 0.4f, 4159204, 329011, 12638463, 7959834, 0.8f);
    }

    public static Biome glacier(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        genSettings.m_255308_(GenerationStep.Carving.AIR, PMCarvers.CREVASSE);
        genSettings.m_255308_(GenerationStep.Carving.AIR, PMCarvers.ICE_CAVES);
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, -0.25f, 0.4f, 4159204, 329011, 12638463, null, -0.25f);
    }

    public static Biome rockyDesert(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, RockyDesertType type) {
        int grassColor = type != RockyDesertType.NORMAL ? 9961293 : 16763981;
        float downfall = type != RockyDesertType.NORMAL ? 1.0f : 0.0f;
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, PMFeatures.DESERT_ROCK);
        if (type == RockyDesertType.NORMAL) {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.DESERT_TREES);
        } else {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.COLD_DESERT_TREES);
        }
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.RD_CACTUS);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.RD_FOLIAGE);
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnInfo);
        return OverworldBiome.createBiome(spawnInfo, genSettings, type.hasRain, type.temp, downfall, 4159204, 329011, 12638463, grassColor, 2.0f);
    }

    public static Biome roseField(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, DyeColor color) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        OverworldBiome.defaultVegetationAndSpawns(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.ROSE_FIELD_PATCHES.get(color));
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, 0.8f, 0.4f, 4159204, 329011, 12638463, null, 0.8f);
    }

    public static Biome weepingForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean isFrozen) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        OverworldBiome.defaultVegetationAndSpawns(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.WEEPING_FOREST_TREES);
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, isFrozen ? -0.25f : 0.8f, 0.4f, 0x636363, 0x636363, 0xBAB9B9, 0x848484, 0.8f);
    }

    public static Biome theOrigin(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        OverworldBiome.defaultVegetationAndSpawns(spawnInfo, genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.ORIGIN_TREES);
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, 0.8f, 0.4f, 857838, 857838, 12638463, 1502733, 0.8f);
    }

    public static Biome temperateRainforest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnInfo);
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.TEMP_RAINFOREST_TREES);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        return OverworldBiome.createBiome(spawnInfo, genSettings, true, 0.8f, 1.0f, 4159204, 329011, 12638463, 3922797, 0.8f);
    }

    public static Biome saltFlat(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnInfo);
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_SALT_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.MOLTEN_SALT_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.SALT_SPRING);
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.EXTRA_SALT_CRYSTALS);
        return OverworldBiome.createBiome(spawnInfo, genSettings, false, 2.0f, 0.0f, 12751249, 12751249, 12638463, 16763981, 2.0f);
    }

    public static Biome volcanicField(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean frozen) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        OverworldBiome.defaultFeatures(genSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)genSettings);
        if (frozen) {
            genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.CREVASSE));
            genSettings.m_254863_(GenerationStep.Carving.AIR, (Holder)carverGetter.m_255043_(PMCarvers.ICE_CAVES));
        }
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.VOLCANIC_LAVA_LAKE);
        genSettings.m_255155_(GenerationStep.Decoration.LAKES, PMFeatures.VOLCANIC_LAVA_LAKE_UNDERGROUND);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_OBSIDIAN);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_OBSIDIAN_DEEPSLATE);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_MAGMA);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_MAGMA_DEEPSLATE);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_BASALT);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_TUFF);
        genSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, PMFeatures.VOLCANIC_TUFF_DEEPSLATE);
        genSettings.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, PMFeatures.VOLCANIC_SPRING);
        if (!frozen) {
            genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFoliage.RD_CACTUS);
        }
        genSettings.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PMFeatures.FISSURE);
        return OverworldBiome.createBiome(spawnInfo, genSettings, frozen, frozen ? -1.0f : 2.0f, frozen ? 1.0f : 0.0f, 4159204, 329011, 12638463, frozen ? 9961293 : 16763981, -0.25f);
    }

    protected static void defaultFeatures(BiomeGenerationSettings.Builder genSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)genSettings);
    }

    protected static void defaultVegetationAndSpawns(MobSpawnSettings.Builder spawnInfo, BiomeGenerationSettings.Builder genSettings) {
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)genSettings);
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnInfo);
    }

    protected static Biome createBiome(MobSpawnSettings.Builder spawnInfo, BiomeGenerationSettings.Builder genSettings, boolean hasRain, float temp, float downfall, int waterColor, int waterFogcolor, int fogColor, Integer grassColor, float skyTemp) {
        BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogcolor).m_48019_(fogColor).m_48040_(OverworldBiome.getSkyColorFromTemp(skyTemp)).m_48027_(AmbientMoodSettings.f_47387_);
        if (grassColor != null) {
            effectsBuilder.m_48045_(grassColor.intValue()).m_48043_(grassColor.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(hasRain).m_47609_(temp).m_47611_(downfall).m_47603_(effectsBuilder.m_48018_()).m_47605_(spawnInfo.m_48381_()).m_47601_(genSettings.m_255380_()).m_47592_();
    }

    private static int getSkyColorFromTemp(float temp) {
        float f = temp / 3.0f;
        f = Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    protected static enum RockyDesertType {
        NORMAL(2.0f, false),
        HIGH(0.25f, true),
        SNOWY(-0.25f, true);

        private final float temp;
        private final boolean hasRain;

        private RockyDesertType(float temp, boolean hasRain) {
            this.temp = temp;
            this.hasRain = hasRain;
        }
    }
}

