/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.paradisemod.base.Utils;
import net.paradisemod.world.biome.BiomeGroup;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.noise.FastNoiseLite;
import terrablender.worldgen.noise.Area;

public class PMBiomeSource
extends BiomeSource {
    public static final Codec<PMBiomeSource> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("group").stable().forGetter(source -> source.group.name)).apply((Applicative)builder, builder.stable(PMBiomeSource::new)));
    private final BiomeGroup group;
    private long seed = 0L;
    private final ArrayList<Area> genBiomes = new ArrayList();
    private final ArrayList<FastNoiseLite> layerNoises = new ArrayList();

    public PMBiomeSource(String groupName) {
        this.group = new BiomeGroup(groupName);
    }

    protected Codec<PMBiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        this.initRegistry();
        int heightFromZero = 0;
        switch (this.group.name) {
            case "overworld_core": {
                int index = 0;
                if (y > this.layerNoiseAtBlockLevel(0, 77, x, z) && y < this.layerNoiseAtBlockLevel(1, 158, x, z)) {
                    index = 1;
                } else if (y > this.layerNoiseAtBlockLevel(1, 158, x, z) && y < this.layerNoiseAtBlockLevel(2, 239, x, z)) {
                    index = 2;
                } else if (y > this.layerNoiseAtBlockLevel(2, 239, x, z)) {
                    index = 3;
                }
                return this.group.getBiome(this.genBiomes.get(index), x, z);
            }
            case "elysium": {
                Holder<Biome> biome;
                int undergroundLevel = this.layerNoiseAtBlockLevel(0, 50, x, z);
                Area underground = this.genBiomes.get(0);
                Area ground = this.genBiomes.get(1);
                if (y < undergroundLevel && ((biome = this.group.getBiome(underground, x, z)).m_203565_(Biomes.f_151785_) || biome.m_203565_(Biomes.f_151784_) || biome.m_203565_(PMBiomes.SALT_DEPOSIT) || biome.m_203565_(PMBiomes.GLIMMERING_WEALD))) {
                    return biome;
                }
                return this.group.getBiome(ground, x, z);
            }
            case "deep_dark": {
                heightFromZero = QuartPos.m_175400_((int)144);
                break;
            }
            default: {
                Utils.modErrorTyped("Biome group name \"" + this.group.name + "\" is invalid!");
            }
        }
        int layerSize = heightFromZero / this.group.numLayers;
        int i = 1;
        for (Area genBiome : this.genBiomes) {
            float floor = -16.0f;
            float ceiling = 80.0f;
            if (i > 1) {
                floor = this.layerNoiseAtLevel(i - 2, layerSize * (i - 1), x, z);
            }
            if (i < this.group.numLayers) {
                ceiling = this.layerNoiseAtLevel(i - 1, layerSize * i, x, z);
            }
            if ((float)y > floor && (float)y < ceiling || i == this.group.numLayers) {
                return this.group.getBiome(genBiome, x, z);
            }
            ++i;
        }
        return this.group.getBiome(this.genBiomes.get(this.group.numLayers - 1), x, z);
    }

    private int layerNoiseAtLevel(int index, int level, int x, int z) {
        return level + (int)(this.layerNoises.get(index).GetNoise(x, z) * 5.0f);
    }

    private int layerNoiseAtBlockLevel(int index, int level, int x, int z) {
        return this.layerNoiseAtLevel(index, QuartPos.m_175400_((int)level), x, z);
    }

    protected Stream<Holder<Biome>> m_274359_() {
        this.initRegistry();
        return this.group.getAllBiomes();
    }

    private void initRegistry() {
        if (this.genBiomes.isEmpty() && this.layerNoises.isEmpty() && this.seed == 0L) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            this.group.initBiomeRegistry((Registry<Biome>)server.m_206579_().m_175515_(Registries.f_256952_));
            WorldData worldData = server.m_129910_();
            WorldOptions options = worldData.m_246337_();
            this.seed = options.m_245499_();
            this.genBiomes.addAll(this.group.genBiomes(this.seed));
            this.layerNoises.addAll(this.group.getLayerNoises(this.seed));
        }
    }
}

