/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.world.biome;

import com.google.common.collect.ArrayListMultimap;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.DeepDarkBiome;
import net.paradisemod.world.biome.ElysiumBiome;
import net.paradisemod.world.biome.OverworldBiome;
import net.paradisemod.world.biome.RegionGenerator;
import net.paradisemod.world.biome.UndergroundBiome;
import net.paradisemod.world.biome.UndergroundOcean;

public class PMBiomes {
    public static HashMap<ResourceKey<Biome>, BiomeFactory> BIOMES = new HashMap();
    public static ArrayListMultimap<TagKey<Biome>, ResourceKey<Biome>> TAGGED_BIOMES = ArrayListMultimap.create();
    private static final HashMap<ResourceKey<Biome>, String> ENGLISH_NAMES = new HashMap();
    private static final HashMap<ResourceKey<Biome>, String> SPANISH_NAMES = new HashMap();
    private static final RegionGenerator GENERATOR = new RegionGenerator();
    public static ResourceKey<Biome> GLIMMERING_WEALD = PMRegistries.createResourceKey(Registries.f_256952_, "quark:glimmering_weald");
    public static EnumMap<DyeColor, ResourceKey<Biome>> ROSE_FIELDS_BY_COLOR = new EnumMap(DyeColor.class);
    public static final ResourceKey<Biome> AUTUMN_FOREST = PMBiomes.regBiome("autumn_forest", "Autumn Forest", "Bosque de oto\u00f1o", OverworldBiome::autumnForest, BiomeTags.f_207611_, BiomeTags.f_207586_, BiomeTags.f_207596_, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> ROCKY_DESERT = PMBiomes.regBiome("rocky_desert", "Rocky Desert", "Desierto rocoso", (featureGetter, carverGetter) -> OverworldBiome.rockyDesert((HolderGetter<PlacedFeature>)featureGetter, carverGetter, OverworldBiome.RockyDesertType.NORMAL), PMTags.Biomes.ROCKY_DESERTS, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> HIGH_ROCKY_DESERT = PMBiomes.regBiome("high_rocky_desert", "High Rocky Desert", "Desierto rocoso alto", (featureGetter, carverGetter) -> OverworldBiome.rockyDesert((HolderGetter<PlacedFeature>)featureGetter, carverGetter, OverworldBiome.RockyDesertType.HIGH), PMTags.Biomes.COLD_ROCKY_DESERTS, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> SNOWY_ROCKY_DESERT = PMBiomes.regBiome("snowy_rocky_desert", "Snowy Rocky Desert", "Desierto rocoso nevado", (featureGetter, carverGetter) -> OverworldBiome.rockyDesert((HolderGetter<PlacedFeature>)featureGetter, carverGetter, OverworldBiome.RockyDesertType.SNOWY), Tags.Biomes.IS_SNOWY, PMTags.Biomes.COLD_ROCKY_DESERTS, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> MESQUITE_FOREST = PMBiomes.regBiome("mesquite_forest", "Mesquite Forest", "Bosque de mezquite", (featureGetter, carverGetter) -> OverworldBiome.rockyDesert((HolderGetter<PlacedFeature>)featureGetter, carverGetter, OverworldBiome.RockyDesertType.NORMAL), PMTags.Biomes.ROCKY_DESERTS, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> PALO_VERDE_FOREST = PMBiomes.regBiome("palo_verde_forest", "Palo Verde Forest", "Bosque de palo verde", (featureGetter, carverGetter) -> OverworldBiome.rockyDesert((HolderGetter<PlacedFeature>)featureGetter, carverGetter, OverworldBiome.RockyDesertType.NORMAL), PMTags.Biomes.ROCKY_DESERTS, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> SALT_FLAT = PMBiomes.regBiome("salt_flat", "Salt Flat", "Salina", OverworldBiome::saltFlat, PMTags.Biomes.SALT, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> SALT_DEPOSIT = PMBiomes.regBiome("salt_deposit", "Salt Deposit", "Dep\u00f3sito de sal", OverworldBiome::saltFlat, PMTags.Biomes.SALT, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> TEMPERATE_RAINFOREST = PMBiomes.regBiome("temperate_rainforest", "Temperate Rainforest", "Selva tropical templada", OverworldBiome::temperateRainforest, Tags.Biomes.IS_WET_OVERWORLD, BiomeTags.f_207610_, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> GLACIER = PMBiomes.regBiome("glacier", "Glacier", "Glaciar", OverworldBiome::glacier, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, BiomeTags.f_207586_, BiomeTags.f_207596_, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> VOLCANIC_FIELD = PMBiomes.regBiome("volcanic_field", "Volcanic Field", "Tierra volc\u00e1nica", (featureGetter, carverGetter) -> OverworldBiome.volcanicField((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false), PMTags.Biomes.VOLCANIC, Tags.Biomes.IS_HOT, Tags.Biomes.IS_DRY, BiomeTags.f_207586_, BiomeTags.f_207596_, BiomeTags.f_215817_);
    public static final ResourceKey<Biome> SUBGLACIAL_VOLCANIC_FIELD = PMBiomes.regBiome("subglacial_volcanic_field", "Subglacial Volcanic Field", "Tierra volc\u00e1nica debajo de glaciar", (featureGetter, carverGetter) -> OverworldBiome.volcanicField((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true), PMTags.Biomes.VOLCANIC, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, BiomeTags.f_207586_, BiomeTags.f_207596_, BiomeTags.f_215817_);
    public static EnumMap<DyeColor, ResourceKey<Biome>> ROSE_LANDS_BY_COLOR = new EnumMap(DyeColor.class);
    public static final ResourceKey<Biome> WARM_UNDERGROUND_OCEAN = PMBiomes.regBiome("warm_underground_ocean", "Warm Underground Ocean", "Oc\u00e9ano subterr\u00e1neo c\u00e1lido", (featureGetter, carverGetter) -> UndergroundOcean.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, UndergroundOcean.OceanType.WARM), Tags.Biomes.IS_HOT, Tags.Biomes.IS_WATER, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> LUKEWARM_UNDERGROUND_OCEAN = PMBiomes.regBiome("lukewarm_underground_ocean", "Lukewarm Underground Ocean", "Oc\u00e9ano subterr\u00e1neo tibio", (featureGetter, carverGetter) -> UndergroundOcean.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, UndergroundOcean.OceanType.LUKEWARM), Tags.Biomes.IS_WATER, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_OCEAN = PMBiomes.regBiome("underground_ocean", "Underground Ocean", "Oc\u00e9ano subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundOcean.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, UndergroundOcean.OceanType.NORMAL), Tags.Biomes.IS_WATER, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> COLD_UNDERGROUND_OCEAN = PMBiomes.regBiome("cold_underground_ocean", "Cold Underground Ocean", "Oc\u00e9ano subterr\u00e1neo fr\u00edo", (featureGetter, carverGetter) -> UndergroundOcean.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, UndergroundOcean.OceanType.COLD), Tags.Biomes.IS_COLD, Tags.Biomes.IS_WATER, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> FROZEN_UNDERGROUND_OCEAN = PMBiomes.regBiome("frozen_underground_ocean", "Frozen Underground Ocean", "Oc\u00e9ano subterr\u00e1neo congelado", (featureGetter, carverGetter) -> UndergroundOcean.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, UndergroundOcean.OceanType.FROZEN), Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_WATER, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_AUTUMN_FOREST = PMBiomes.regBiome("underground_autumn_forest", "Underground Autumn Forest", "Bosque subterr\u00e1neo de oto\u00f1o", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.8f, 329011, 7959834, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> UNDERGROUND_ROCKY_DESERT = PMBiomes.regBiome("underground_rocky_desert", "Underground Rocky Desert", "Desierto rocoso subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 2.0f, 329011, 16763981, false), PMTags.Biomes.ROCKY_DESERTS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> COLD_UNDERGROUND_ROCKY_DESERT = PMBiomes.regBiome("cold_underground_rocky_desert", "Cold Underground Rocky Desert", "Desierto rocoso fr\u00edo subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.25f, 329011, 9961293, false), PMTags.Biomes.COLD_ROCKY_DESERTS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> SNOWY_UNDERGROUND_ROCKY_DESERT = PMBiomes.regBiome("snowy_underground_rocky_desert", "Snowy Underground Rocky Desert", "Desierto rocoso nevado subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, -0.25f, 329011, 9961293, false), PMTags.Biomes.COLD_ROCKY_DESERTS, Tags.Biomes.IS_SNOWY, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_MESQUITE_FOREST = PMBiomes.regBiome("underground_mesquite_forest", "Underground Mesquite Forest", "Bosque subterr\u00e1neo de mezquite", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 2.0f, 329011, 16763981, false), PMTags.Biomes.ROCKY_DESERTS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_PALO_VERDE_FOREST = PMBiomes.regBiome("underground_palo_verde_forest", "Underground Palo Verde Forest", "Bosque subterr\u00e1neo de palo verde", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 2.0f, 329011, 16763981, false), PMTags.Biomes.ROCKY_DESERTS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> SALT_CAVE = PMBiomes.regBiome("salt_cave", "Salt Cave", "Cueva Salada", UndergroundBiome::saltCave, PMTags.Biomes.OVERWORLD_CORE, PMTags.Biomes.SALT);
    public static final ResourceKey<Biome> UNDERGROUND_TEMPERATE_RAINFOREST = PMBiomes.regBiome("underground_temperate_rainforest", "Underground Temperate Rainforest", "Selva tropical templada subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.8f, 329011, 3922797, false), Tags.Biomes.IS_WET, BiomeTags.f_207610_, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> VOLCANIC_CAVE = PMBiomes.regBiome("volcanic_cave", "Volcanic Cave", "Cueva volc\u00e1nica", UndergroundBiome::volcanicCave, PMTags.Biomes.OVERWORLD_CORE, PMTags.Biomes.VOLCANIC);
    public static final ResourceKey<Biome> UNDERGROUND_GLACIER = PMBiomes.regBiome("underground_glacier", "Underground Glacier", "Glaciar subterr\u00e1neo", UndergroundBiome::glacier, Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> HONEY_CAVE = PMBiomes.regBiome("honey_cave", "Honey Cave", "Cueva de miel", UndergroundBiome::honeyCave, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_GRASSLAND = PMBiomes.regBiome("underground_grassland", "Underground Grassland", "Pradera subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.8f, 4159204, 9551193, false), PMTags.Biomes.OVERWORLD_CORE, Tags.Biomes.IS_PLAINS);
    public static final ResourceKey<Biome> UNDERGROUND_DESERT = PMBiomes.regBiome("underground_desert", "Underground Desert", "Desierto subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 2.0f, 4159204, 12564309, false), Tags.Biomes.IS_DRY, Tags.Biomes.IS_HOT, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_FOREST = PMBiomes.regBiome("underground_forest", "Underground Forest", "Bosque subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.7f, 4159204, 7979098, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> UNDERGROUND_CHERRY_FOREST = PMBiomes.regBiome("underground_cherry_forest", "Underground Cherry Forest", "Bosque subterr\u00e1neo de cerezo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.7f, 4159204, 7979098, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> UNDERGROUND_TAIGA = PMBiomes.regBiome("underground_taiga", "Underground Taiga", "Taiga subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.25f, 4159204, 8828803, false), Tags.Biomes.IS_COLD, Tags.Biomes.IS_CONIFEROUS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_SWAMP = PMBiomes.regBiome("underground_swamp", "Underground Swamp", "Pantano subterr\u00e1neo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.25f, 6388580, 6975545, false), Tags.Biomes.IS_WET, Tags.Biomes.IS_SWAMP, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_MANGROVE_SWAMP = PMBiomes.regBiome("underground_mangrove_swamp", "Underground Mangrove Swamp", "Pantano subterr\u00e1neo de mangle", UndergroundBiome::undergroundMangroveSwamp, Tags.Biomes.IS_WET, Tags.Biomes.IS_SWAMP, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_TUNDRA = PMBiomes.regBiome("underground_tundra", "Underground Tundra", "Tundra subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.0f, 4159204, 8434839, false), Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> MUSHROOM_CAVE = PMBiomes.regBiome("mushroom_cave", "Mushroom Cave", "Cueva de hongo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.9f, 4159204, 5622079, true), Tags.Biomes.IS_MUSHROOM, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_JUNGLE = PMBiomes.regBiome("underground_jungle", "Underground Jungle", "Jungla subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.95f, 4159204, 5884220, false), Tags.Biomes.IS_WET, BiomeTags.f_207610_, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_BIRCH_FOREST = PMBiomes.regBiome("underground_birch_forest", "Underground Birch Forest", "Bosque subterr\u00e1neo de abedul", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.7f, 4159204, 8960871, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> UNDERGROUND_DARK_FOREST = PMBiomes.regBiome("underground_dark_forest", "Underground Dark Forest", "Bosque subterr\u00e1neo oscuro", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.7f, 4159204, 5274162, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> SNOWY_UNDERGROUND_TAIGA = PMBiomes.regBiome("snowy_underground_taiga", "Snowy Underground Taiga", "Taiga subterr\u00e1nea nevada", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.25f, 4020182, 8434839, false), Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_CONIFEROUS, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_SAVANNA = PMBiomes.regBiome("underground_savanna", "Underground Savanna", "Sabana subterr\u00e1nea", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 1.2f, 4159204, 12564309, false), BiomeTags.f_215816_, Tags.Biomes.IS_DRY, Tags.Biomes.IS_HOT, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> UNDERGROUND_FLOWER_FOREST = PMBiomes.regBiome("underground_flower_forest", "Underground Flower Forest", "Bosque subterr\u00e1neo con flores", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.7f, 4159204, 7979098, false), PMTags.Biomes.OVERWORLD_CORE, BiomeTags.f_207611_);
    public static final ResourceKey<Biome> ICE_SPIKES_CAVE = PMBiomes.regBiome("ice_spikes_cave", "Ice Spikes Cave", "Cueva de pinchos de hielo", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, -0.25f, 4159204, 8434839, false), Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> TERRACOTTA_CAVE = PMBiomes.regBiome("terracotta_cave", "Terracotta Cave", "Cueva de terracota", (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false, 2.0f, 4159204, 9470285, false), BiomeTags.f_207607_, PMTags.Biomes.OVERWORLD_CORE);
    public static final ResourceKey<Biome> DEEP_DARK_FLATS = PMBiomes.regBiome("deep_dark_flats", "Deep Dark Flats", "Tierra de oscuro profundo", (featureGetter, carverGetter) -> DeepDarkBiome.deepDarkFlats((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false), PMTags.Biomes.DEEP_DARK);
    public static final ResourceKey<Biome> FROZEN_DEEP_DARK_FLATS = PMBiomes.regBiome("frozen_deep_dark_flats", "Frozen Deep Dark Flats", "Tierra congelada de oscuro profundo", (featureGetter, carverGetter) -> DeepDarkBiome.deepDarkFlats((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true), PMTags.Biomes.DEEP_DARK, PMTags.Biomes.COLD_DEEP_DARK);
    public static final ResourceKey<Biome> SILVA_INSOMNIUM = PMBiomes.regBiome("silva_insomnium", "Silva Insomnium", "Selva Insomnium", (featureGetter, carverGetter) -> DeepDarkBiome.insomniumForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false), PMTags.Biomes.DEEP_DARK);
    public static final ResourceKey<Biome> TAIGA_INSOMNIUM = PMBiomes.regBiome("taiga_insomnium", "Taiga Insomnium", "Taiga Insomnium", (featureGetter, carverGetter) -> DeepDarkBiome.insomniumForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true), PMTags.Biomes.DEEP_DARK);
    public static final ResourceKey<Biome> GLOWING_FOREST = PMBiomes.regBiome("glowing_forest", "Glowing Forest", "Bosque brillante", (featureGetter, carverGetter) -> DeepDarkBiome.glowingForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false), PMTags.Biomes.DEEP_DARK);
    public static final ResourceKey<Biome> CRYSTAL_FOREST = PMBiomes.regBiome("crystal_forest", "Crystal Forest", "Bosque de cristales", (featureGetter, carverGetter) -> DeepDarkBiome.glowingForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true), PMTags.Biomes.DEEP_DARK);
    public static final ResourceKey<Biome> GLOWING_GLACIER = PMBiomes.regBiome("glowing_glacier", "Glowing Glacier", "Glaciar brillante", DeepDarkBiome::deepDarkGlacier, PMTags.Biomes.DEEP_DARK, PMTags.Biomes.COLD_DEEP_DARK);
    public static final ResourceKey<Biome> POLAR_WINTER = PMBiomes.regBiome("polar_winter", "Polar Winter", "Invierno polar", DeepDarkBiome::deepDarkGlacier, PMTags.Biomes.DEEP_DARK, PMTags.Biomes.COLD_DEEP_DARK);
    public static final ResourceKey<Biome> DARK_VOLCANIC_FIELD = PMBiomes.regBiome("dark_volanic_field", "Dark Volcanic Field", "Tierra volc\u00e1nica oscura", DeepDarkBiome::darkVolcanicField, PMTags.Biomes.DEEP_DARK, Tags.Biomes.IS_HOT, Tags.Biomes.IS_DRY);
    public static final ResourceKey<Biome> DARK_DESERT = PMBiomes.regBiome("dark_desert", "Dark Desert", "Desierto oscuro", DeepDarkBiome::darkDesert, PMTags.Biomes.DEEP_DARK, Tags.Biomes.IS_HOT, Tags.Biomes.IS_DRY, PMTags.Biomes.DARK_DESERTS);
    public static final ResourceKey<Biome> CHRISTMAS_FOREST = PMBiomes.regBiome("christmas_forest", "Christmas Forest", "Bosque navide\u00f1o", ElysiumBiome::christmasForest, PMTags.Biomes.ELYSIUM, Tags.Biomes.IS_SNOWY);
    public static final ResourceKey<Biome> THE_ORIGIN = PMBiomes.regBiome("the_origin", "The Origin", "El origen", OverworldBiome::theOrigin, BiomeTags.f_207586_, BiomeTags.f_207596_);
    public static final ResourceKey<Biome> WEEPING_FOREST = PMBiomes.regBiome("weeping_forest", "Weeping Forest", "Bosque llanto", (featureGetter, carverGetter) -> OverworldBiome.weepingForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, false), BiomeTags.f_207586_, BiomeTags.f_207596_);
    public static final ResourceKey<Biome> FROZEN_WEEPING_FOREST = PMBiomes.regBiome("frozen_weeping_forest", "Frozen Weeping Forest", "Bosque llanto congelado", (featureGetter, carverGetter) -> OverworldBiome.weepingForest((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true), Tags.Biomes.IS_COLD, Tags.Biomes.IS_SNOWY, BiomeTags.f_207586_, BiomeTags.f_207596_);
    public static final ResourceKey<Biome> CONCRETE_BADLANDS = PMBiomes.regBiome("concrete_badlands", "Concrete Badlands", "Badlands de concreto", ElysiumBiome::concreteBadlands, PMTags.Biomes.ELYSIUM);

    public static void init(IEventBus eventbus) {
        eventbus.addListener(PMBiomes::setupOverworldBiomes);
    }

    public static boolean isSandyDesert(Holder<Biome> biome) {
        return biome.m_203656_(Tags.Biomes.IS_DRY) && !biome.m_203656_(PMTags.Biomes.ROCKY_DESERTS) && !biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS) && !biome.m_203656_(PMTags.Biomes.SALT) && !biome.m_203656_(PMTags.Biomes.VOLCANIC) && !biome.m_203656_(BiomeTags.f_215816_) && !biome.m_203656_(BiomeTags.f_207607_) && (biome.m_203656_(BiomeTags.f_215817_) || biome.m_203656_(PMTags.Biomes.OVERWORLD_CORE));
    }

    public static boolean isRockyDesert(Holder<Biome> biome) {
        return biome.m_203656_(PMTags.Biomes.ROCKY_DESERTS) || biome.m_203656_(PMTags.Biomes.COLD_ROCKY_DESERTS);
    }

    public static void translations(PMTranslations translator) {
        for (ResourceKey<Biome> biome : BIOMES.keySet()) {
            String englishName = ENGLISH_NAMES.get(biome);
            String spanishName = SPANISH_NAMES.get(biome);
            translator.addBiome(biome, englishName, spanishName);
        }
    }

    private static void setupOverworldBiomes(FMLCommonSetupEvent event) {
        for (ResourceKey<Biome> field : ROSE_FIELDS_BY_COLOR.values()) {
            PMBiomes.setupOverworldBiome(field, BiomeManager.BiomeType.WARM, 5);
        }
        PMBiomes.setupOverworldBiome(AUTUMN_FOREST, BiomeManager.BiomeType.WARM, 3);
        PMBiomes.setupOverworldBiome(ROCKY_DESERT, BiomeManager.BiomeType.DESERT, 10);
        PMBiomes.setupOverworldBiome(HIGH_ROCKY_DESERT, BiomeManager.BiomeType.COOL, 10);
        PMBiomes.setupOverworldBiome(SNOWY_ROCKY_DESERT, BiomeManager.BiomeType.ICY, 10);
        PMBiomes.setupOverworldBiome(MESQUITE_FOREST, BiomeManager.BiomeType.DESERT, 10);
        PMBiomes.setupOverworldBiome(PALO_VERDE_FOREST, BiomeManager.BiomeType.DESERT, 10);
        PMBiomes.setupOverworldBiome(SALT_FLAT, BiomeManager.BiomeType.DESERT, 5);
        PMBiomes.setupOverworldBiome(TEMPERATE_RAINFOREST, BiomeManager.BiomeType.WARM, 15);
        PMBiomes.setupOverworldBiome(GLACIER, BiomeManager.BiomeType.ICY, 5);
        PMBiomes.setupOverworldBiome(VOLCANIC_FIELD, BiomeManager.BiomeType.DESERT, 2);
        PMBiomes.setupOverworldBiome(SUBGLACIAL_VOLCANIC_FIELD, BiomeManager.BiomeType.ICY, 2);
        PMBiomes.setupOverworldBiome(WEEPING_FOREST, BiomeManager.BiomeType.COOL, 3);
        PMBiomes.setupOverworldBiome(FROZEN_WEEPING_FOREST, BiomeManager.BiomeType.ICY, 3);
        PMBiomes.setupOverworldBiome(THE_ORIGIN, BiomeManager.BiomeType.WARM, 3);
        GENERATOR.generate();
    }

    private static ResourceKey<Biome> regBiome(String name, String englishName, String spanishName, BiomeFactory biome, TagKey<Biome> ... tags) {
        ResourceKey key = PMRegistries.createModResourceKey(Registries.f_256952_, name);
        ENGLISH_NAMES.put(key, englishName);
        SPANISH_NAMES.put(key, spanishName);
        BIOMES.put(key, biome);
        for (TagKey<Biome> tag : tags) {
            TAGGED_BIOMES.put(tag, key);
        }
        return key;
    }

    private static void setupOverworldBiome(ResourceKey<Biome> biome, BiomeManager.BiomeType type, int weight) {
        GENERATOR.addBiome(type, biome);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            Object spanishColor = PMTranslations.spanishColor(color, true);
            if (((String)spanishColor).endsWith("a") || ((String)spanishColor).endsWith("e") || ((String)spanishColor).endsWith("\u00e9")) {
                spanishColor = (String)spanishColor + "s";
            } else if (color == DyeColor.LIGHT_BLUE) {
                spanishColor = "azules claras";
            } else if (color == DyeColor.LIGHT_GRAY) {
                spanishColor = "gris claras";
            } else if (color == DyeColor.LIME) {
                spanishColor = "verdes limas";
            } else if (color != DyeColor.GRAY) {
                spanishColor = (String)spanishColor + "es";
            }
            ResourceKey<Biome> roseField = PMBiomes.regBiome(color.m_41065_() + "_rose_field", PMTranslations.englishColor(color) + " Rose Field", "Campo de rosas " + (String)spanishColor, (featureGetter, carverGetter) -> OverworldBiome.roseField((HolderGetter<PlacedFeature>)featureGetter, carverGetter, color), PMTags.Biomes.ROSE_FIELDS);
            ResourceKey<Biome> roseLand = PMBiomes.regBiome(color.m_41065_() + "_roseland", PMTranslations.englishColor(color) + " Rose Land", "Tierra de rosas " + (String)spanishColor, (featureGetter, carverGetter) -> UndergroundBiome.biome((HolderGetter<PlacedFeature>)featureGetter, carverGetter, true, 0.8f, 4159204, 9551193, false), PMTags.Biomes.OVERWORLD_CORE, Tags.Biomes.IS_PLAINS);
            ROSE_FIELDS_BY_COLOR.put(color, roseField);
            ROSE_LANDS_BY_COLOR.put(color, roseLand);
        }
    }

    @FunctionalInterface
    public static interface BiomeFactory
    extends PMWorld.WorldgenFactory<Biome> {
        @Override
        default public Biome generate(BootstapContext<Biome> context) {
            HolderGetter featureGetter = context.m_255420_(Registries.f_256988_);
            HolderGetter carverGetter = context.m_255420_(Registries.f_257003_);
            return this.generate((HolderGetter<PlacedFeature>)featureGetter, carverGetter);
        }

        public Biome generate(HolderGetter<PlacedFeature> var1, HolderGetter<ConfiguredWorldCarver<?>> var2);
    }
}

